/*
 * Decompiled with CFR 0.152.
 */
package openllet.jena;

import java.util.logging.Logger;
import openllet.core.KnowledgeBase;
import openllet.jena.PelletInfGraph;
import openllet.jena.PelletReasonerFactory;
import openllet.jena.graph.loader.DefaultGraphLoader;
import openllet.jena.graph.loader.GraphLoader;
import openllet.shared.tools.Log;
import org.apache.jena.graph.Capabilities;
import org.apache.jena.graph.Graph;
import org.apache.jena.rdf.model.InfModel;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.reasoner.BaseInfGraph;
import org.apache.jena.reasoner.InfGraph;
import org.apache.jena.reasoner.Reasoner;
import org.apache.jena.reasoner.ReasonerException;
import org.apache.jena.vocabulary.ReasonerVocabulary;

public class PelletReasoner
implements Reasoner {
    protected static Logger _logger = Log.getLogger(PelletReasoner.class);
    private final Model _reasonerCapabilities;
    private final Capabilities _graphCapabilities;
    private final Graph _schema;
    private boolean _fixedSchema;

    public PelletReasoner() {
        this(null, PelletReasonerFactory.theInstance().getCapabilities());
    }

    public PelletReasoner(Graph schema) {
        this(schema, PelletReasonerFactory.theInstance().getCapabilities());
    }

    protected PelletReasoner(Model reasonerCapabilities) {
        this(null, reasonerCapabilities);
    }

    protected PelletReasoner(Graph schema, Model reasonerCapabilities) {
        this._schema = schema;
        this._reasonerCapabilities = reasonerCapabilities;
        this._graphCapabilities = new BaseInfGraph.InfFindSafeCapabilities();
    }

    public Graph getSchema() {
        return this._schema;
    }

    public boolean isFixedSchema() {
        return this._fixedSchema;
    }

    public void setFixedSchema(boolean fixedSchema) {
        this._fixedSchema = fixedSchema;
    }

    public Reasoner bindSchema(Graph graph) throws ReasonerException {
        return new PelletReasoner(graph, this._reasonerCapabilities);
    }

    public Reasoner bindSchema(Model model) throws ReasonerException {
        return this.bindSchema(model.getGraph());
    }

    public Reasoner bindFixedSchema(Graph graph) throws ReasonerException {
        PelletReasoner reasoner = new PelletReasoner(graph, this._reasonerCapabilities);
        reasoner.setFixedSchema(true);
        return reasoner;
    }

    public Reasoner bindFixedSchema(Model model) throws ReasonerException {
        PelletReasoner reasoner = new PelletReasoner(model.getGraph(), this._reasonerCapabilities);
        reasoner.setFixedSchema(true);
        return reasoner;
    }

    public PelletInfGraph bind(Graph graph) throws ReasonerException {
        _logger.fine("In bind!");
        return new PelletInfGraph(graph, this, (GraphLoader)new DefaultGraphLoader());
    }

    public InfModel bind(Model model) throws ReasonerException {
        _logger.fine("In bind!");
        return ModelFactory.createInfModel((InfGraph)this.bind(model.getGraph()));
    }

    public PelletInfGraph bind(KnowledgeBase kb) throws ReasonerException {
        return new PelletInfGraph(kb, this, (GraphLoader)new DefaultGraphLoader());
    }

    public void setDerivationLogging(boolean enable) {
    }

    public void setParameter(Property arg0, Object arg1) {
    }

    public Model getReasonerCapabilities() {
        return this._reasonerCapabilities;
    }

    public Capabilities getGraphCapabilities() {
        return this._graphCapabilities;
    }

    public void addDescription(Model arg0, Resource arg1) {
    }

    public boolean supportsProperty(Property property) {
        Model caps = this.getReasonerCapabilities();
        if (caps == null) {
            return false;
        }
        return caps.contains(null, ReasonerVocabulary.supportsP, (RDFNode)property);
    }
}

