/*
 * Decompiled with CFR 0.152.
 */
package openllet.jena;

import java.util.Optional;
import openllet.jena.PelletReasoner;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.reasoner.ReasonerFactory;
import org.apache.jena.reasoner.ReasonerRegistry;
import org.apache.jena.vocabulary.RDFS;
import org.apache.jena.vocabulary.ReasonerVocabulary;

public class PelletReasonerFactory
implements ReasonerFactory {
    private static final String URI = "http://pellet.owldl.com";
    private static PelletReasonerFactory _theInstance = new PelletReasonerFactory();
    public static OntModelSpec THE_SPEC = new OntModelSpec(OntModelSpec.OWL_MEM);
    private volatile Optional<Model> _reasonerCapabilities = Optional.empty();

    static {
        THE_SPEC.setReasonerFactory((ReasonerFactory)_theInstance);
        ReasonerRegistry.theRegistry().register((ReasonerFactory)PelletReasonerFactory.theInstance());
    }

    public static PelletReasonerFactory theInstance() {
        return _theInstance;
    }

    private PelletReasonerFactory() {
    }

    public PelletReasoner create() {
        return new PelletReasoner(this.getCapabilities());
    }

    public PelletReasoner create(Resource configuration) {
        return new PelletReasoner(this.getCapabilities());
    }

    public Model getCapabilities() {
        if (!this._reasonerCapabilities.isPresent()) {
            this._reasonerCapabilities = Optional.of(ModelFactory.createDefaultModel());
            Resource base = this._reasonerCapabilities.get().createResource(URI);
            base.addProperty(ReasonerVocabulary.nameP, "Openllet Reasoner").addProperty(ReasonerVocabulary.descriptionP, "Reasoner that is backed by the OWL DL reasoner Openllet.").addProperty(ReasonerVocabulary.supportsP, (RDFNode)RDFS.subClassOf).addProperty(ReasonerVocabulary.supportsP, (RDFNode)RDFS.subPropertyOf).addProperty(ReasonerVocabulary.supportsP, (RDFNode)RDFS.member).addProperty(ReasonerVocabulary.supportsP, (RDFNode)RDFS.range).addProperty(ReasonerVocabulary.supportsP, (RDFNode)RDFS.domain).addProperty(ReasonerVocabulary.supportsP, (RDFNode)ReasonerVocabulary.individualAsThingP).addProperty(ReasonerVocabulary.supportsP, (RDFNode)ReasonerVocabulary.directSubClassOf).addProperty(ReasonerVocabulary.supportsP, (RDFNode)ReasonerVocabulary.directSubPropertyOf).addProperty(ReasonerVocabulary.supportsP, (RDFNode)ReasonerVocabulary.directRDFType);
        }
        return this._reasonerCapabilities.get();
    }

    public String getURI() {
        return URI;
    }
}

