/*
 * Decompiled with CFR 0.152.
 */
package openllet.jena;

import java.util.Collection;
import java.util.HashSet;
import openllet.aterm.ATermAppl;
import openllet.core.taxonomy.Taxonomy;
import openllet.core.taxonomy.TaxonomyNode;
import openllet.core.utils.TaxonomyUtils;
import openllet.jena.JenaUtils;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

public class TaxonomyExtractor {
    private final Taxonomy<ATermAppl> _taxonomyImpl;
    private Model _model;
    private boolean _includeIndividuals;

    public TaxonomyExtractor(Taxonomy<ATermAppl> taxonomy) {
        this._taxonomyImpl = taxonomy;
        this._includeIndividuals = false;
    }

    public void setIncludeIndividuals(boolean includeIndividuals) {
        this._includeIndividuals = includeIndividuals;
    }

    public Model extractModel() {
        if (this._model == null) {
            this._model = this.createExtractedModel();
        }
        return this._model;
    }

    private Model createExtractedModel() {
        Model model = ModelFactory.createDefaultModel();
        HashSet processedEquivalentClasses = new HashSet();
        for (TaxonomyNode taxonomyNode : this._taxonomyImpl.getNodes().values()) {
            if (processedEquivalentClasses.contains(taxonomyNode.getName())) continue;
            processedEquivalentClasses.addAll(taxonomyNode.getEquivalents());
            for (ATermAppl aClass : taxonomyNode.getEquivalents()) {
                Collection<ATermAppl> individuals;
                model.add(TaxonomyExtractor.classAssertion(model, aClass));
                for (TaxonomyNode superNode : taxonomyNode.getSupers()) {
                    model.add(TaxonomyExtractor.subClassOfAssertion(model, aClass, (ATermAppl)superNode.getName()));
                }
                if (taxonomyNode.getEquivalents().size() > 1) {
                    for (ATermAppl equivalentClass : taxonomyNode.getEquivalents()) {
                        if (equivalentClass.equals((Object)aClass)) continue;
                        model.add(TaxonomyExtractor.equivalentClassAssertion(model, aClass, equivalentClass));
                    }
                }
                if (!this._includeIndividuals || (individuals = TaxonomyExtractor.getDatumInstanceAsCollectorOfATermAppl((TaxonomyNode<ATermAppl>)taxonomyNode)) == null || individuals.isEmpty()) continue;
                for (ATermAppl individual : individuals) {
                    model.add(TaxonomyExtractor.typeAssertion(model, individual, aClass));
                }
            }
        }
        return model;
    }

    protected static Collection<ATermAppl> getDatumInstanceAsCollectorOfATermAppl(TaxonomyNode<ATermAppl> taxonomyNode) {
        return (Collection)taxonomyNode.getDatum(TaxonomyUtils.INSTANCES_KEY);
    }

    private static Statement typeAssertion(Model model, ATermAppl individual, ATermAppl type) {
        Resource individualResource = TaxonomyExtractor.createResource(model, individual);
        Property typeProperty = RDF.type;
        Resource typeResource = TaxonomyExtractor.createResource(model, type);
        return model.createStatement(individualResource, typeProperty, (RDFNode)typeResource);
    }

    private static Statement classAssertion(Model model, ATermAppl aClass) {
        Resource classResource = TaxonomyExtractor.createResource(model, aClass);
        Property typeProperty = RDF.type;
        Resource owlClassResource = OWL.Class;
        return model.createStatement(classResource, typeProperty, (RDFNode)owlClassResource);
    }

    private static Statement subClassOfAssertion(Model model, ATermAppl subClass, ATermAppl superClass) {
        Resource subClassResource = TaxonomyExtractor.createResource(model, subClass);
        Property subClassOfProperty = RDFS.subClassOf;
        Resource superClassResource = TaxonomyExtractor.createResource(model, superClass);
        return model.createStatement(subClassResource, subClassOfProperty, (RDFNode)superClassResource);
    }

    private static Statement equivalentClassAssertion(Model model, ATermAppl firstClass, ATermAppl secondClass) {
        Resource firstClassResource = TaxonomyExtractor.createResource(model, firstClass);
        Property equivalentClassProperty = OWL.equivalentClass;
        Resource secondClassResource = TaxonomyExtractor.createResource(model, secondClass);
        return model.createStatement(firstClassResource, equivalentClassProperty, (RDFNode)secondClassResource);
    }

    private static Resource createResource(Model model, ATermAppl term) {
        return JenaUtils.makeResource(term, model);
    }
}

