/*
 * Decompiled with CFR 0.152.
 */
package openllet.jena.graph.converter;

import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.aterm.ATermInt;
import openllet.aterm.ATermList;
import openllet.core.output.ATermBaseVisitor;
import openllet.core.utils.ATermUtils;
import openllet.jena.JenaUtils;
import openllet.jena.graph.converter.TripleAdder;
import openllet.jena.vocabulary.OWL2;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

public class ConceptConverter
extends ATermBaseVisitor {
    private final Graph _graph;
    private Node _subj;
    private Node _obj;

    public ConceptConverter(Graph g) {
        this._graph = g;
    }

    public Node convert(ATerm term) {
        return this.convert(term, null);
    }

    public Node convert(ATerm term, Node s) {
        Node prevSubj = this._subj;
        this._subj = s;
        this._obj = null;
        if (term instanceof ATermAppl) {
            this.visit((ATermAppl)term);
        } else if (term instanceof ATermInt) {
            this._obj = NodeFactory.createLiteral((String)term.toString(), null, (RDFDatatype)XSDDatatype.XSDnonNegativeInteger);
        } else if (term instanceof ATermList) {
            this.visitList((ATermList)term);
        } else {
            throw new IllegalArgumentException(term.toString());
        }
        this._subj = prevSubj;
        return this._obj;
    }

    public Node getResult() {
        return this._obj;
    }

    public void visitTerm(ATermAppl term) {
        this._obj = JenaUtils.makeGraphNode(term);
    }

    private void createClassExpression(Property p) {
        this.createExpression(p);
    }

    private void createDataExpression(Property p) {
        this.createExpression(p);
    }

    private void createExpression(Property p) {
        if (this._subj != null) {
            TripleAdder.add(this._graph, this._subj, (Resource)p, this._obj);
        } else {
            Node c = NodeFactory.createBlankNode();
            TripleAdder.add(this._graph, c, (Resource)p, this._obj);
            this._obj = c;
        }
    }

    public void visitAnd(ATermAppl term) {
        this.visitList((ATermList)term.getArgument(0));
        this.createClassExpression(OWL.intersectionOf);
    }

    public void visitOr(ATermAppl term) {
        this.visitList((ATermList)term.getArgument(0));
        this.createClassExpression(OWL.unionOf);
    }

    public void visitNot(ATermAppl term) {
        this.visit((ATermAppl)term.getArgument(0));
        this.createClassExpression(OWL.complementOf);
    }

    private Node createQualifiedRestriction(ATermAppl term, Property restrType) {
        Node restr = this.createRestriction(term, restrType);
        Node qual = this.convert(term.getArgument(2));
        if (!ATermUtils.isTop((ATermAppl)((ATermAppl)term.getArgument(2)))) {
            TripleAdder.add(this._graph, restr, (Resource)OWL2.onClass, qual);
        }
        this._obj = restr;
        return restr;
    }

    private Node createRestriction(ATermAppl term, Property restrType) {
        Node restr = NodeFactory.createBlankNode();
        Node prop = this.convert(term.getArgument(0));
        Node val = this.convert(term.getArgument(1));
        TripleAdder.add(this._graph, restr, (Resource)RDF.type, (RDFNode)OWL.Restriction);
        TripleAdder.add(this._graph, restr, (Resource)OWL.onProperty, prop);
        TripleAdder.add(this._graph, restr, (Resource)restrType, val);
        this._obj = restr;
        return restr;
    }

    public void visitSome(ATermAppl term) {
        this.createRestriction(term, OWL.someValuesFrom);
    }

    public void visitAll(ATermAppl term) {
        this.createRestriction(term, OWL.allValuesFrom);
    }

    public void visitMin(ATermAppl term) {
        this.createQualifiedRestriction(term, OWL.minCardinality);
    }

    public void visitCard(ATermAppl term) {
        this.createQualifiedRestriction(term, OWL.cardinality);
    }

    public void visitMax(ATermAppl term) {
        this.createQualifiedRestriction(term, OWL.maxCardinality);
    }

    public void visitHasValue(ATermAppl term) {
        this.createRestriction(term, OWL.hasValue);
    }

    public void visitValue(ATermAppl term) {
        this.visit((ATermAppl)term.getArgument(0));
    }

    public void visitSelf(ATermAppl term) {
        Node restr = NodeFactory.createBlankNode();
        Node prop = this.convert(term.getArgument(0));
        TripleAdder.add(this._graph, restr, (Resource)RDF.type, (RDFNode)OWL.Restriction);
        TripleAdder.add(this._graph, restr, (Resource)OWL.onProperty, prop);
        TripleAdder.add(this._graph, restr, (Resource)OWL2.hasSelf, (RDFNode)JenaUtils.XSD_BOOLEAN_TRUE);
        this._obj = restr;
    }

    public void visitOneOf(ATermAppl term) {
        ATermList list = (ATermList)term.getArgument(0);
        this.visitList(list);
        if (list.isEmpty() || !ATermUtils.isLiteral((ATermAppl)((ATermAppl)((ATermAppl)list.getFirst()).getArgument(0)))) {
            this.createClassExpression(OWL.oneOf);
        } else {
            this.createDataExpression(OWL.oneOf);
        }
    }

    public void visitLiteral(ATermAppl term) {
        this._obj = JenaUtils.makeGraphNode(term);
    }

    public void visitList(ATermList list) {
        if (list.isEmpty()) {
            this._obj = RDF.nil.asNode();
        } else {
            Node rdfList = NodeFactory.createBlankNode();
            Node first = this.convert((ATerm)list.getFirst());
            TripleAdder.add(this._graph, rdfList, (Resource)RDF.first, first);
            this.visitList(list.getNext());
            TripleAdder.add(this._graph, rdfList, (Resource)RDF.rest, this._obj);
            this._obj = rdfList;
        }
    }

    public void visitInverse(ATermAppl term) {
        Node node = NodeFactory.createBlankNode();
        Node prop = this.convert(term.getArgument(0));
        TripleAdder.add(this._graph, node, (Resource)OWL.inverseOf, prop);
        this._obj = node;
    }

    public void visitRestrictedDatatype(ATermAppl dt) {
        Node def = NodeFactory.createBlankNode();
        TripleAdder.add(this._graph, def, (Resource)RDF.type, (RDFNode)RDFS.Datatype);
        TripleAdder.add(this._graph, def, (Resource)OWL2.onDatatype, JenaUtils.makeGraphNode((ATermAppl)dt.getArgument(0)));
        Node list = null;
        ATermList restrictions = (ATermList)dt.getArgument(1);
        while (!restrictions.isEmpty()) {
            ATermAppl facet = (ATermAppl)restrictions.getFirst();
            Node facetNode = NodeFactory.createBlankNode();
            TripleAdder.add(this._graph, facetNode, JenaUtils.makeGraphNode((ATermAppl)facet.getArgument(0)), JenaUtils.makeGraphNode((ATermAppl)facet.getArgument(1)));
            Node newList = NodeFactory.createBlankNode();
            TripleAdder.add(this._graph, newList, (Resource)RDF.first, facetNode);
            if (list != null) {
                TripleAdder.add(this._graph, list, (Resource)RDF.rest, newList);
            } else {
                TripleAdder.add(this._graph, def, (Resource)OWL2.withRestrictions, newList);
            }
            list = newList;
            restrictions = restrictions.getNext();
        }
        TripleAdder.add(this._graph, list, (Resource)RDF.rest, (RDFNode)RDF.nil);
        this._obj = def;
    }
}

