/*
 * Decompiled with CFR 0.152.
 */
package openllet.query.sparqldl.jena;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import openllet.atom.OpenError;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFactory;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.sparql.resultset.ResultsFormat;
import org.apache.jena.sparql.resultset.XMLInput;
import org.apache.jena.util.FileManager;

public class JenaIOUtils {
    public static ResultSet parseResultSet(String resultURI) throws IOException {
        if (resultURI.endsWith("srx")) {
            return ResultSetFactory.fromXML((InputStream)URI.create(resultURI).toURL().openStream());
        }
        if (resultURI.endsWith("ttl")) {
            return ResultSetFactory.load((String)resultURI, (ResultsFormat)ResultsFormat.FMT_RDF_TTL);
        }
        if (resultURI.endsWith("rdf")) {
            return ResultSetFactory.load((String)resultURI, (ResultsFormat)ResultsFormat.FMT_RDF_XML);
        }
        throw new OpenError("Unknown format.");
    }

    public static boolean parseAskResult(String resultURI) throws FileNotFoundException {
        if (resultURI.endsWith("srx")) {
            return XMLInput.booleanFromXML((InputStream)new FileInputStream(resultURI.substring(5)));
        }
        if (resultURI.endsWith("ttl") || resultURI.endsWith("rdf")) {
            return FileManager.get().loadModel(resultURI.substring(5)).getProperty(null, ResourceFactory.createProperty((String)"http://www.w3.org/2001/sw/DataAccess/tests/result-set#boolean")).getBoolean();
        }
        throw new OpenError("Unknown format.");
    }

    public static RDFFormatType fileType(String fileURI) {
        if (fileURI.endsWith(".n3")) {
            return RDFFormatType.N3;
        }
        if (fileURI.endsWith(".ttl")) {
            return RDFFormatType.TURTLE;
        }
        return RDFFormatType.RDFXML;
    }

    public static enum RDFFormatType {
        N3("N3"),
        RDFXML("RDF/XML"),
        TURTLE("TURTLE"),
        NTRIPLE("N-TRIPLE");

        private final String jenaName;

        private RDFFormatType(String s) {
            this.jenaName = s;
        }

        public String jenaName() {
            return this.jenaName;
        }
    }
}

