/*
 * Decompiled with CFR 0.152.
 */
package openllet.query.sparqldl.jena;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import openllet.core.KnowledgeBase;
import openllet.core.OpenlletOptions;
import openllet.core.exceptions.UnsupportedQueryException;
import openllet.jena.PelletInfGraph;
import openllet.query.sparqldl.engine.QueryEngine;
import openllet.query.sparqldl.jena.SlicedResultSet;
import openllet.query.sparqldl.jena.SortedResultSet;
import openllet.query.sparqldl.jena.SparqlDLResultSet;
import openllet.query.sparqldl.model.Query;
import openllet.query.sparqldl.model.QueryParameters;
import openllet.query.sparqldl.model.QueryParametersBuilder;
import openllet.query.sparqldl.parser.ARQParser;
import openllet.shared.tools.Log;
import org.apache.jena.atlas.lib.NotImplemented;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.QueryException;
import org.apache.jena.query.QueryExecException;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.syntax.Template;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.ModelUtils;

class SparqlDLExecution
implements QueryExecution {
    public static Logger _logger = Log.getLogger(SparqlDLExecution.class);
    private final org.apache.jena.query.Query _query;
    private final Dataset _source;
    private QuerySolution _initialBinding;
    private boolean _purePelletQueryExec = false;
    private boolean _handleVariableSPO = true;

    public SparqlDLExecution(String query, Model source) {
        this(QueryFactory.create((String)query), source);
    }

    public SparqlDLExecution(org.apache.jena.query.Query query, Model source) {
        this(query, DatasetFactory.create((Model)source));
    }

    public SparqlDLExecution(org.apache.jena.query.Query query, Dataset source) {
        this(query, source, true);
    }

    public SparqlDLExecution(org.apache.jena.query.Query query, Dataset source, boolean handleVariableSPO) {
        this._query = query;
        this._source = source;
        this._handleVariableSPO = handleVariableSPO;
        Graph graph = source.getDefaultModel().getGraph();
        if (!(graph instanceof PelletInfGraph)) {
            throw new QueryException("PelletQueryExecution can only be used with Pellet-backed models");
        }
        if (OpenlletOptions.FULL_SIZE_ESTIMATE) {
            ((PelletInfGraph)graph).getKB().getSizeEstimate().computeAll();
        }
    }

    public Model execDescribe() {
        throw new UnsupportedOperationException("Not supported yet!");
    }

    public Model execDescribe(Model model) {
        throw new UnsupportedOperationException("Not supported yet!");
    }

    public Model execConstruct() {
        Model model = ModelFactory.createDefaultModel();
        this.execConstruct(model);
        return model;
    }

    public Model execConstruct(Model model) {
        this.ensureQueryType(QueryType.CONSTRUCT);
        ResultSet results = this.exec();
        if (results == null) {
            QueryExecutionFactory.create((org.apache.jena.query.Query)this._query, (Dataset)this._source, (QuerySolution)this._initialBinding).execConstruct(model);
        } else {
            model.setNsPrefixes((PrefixMapping)this._source.getDefaultModel());
            model.setNsPrefixes(this._query.getPrefixMapping());
            HashSet set = new HashSet();
            Template template = this._query.getConstructTemplate();
            while (results.hasNext()) {
                HashMap bNodeMap = new HashMap();
                Binding binding = results.nextBinding();
                template.subst(set, bNodeMap, binding);
            }
            for (Triple t : set) {
                Statement stmt = ModelUtils.tripleToStatement((Model)model, (Triple)t);
                if (stmt == null) continue;
                model.add(stmt);
            }
            this.close();
        }
        return model;
    }

    public boolean execAsk() {
        this.ensureQueryType(QueryType.ASK);
        ResultSet results = this.exec();
        return results != null ? results.hasNext() : QueryExecutionFactory.create((org.apache.jena.query.Query)this._query, (Dataset)this._source, (QuerySolution)this._initialBinding).execAsk();
    }

    public ResultSet execSelect() {
        this.ensureQueryType(QueryType.SELECT);
        ResultSet results = this.exec();
        return results != null ? results : QueryExecutionFactory.create((org.apache.jena.query.Query)this._query, (Dataset)this._source, (QuerySolution)this._initialBinding).execSelect();
    }

    private ResultSet exec() {
        try {
            if (this._source.listNames().hasNext()) {
                throw new UnsupportedQueryException("Named graphs is not supported by Pellet");
            }
            PelletInfGraph pelletInfGraph = (PelletInfGraph)this._source.getDefaultModel().getGraph();
            KnowledgeBase kb = pelletInfGraph.getKB();
            pelletInfGraph.prepare();
            QueryParameters queryParameters = QueryParametersBuilder.getQueryParameters(this._initialBinding);
            ARQParser parser = new ARQParser(this._handleVariableSPO);
            parser.setInitialBinding(this._initialBinding);
            Query q = parser.parse(this._query, kb);
            q.setQueryParameters(queryParameters);
            Object results = new SparqlDLResultSet(QueryEngine.exec((Query)q), this._source.getDefaultModel(), queryParameters);
            List sortConditions = this._query.getOrderBy();
            if (sortConditions != null && !sortConditions.isEmpty()) {
                results = new SortedResultSet((ResultSet)results, sortConditions);
            }
            if (this._query.hasOffset() || this._query.hasLimit()) {
                long offset = this._query.hasOffset() ? this._query.getOffset() : 0L;
                long limit = this._query.hasLimit() ? this._query.getLimit() : Long.MAX_VALUE;
                results = new SlicedResultSet((ResultSet)results, offset, limit);
            }
            return results;
        }
        catch (UnsupportedQueryException e) {
            _logger.log(this._purePelletQueryExec ? Level.INFO : Level.FINE, "This is not a SPARQL-DL _query: " + e.getMessage());
            if (this._purePelletQueryExec) {
                throw e;
            }
            _logger.fine("Falling back to Jena _query engine");
            return null;
        }
    }

    public void abort() {
        throw new UnsupportedOperationException("Not supported yet!");
    }

    public void close() {
        _logger.fine("Closing PelletQueryExecution '" + this.hashCode() + "'.");
    }

    public void setInitialBinding(QuerySolution startSolution) {
        this._initialBinding = startSolution;
    }

    public Context getContext() {
        throw new UnsupportedOperationException("Not supported yet!");
    }

    public Dataset getDataset() {
        throw new UnsupportedOperationException("Not supported yet!");
    }

    private void ensureQueryType(QueryType expectedType) throws QueryExecException {
        QueryType actualType = SparqlDLExecution.getQueryType(this._query);
        if (actualType != expectedType) {
            throw new QueryExecException("Attempt to execute a " + (Object)((Object)actualType) + " _query as a " + (Object)((Object)expectedType) + " _query");
        }
    }

    private static QueryType getQueryType(org.apache.jena.query.Query query) {
        if (query.isSelectType()) {
            return QueryType.SELECT;
        }
        if (query.isConstructType()) {
            return QueryType.CONSTRUCT;
        }
        if (query.isDescribeType()) {
            return QueryType.DESCRIBE;
        }
        if (query.isAskType()) {
            return QueryType.ASK;
        }
        return null;
    }

    public boolean isPurePelletQueryExec() {
        return this._purePelletQueryExec;
    }

    public void setPurePelletQueryExec(boolean purePelletQueryExec) {
        this._purePelletQueryExec = purePelletQueryExec;
    }

    public Iterator<Triple> execConstructTriples() {
        return ModelUtils.statementsToTriples((Iterator)this.execConstruct().listStatements());
    }

    public Iterator<Quad> execConstructQuads() {
        throw new NotImplemented();
    }

    public Dataset execConstructDataset() {
        throw new NotImplemented();
    }

    public Dataset execConstructDataset(Dataset dataset) {
        throw new NotImplemented();
    }

    public Iterator<Triple> execDescribeTriples() {
        return ModelUtils.statementsToTriples((Iterator)this.execDescribe().listStatements());
    }

    public org.apache.jena.query.Query getQuery() {
        return this._query;
    }

    public long getTimeout1() {
        return -1L;
    }

    public long getTimeout2() {
        return -1L;
    }

    public void setTimeout(long arg0) {
    }

    public void setTimeout(long arg0, TimeUnit arg1) {
    }

    public void setTimeout(long arg0, long arg1) {
    }

    public void setTimeout(long arg0, TimeUnit arg1, long arg2, TimeUnit arg3) {
    }

    public boolean isClosed() {
        return false;
    }

    private static enum QueryType {
        ASK,
        CONSTRUCT,
        DESCRIBE,
        SELECT;

    }
}

