/*
 * Decompiled with CFR 0.152.
 */
package openllet.query.sparqldl.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.aterm.ATermList;
import openllet.atom.OpenError;
import openllet.core.KnowledgeBase;
import openllet.core.OpenlletOptions;
import openllet.core.PropertyType;
import openllet.core.boxes.rbox.Role;
import openllet.core.exceptions.UnsupportedFeatureException;
import openllet.core.exceptions.UnsupportedQueryException;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.TermFactory;
import openllet.jena.BuiltinTerm;
import openllet.jena.JenaUtils;
import openllet.jena.vocabulary.OWL2;
import openllet.query.sparqldl.model.Query;
import openllet.query.sparqldl.model.QueryAtomFactory;
import openllet.query.sparqldl.model.QueryImpl;
import openllet.query.sparqldl.parser.QueryParser;
import openllet.query.sparqldl.parser.SparqldlExtensionsVocabulary;
import openllet.shared.tools.Log;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementPathBlock;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

public class ARQParser
implements QueryParser {
    public static Logger _logger = Log.getLogger(ARQParser.class);
    private Set<Triple> _triples;
    private Map<Node, ATerm> _terms;
    private KnowledgeBase _kb;
    private QuerySolution _initialBinding;
    private boolean _handleVariableSPO = true;

    public ARQParser() {
        this(true);
    }

    public ARQParser(boolean handleVariableSPO) {
        this._handleVariableSPO = handleVariableSPO;
    }

    @Override
    public Query parse(InputStream stream, KnowledgeBase kb) {
        try {
            return this.parse(new InputStreamReader(stream), kb);
        }
        catch (IOException e) {
            String message = "Error creating a reader from the input stream.";
            _logger.log(Level.SEVERE, "Error creating a reader from the input stream.", e);
            throw new OpenError("Error creating a reader from the input stream.");
        }
    }

    @Override
    public Query parse(String queryStr, KnowledgeBase kb) {
        org.apache.jena.query.Query sparql = QueryFactory.create((String)queryStr, (Syntax)Syntax.syntaxSPARQL);
        return this.parse(sparql, kb);
    }

    private Query parse(Reader in, KnowledgeBase kb) throws IOException {
        StringBuffer queryString = new StringBuffer();
        BufferedReader r = new BufferedReader(in);
        String line = r.readLine();
        while (line != null) {
            queryString.append(line).append("\n");
            line = r.readLine();
        }
        return this.parse(queryString.toString(), kb);
    }

    @Override
    public Query parse(org.apache.jena.query.Query sparql, KnowledgeBase kb) {
        ArrayList<Triple> triples;
        this._kb = kb;
        if (sparql.isDescribeType()) {
            throw new UnsupportedQueryException("DESCRIBE queries cannot be answered with PelletQueryEngine");
        }
        Element pattern = sparql.getQueryPattern();
        if (!(pattern instanceof ElementGroup)) {
            throw new UnsupportedQueryException("ElementGroup was _expected, but found '" + pattern.getClass() + "'.");
        }
        ElementGroup elementGroup = (ElementGroup)pattern;
        List elements = elementGroup.getElements();
        Element first = (Element)elements.get(0);
        if (elements.size() != 1 || !(first instanceof ElementTriplesBlock) && !(first instanceof ElementPathBlock)) {
            throw new UnsupportedQueryException("Complex query patterns are not supported yet.");
        }
        if (first instanceof ElementPathBlock) {
            triples = new ArrayList();
            for (TriplePath path : ((ElementPathBlock)first).getPattern()) {
                if (!path.isTriple()) {
                    throw new UnsupportedQueryException("Path expressions are not supported yet.");
                }
                triples.add(path.asTriple());
            }
        } else {
            triples = ((ElementTriplesBlock)first).getPattern().getList();
        }
        sparql.setResultVars();
        return this.parse(triples, sparql.getResultVars(), kb, sparql.isDistinct());
    }

    private void initBuiltinTerms() {
        this._terms = new HashMap<Node, ATerm>();
        this._terms.put(OWL.Thing.asNode(), (ATerm)TermFactory.TOP);
        this._terms.put(OWL.Nothing.asNode(), (ATerm)TermFactory.BOTTOM);
        this._terms.put(OWL2.topObjectProperty.asNode(), (ATerm)TermFactory.TOP_OBJECT_PROPERTY);
        this._terms.put(OWL2.topDataProperty.asNode(), (ATerm)TermFactory.TOP_DATA_PROPERTY);
        this._terms.put(OWL2.bottomObjectProperty.asNode(), (ATerm)TermFactory.BOTTOM_OBJECT_PROPERTY);
        this._terms.put(OWL2.bottomDataProperty.asNode(), (ATerm)TermFactory.BOTTOM_DATA_PROPERTY);
    }

    public Query parse(BasicPattern basicPattern, Collection<?> resultVars, KnowledgeBase kb, boolean isDistinct) throws UnsupportedQueryException {
        return this.parse(basicPattern.getList(), resultVars, kb, isDistinct);
    }

    public Query parse(List<Triple> basicPattern, Collection<?> resultVars, KnowledgeBase kb, boolean isDistinct) throws UnsupportedQueryException {
        this._kb = kb;
        HashSet<ATermAppl> variablePredicates = new HashSet<ATermAppl>();
        HashSet<ATermAppl> variableSubjects = new HashSet<ATermAppl>();
        this.initBuiltinTerms();
        this._triples = new LinkedHashSet<Triple>(this.resolveParameterization(basicPattern));
        QueryImpl query = new QueryImpl(kb, isDistinct);
        for (Object name : resultVars) {
            String var = (String)name;
            query.addResultVar(ATermUtils.makeVar((String)var));
        }
        for (Triple t : new ArrayList<Triple>(this._triples)) {
            if (!this._triples.contains(t)) continue;
            Node subj = t.getSubject();
            Node pred = t.getPredicate();
            Node obj = t.getObject();
            if (BuiltinTerm.isSyntax(pred) || BuiltinTerm.isSyntax(obj)) continue;
            this.cache(subj);
            this.cache(pred);
            this.cache(obj);
        }
        HashSet<ATermAppl> possibleLiteralVars = new HashSet<ATermAppl>();
        if (this._triples.isEmpty()) {
            throw new UnsupportedQueryException("Empty BGT");
        }
        for (Triple t : this._triples) {
            Node subj = t.getSubject();
            Node pred = t.getPredicate();
            Node obj = t.getObject();
            ATermAppl s = (ATermAppl)this._terms.get(subj);
            ATermAppl p = (ATermAppl)this._terms.get(pred);
            ATermAppl o = (ATermAppl)this._terms.get(obj);
            if (pred.equals((Object)RDF.Nodes.type)) {
                if (obj.equals((Object)OWL.Class.asNode())) {
                    query.add(QueryAtomFactory.SubClassOfAtom((ATermAppl)s, (ATermAppl)TermFactory.TOP));
                    if (!ATermUtils.isVar((ATermAppl)s)) continue;
                    ARQParser.ensureDistinguished(subj);
                    query.addDistVar(s, Query.VarType.CLASS);
                    if (!this._handleVariableSPO) continue;
                    variablePredicates.remove(s);
                    variableSubjects.add(s);
                    continue;
                }
                if (obj.equals((Object)OWL2.NamedIndividual.asNode())) {
                    query.add(QueryAtomFactory.TypeAtom((ATermAppl)s, (ATermAppl)TermFactory.TOP));
                    if (!ATermUtils.isVar((ATermAppl)s)) continue;
                    ARQParser.ensureDistinguished(subj);
                    query.addDistVar(s, Query.VarType.CLASS);
                    if (!this._handleVariableSPO) continue;
                    variablePredicates.remove(s);
                    variableSubjects.add(s);
                    continue;
                }
                if (obj.equals((Object)OWL.ObjectProperty.asNode())) {
                    query.add(QueryAtomFactory.ObjectPropertyAtom((ATermAppl)s));
                    if (ATermUtils.isVar((ATermAppl)s)) {
                        ARQParser.ensureDistinguished(subj);
                        query.addDistVar(s, Query.VarType.PROPERTY);
                        if (!this._handleVariableSPO) continue;
                        variablePredicates.remove(s);
                        variableSubjects.add(s);
                        continue;
                    }
                    this.ensureTypedProperty(s);
                    continue;
                }
                if (obj.equals((Object)OWL.DatatypeProperty.asNode())) {
                    query.add(QueryAtomFactory.DatatypePropertyAtom((ATermAppl)s));
                    if (ATermUtils.isVar((ATermAppl)s)) {
                        ARQParser.ensureDistinguished(subj);
                        query.addDistVar(s, Query.VarType.PROPERTY);
                        if (!this._handleVariableSPO) continue;
                        variablePredicates.remove(s);
                        variableSubjects.add(s);
                        continue;
                    }
                    this.ensureTypedProperty(s);
                    continue;
                }
                if (obj.equals((Object)RDF.Property.asNode())) {
                    if (ATermUtils.isVar((ATermAppl)s)) {
                        ARQParser.ensureDistinguished(subj);
                        query.addDistVar(s, Query.VarType.PROPERTY);
                        if (!this._handleVariableSPO) continue;
                        variablePredicates.remove(s);
                        variableSubjects.add(s);
                        continue;
                    }
                    this.ensureTypedProperty(s);
                    continue;
                }
                if (obj.equals((Object)OWL.FunctionalProperty.asNode())) {
                    query.add(QueryAtomFactory.FunctionalAtom((ATermAppl)s));
                    if (ATermUtils.isVar((ATermAppl)s)) {
                        ARQParser.ensureDistinguished(subj);
                        query.addDistVar(s, Query.VarType.PROPERTY);
                        if (!this._handleVariableSPO) continue;
                        variablePredicates.remove(s);
                        variableSubjects.add(s);
                        continue;
                    }
                    this.ensureTypedProperty(s);
                    continue;
                }
                if (obj.equals((Object)OWL.InverseFunctionalProperty.asNode())) {
                    query.add(QueryAtomFactory.InverseFunctionalAtom((ATermAppl)s));
                    if (ATermUtils.isVar((ATermAppl)s)) {
                        ARQParser.ensureDistinguished(subj);
                        query.addDistVar(s, Query.VarType.PROPERTY);
                        if (!this._handleVariableSPO) continue;
                        variablePredicates.remove(s);
                        variableSubjects.add(s);
                        continue;
                    }
                    this.ensureTypedProperty(s);
                    continue;
                }
                if (obj.equals((Object)OWL.TransitiveProperty.asNode())) {
                    query.add(QueryAtomFactory.TransitiveAtom((ATermAppl)s));
                    if (ATermUtils.isVar((ATermAppl)s)) {
                        ARQParser.ensureDistinguished(subj);
                        query.addDistVar(s, Query.VarType.PROPERTY);
                        if (!this._handleVariableSPO) continue;
                        variablePredicates.remove(s);
                        variableSubjects.add(s);
                        continue;
                    }
                    this.ensureTypedProperty(s);
                    continue;
                }
                if (obj.equals((Object)OWL.SymmetricProperty.asNode())) {
                    query.add(QueryAtomFactory.SymmetricAtom((ATermAppl)s));
                    if (ATermUtils.isVar((ATermAppl)s)) {
                        ARQParser.ensureDistinguished(subj);
                        query.addDistVar(s, Query.VarType.PROPERTY);
                        if (!this._handleVariableSPO) continue;
                        variablePredicates.remove(s);
                        variableSubjects.add(s);
                        continue;
                    }
                    this.ensureTypedProperty(s);
                    continue;
                }
                if (obj.equals((Object)OWL2.AsymmetricProperty.asNode())) {
                    query.add(QueryAtomFactory.AsymmetricAtom((ATermAppl)s));
                    if (ATermUtils.isVar((ATermAppl)s)) {
                        ARQParser.ensureDistinguished(subj);
                        query.addDistVar(s, Query.VarType.PROPERTY);
                        if (!this._handleVariableSPO) continue;
                        variablePredicates.remove(s);
                        variableSubjects.add(s);
                        continue;
                    }
                    this.ensureTypedProperty(s);
                    continue;
                }
                if (obj.equals((Object)OWL2.ReflexiveProperty.asNode())) {
                    query.add(QueryAtomFactory.ReflexiveAtom((ATermAppl)s));
                    if (ATermUtils.isVar((ATermAppl)s)) {
                        ARQParser.ensureDistinguished(subj);
                        query.addDistVar(s, Query.VarType.PROPERTY);
                        if (!this._handleVariableSPO) continue;
                        variablePredicates.remove(s);
                        variableSubjects.add(s);
                        continue;
                    }
                    this.ensureTypedProperty(s);
                    continue;
                }
                if (obj.equals((Object)OWL2.IrreflexiveProperty.asNode())) {
                    query.add(QueryAtomFactory.IrreflexiveAtom((ATermAppl)s));
                    if (ATermUtils.isVar((ATermAppl)s)) {
                        ARQParser.ensureDistinguished(subj);
                        query.addDistVar(s, Query.VarType.PROPERTY);
                        if (!this._handleVariableSPO) continue;
                        variablePredicates.remove(s);
                        variableSubjects.add(s);
                        continue;
                    }
                    this.ensureTypedProperty(s);
                    continue;
                }
                if (this.hasObject(pred, RDF.type.asNode(), OWL.AnnotationProperty.asNode())) {
                    query.add(QueryAtomFactory.AnnotationAtom((ATermAppl)s, (ATermAppl)p, (ATermAppl)o));
                    if (ATermUtils.isVar((ATermAppl)s) || ATermUtils.isVar((ATermAppl)p) || ATermUtils.isVar((ATermAppl)o)) {
                        throw new UnsupportedQueryException("Variables in annotation atom are not supported.");
                    }
                    this.ensureTypedProperty(p);
                    continue;
                }
                query.add(QueryAtomFactory.TypeAtom((ATermAppl)s, (ATermAppl)o));
                if (ATermUtils.isVar((ATermAppl)o)) {
                    ARQParser.ensureDistinguished(obj);
                    query.addDistVar(o, Query.VarType.CLASS);
                } else if (!kb.isClass((ATerm)o) && _logger.isLoggable(Level.FINE)) {
                    _logger.fine("Class " + o + " used in the query is not defined in the KB.");
                }
                if (!ARQParser.isDistinguishedVariable(subj)) continue;
                query.addDistVar(s, Query.VarType.INDIVIDUAL);
                continue;
            }
            if (pred.equals((Object)OWL.sameAs.asNode())) {
                query.add(QueryAtomFactory.SameAsAtom((ATermAppl)s, (ATermAppl)o));
                if (ARQParser.isDistinguishedVariable(subj)) {
                    query.addDistVar(s, Query.VarType.INDIVIDUAL);
                }
                if (!ARQParser.isDistinguishedVariable(obj)) continue;
                query.addDistVar(o, Query.VarType.INDIVIDUAL);
                continue;
            }
            if (pred.equals((Object)OWL.differentFrom.asNode())) {
                query.add(QueryAtomFactory.DifferentFromAtom((ATermAppl)s, (ATermAppl)o));
                if (ARQParser.isDistinguishedVariable(subj)) {
                    query.addDistVar(s, Query.VarType.INDIVIDUAL);
                }
                if (!ARQParser.isDistinguishedVariable(obj)) continue;
                query.addDistVar(o, Query.VarType.INDIVIDUAL);
                continue;
            }
            if (pred.equals((Object)RDFS.subClassOf.asNode())) {
                query.add(QueryAtomFactory.SubClassOfAtom((ATermAppl)s, (ATermAppl)o));
                if (ATermUtils.isVar((ATermAppl)s)) {
                    ARQParser.ensureDistinguished(subj);
                    query.addDistVar(s, Query.VarType.CLASS);
                }
                if (!ATermUtils.isVar((ATermAppl)o)) continue;
                ARQParser.ensureDistinguished(obj);
                query.addDistVar(o, Query.VarType.CLASS);
                continue;
            }
            if (pred.equals((Object)SparqldlExtensionsVocabulary.strictSubClassOf.asNode())) {
                query.add(QueryAtomFactory.StrictSubClassOfAtom((ATermAppl)s, (ATermAppl)o));
                if (ATermUtils.isVar((ATermAppl)s)) {
                    ARQParser.ensureDistinguished(subj);
                    query.addDistVar(s, Query.VarType.CLASS);
                }
                if (!ATermUtils.isVar((ATermAppl)o)) continue;
                ARQParser.ensureDistinguished(obj);
                query.addDistVar(o, Query.VarType.CLASS);
                continue;
            }
            if (pred.equals((Object)SparqldlExtensionsVocabulary.directSubClassOf.asNode())) {
                query.add(QueryAtomFactory.DirectSubClassOfAtom((ATermAppl)s, (ATermAppl)o));
                if (ATermUtils.isVar((ATermAppl)s)) {
                    ARQParser.ensureDistinguished(subj);
                    query.addDistVar(s, Query.VarType.CLASS);
                }
                if (!ATermUtils.isVar((ATermAppl)o)) continue;
                ARQParser.ensureDistinguished(obj);
                query.addDistVar(o, Query.VarType.CLASS);
                continue;
            }
            if (pred.equals((Object)OWL.equivalentClass.asNode())) {
                query.add(QueryAtomFactory.EquivalentClassAtom((ATermAppl)s, (ATermAppl)o));
                if (ATermUtils.isVar((ATermAppl)s)) {
                    ARQParser.ensureDistinguished(subj);
                    query.addDistVar(s, Query.VarType.CLASS);
                }
                if (!ATermUtils.isVar((ATermAppl)o)) continue;
                ARQParser.ensureDistinguished(obj);
                query.addDistVar(o, Query.VarType.CLASS);
                continue;
            }
            if (pred.equals((Object)OWL.disjointWith.asNode())) {
                query.add(QueryAtomFactory.DisjointWithAtom((ATermAppl)s, (ATermAppl)o));
                if (ATermUtils.isVar((ATermAppl)s)) {
                    ARQParser.ensureDistinguished(subj);
                    query.addDistVar(s, Query.VarType.CLASS);
                }
                if (!ATermUtils.isVar((ATermAppl)o)) continue;
                ARQParser.ensureDistinguished(obj);
                query.addDistVar(o, Query.VarType.CLASS);
                continue;
            }
            if (pred.equals((Object)OWL.complementOf.asNode())) {
                query.add(QueryAtomFactory.ComplementOfAtom((ATermAppl)s, (ATermAppl)o));
                if (ATermUtils.isVar((ATermAppl)s)) {
                    ARQParser.ensureDistinguished(subj);
                    query.addDistVar(s, Query.VarType.CLASS);
                }
                if (!ATermUtils.isVar((ATermAppl)o)) continue;
                ARQParser.ensureDistinguished(obj);
                query.addDistVar(o, Query.VarType.CLASS);
                continue;
            }
            if (pred.equals((Object)OWL2.propertyDisjointWith.asNode())) {
                this.ensureTypedProperty(s);
                this.ensureTypedProperty(o);
                query.add(QueryAtomFactory.PropertyDisjointWithAtom((ATermAppl)s, (ATermAppl)o));
                if (ATermUtils.isVar((ATermAppl)s)) {
                    ARQParser.ensureDistinguished(subj);
                    query.addDistVar(s, Query.VarType.PROPERTY);
                    if (this._handleVariableSPO) {
                        variablePredicates.remove(s);
                        variableSubjects.add(s);
                    }
                }
                if (!ATermUtils.isVar((ATermAppl)o)) continue;
                ARQParser.ensureDistinguished(obj);
                query.addDistVar(o, Query.VarType.PROPERTY);
                if (!this._handleVariableSPO) continue;
                variablePredicates.remove(o);
                variableSubjects.add(o);
                continue;
            }
            if (pred.equals((Object)RDFS.subPropertyOf.asNode())) {
                this.ensureTypedProperty(s);
                this.ensureTypedProperty(o);
                query.add(QueryAtomFactory.SubPropertyOfAtom((ATermAppl)s, (ATermAppl)o));
                if (ATermUtils.isVar((ATermAppl)s)) {
                    ARQParser.ensureDistinguished(subj);
                    query.addDistVar(s, Query.VarType.PROPERTY);
                    if (this._handleVariableSPO) {
                        variablePredicates.remove(s);
                        variableSubjects.add(s);
                    }
                }
                if (!ATermUtils.isVar((ATermAppl)o)) continue;
                ARQParser.ensureDistinguished(obj);
                query.addDistVar(o, Query.VarType.PROPERTY);
                if (!this._handleVariableSPO) continue;
                variablePredicates.remove(o);
                variableSubjects.add(o);
                continue;
            }
            if (pred.equals((Object)SparqldlExtensionsVocabulary.directSubPropertyOf.asNode())) {
                this.ensureTypedProperty(s);
                this.ensureTypedProperty(o);
                query.add(QueryAtomFactory.DirectSubPropertyOfAtom((ATermAppl)s, (ATermAppl)o));
                if (ATermUtils.isVar((ATermAppl)s)) {
                    ARQParser.ensureDistinguished(subj);
                    query.addDistVar(s, Query.VarType.PROPERTY);
                    if (this._handleVariableSPO) {
                        variablePredicates.remove(s);
                        variableSubjects.add(s);
                    }
                }
                if (!ATermUtils.isVar((ATermAppl)o)) continue;
                ARQParser.ensureDistinguished(obj);
                query.addDistVar(o, Query.VarType.PROPERTY);
                if (!this._handleVariableSPO) continue;
                variablePredicates.remove(o);
                variableSubjects.add(o);
                continue;
            }
            if (pred.equals((Object)SparqldlExtensionsVocabulary.strictSubPropertyOf.asNode())) {
                this.ensureTypedProperty(s);
                this.ensureTypedProperty(o);
                query.add(QueryAtomFactory.StrictSubPropertyOfAtom((ATermAppl)s, (ATermAppl)o));
                if (ATermUtils.isVar((ATermAppl)s)) {
                    ARQParser.ensureDistinguished(subj);
                    query.addDistVar(s, Query.VarType.PROPERTY);
                    if (this._handleVariableSPO) {
                        variablePredicates.remove(s);
                        variableSubjects.add(s);
                    }
                }
                if (!ATermUtils.isVar((ATermAppl)o)) continue;
                ARQParser.ensureDistinguished(obj);
                query.addDistVar(o, Query.VarType.PROPERTY);
                if (!this._handleVariableSPO) continue;
                variablePredicates.remove(o);
                variableSubjects.add(o);
                continue;
            }
            if (pred.equals((Object)OWL.equivalentProperty.asNode())) {
                this.ensureTypedProperty(s);
                this.ensureTypedProperty(o);
                query.add(QueryAtomFactory.EquivalentPropertyAtom((ATermAppl)s, (ATermAppl)o));
                if (ATermUtils.isVar((ATermAppl)s)) {
                    ARQParser.ensureDistinguished(subj);
                    query.addDistVar(s, Query.VarType.PROPERTY);
                    if (this._handleVariableSPO) {
                        variablePredicates.remove(s);
                        variableSubjects.add(s);
                    }
                }
                if (!ATermUtils.isVar((ATermAppl)o)) continue;
                ARQParser.ensureDistinguished(obj);
                query.addDistVar(o, Query.VarType.PROPERTY);
                if (!this._handleVariableSPO) continue;
                variablePredicates.remove(o);
                variableSubjects.add(o);
                continue;
            }
            if (pred.equals((Object)RDFS.domain.asNode())) {
                this.ensureTypedProperty(s);
                query.add(QueryAtomFactory.DomainAtom((ATermAppl)s, (ATermAppl)o));
                if (ATermUtils.isVar((ATermAppl)s)) {
                    ARQParser.ensureDistinguished(subj);
                    query.addDistVar(s, Query.VarType.PROPERTY);
                    if (this._handleVariableSPO) {
                        variablePredicates.remove(s);
                        variableSubjects.add(s);
                    }
                }
                if (!ATermUtils.isVar((ATermAppl)o)) continue;
                ARQParser.ensureDistinguished(obj);
                query.addDistVar(s, Query.VarType.CLASS);
                continue;
            }
            if (pred.equals((Object)RDFS.range.asNode())) {
                this.ensureTypedProperty(s);
                query.add(QueryAtomFactory.RangeAtom((ATermAppl)s, (ATermAppl)o));
                if (ATermUtils.isVar((ATermAppl)s)) {
                    ARQParser.ensureDistinguished(subj);
                    query.addDistVar(s, Query.VarType.PROPERTY);
                    if (this._handleVariableSPO) {
                        variablePredicates.remove(s);
                        variableSubjects.add(s);
                    }
                }
                if (!ATermUtils.isVar((ATermAppl)o)) continue;
                ARQParser.ensureDistinguished(obj);
                query.addDistVar(s, Query.VarType.CLASS);
                continue;
            }
            if (pred.equals((Object)OWL.inverseOf.asNode())) {
                this.ensureTypedProperty(s);
                this.ensureTypedProperty(o);
                query.add(QueryAtomFactory.InverseOfAtom((ATermAppl)s, (ATermAppl)o));
                if (ATermUtils.isVar((ATermAppl)s)) {
                    ARQParser.ensureDistinguished(subj);
                    query.addDistVar(s, Query.VarType.PROPERTY);
                    if (this._handleVariableSPO) {
                        variablePredicates.remove(s);
                        variableSubjects.add(s);
                    }
                }
                if (!ATermUtils.isVar((ATermAppl)o)) continue;
                ARQParser.ensureDistinguished(obj);
                query.addDistVar(o, Query.VarType.PROPERTY);
                if (!this._handleVariableSPO) continue;
                variablePredicates.remove(o);
                variableSubjects.add(o);
                continue;
            }
            if (pred.equals((Object)SparqldlExtensionsVocabulary.directType.asNode())) {
                query.add(QueryAtomFactory.DirectTypeAtom((ATermAppl)s, (ATermAppl)o));
                if (ARQParser.isDistinguishedVariable(subj)) {
                    query.addDistVar(s, Query.VarType.INDIVIDUAL);
                }
                if (!ATermUtils.isVar((ATermAppl)o)) continue;
                ARQParser.ensureDistinguished(obj);
                query.addDistVar(o, Query.VarType.CLASS);
                continue;
            }
            if (kb.isAnnotationProperty((ATerm)p)) {
                if (!OpenlletOptions.USE_ANNOTATION_SUPPORT) {
                    throw new UnsupportedQueryException("Cannot answer annotation queries when PelletOptions.USE_ANNOTATION_SUPPORT is false!");
                }
                query.add(QueryAtomFactory.AnnotationAtom((ATermAppl)s, (ATermAppl)p, (ATermAppl)o));
                if (ATermUtils.isVar((ATermAppl)s)) {
                    ARQParser.ensureDistinguished(subj);
                    query.addDistVar(s, Query.VarType.PROPERTY);
                    if (this._handleVariableSPO) {
                        variablePredicates.remove(s);
                        variableSubjects.add(s);
                    }
                }
                if (!ATermUtils.isVar((ATermAppl)o)) continue;
                ARQParser.ensureDistinguished(obj);
                query.addDistVar(o, Query.VarType.PROPERTY);
                if (!this._handleVariableSPO) continue;
                variablePredicates.remove(o);
                variableSubjects.add(o);
                continue;
            }
            if (s == null || p == null || o == null) {
                throw new UnsupportedQueryException("Atom conversion incomplete for: " + t);
            }
            this.ensureTypedProperty(p);
            query.add(QueryAtomFactory.PropertyValueAtom((ATermAppl)s, (ATermAppl)p, (ATermAppl)o));
            if (ATermUtils.isVar((ATermAppl)p)) {
                ARQParser.ensureDistinguished(pred);
                query.addDistVar(p, Query.VarType.PROPERTY);
                if (!variableSubjects.contains(p)) {
                    variablePredicates.add(p);
                }
            }
            if (ARQParser.isDistinguishedVariable(subj)) {
                query.addDistVar(s, Query.VarType.INDIVIDUAL);
            }
            if (!ARQParser.isDistinguishedVariable(obj)) continue;
            if (ATermUtils.isVar((ATermAppl)p)) {
                possibleLiteralVars.add(o);
                continue;
            }
            if (kb.isObjectProperty((ATerm)p)) {
                query.addDistVar(o, Query.VarType.INDIVIDUAL);
                continue;
            }
            if (!kb.isDatatypeProperty((ATerm)p)) continue;
            query.addDistVar(o, Query.VarType.LITERAL);
        }
        for (ATermAppl v : possibleLiteralVars) {
            if (!query.getDistVars().contains(v)) {
                query.addDistVar(v, Query.VarType.LITERAL);
            }
            query.addDistVar(v, Query.VarType.INDIVIDUAL);
        }
        if (!this._handleVariableSPO) {
            return query;
        }
        if (variablePredicates.isEmpty()) {
            return query;
        }
        throw new UnsupportedQueryException("Queries with variable predicates are not supported (add the pattern {?p rdf:type owl:ObjectProperty} or {?p rdf:type owl:DatatypeProperty} to the query)");
    }

    public void setInitialBinding(QuerySolution initialBinding) {
        this._initialBinding = initialBinding;
    }

    private static void ensureDistinguished(Node pred) {
        ARQParser.ensureDistinguished(pred, "Non-distinguished variables in class and predicate positions are not supported : ");
    }

    private static void ensureDistinguished(Node pred, String errorNonDist) {
        if (!ARQParser.isDistinguishedVariable(pred)) {
            throw new UnsupportedQueryException(String.valueOf(errorNonDist) + pred);
        }
    }

    private void ensureTypedProperty(ATermAppl pred) {
        if (ATermUtils.isVar((ATermAppl)pred)) {
            return;
        }
        Role r = this._kb.getRole((ATerm)pred);
        if (r == null) {
            throw new UnsupportedQueryException("Unknown role: " + pred);
        }
        if (r.isUntypedRole()) {
            throw new UnsupportedQueryException("Untyped role: " + pred);
        }
    }

    public static boolean isDistinguishedVariable(Node node) {
        return Var.isVar((Node)node) && (Var.isNamedVar((Node)node) || OpenlletOptions.TREAT_ALL_VARS_DISTINGUISHED);
    }

    private Node getObject(Node subj, Node pred) {
        Iterator<Triple> i = this._triples.iterator();
        while (i.hasNext()) {
            Triple t = i.next();
            if (!subj.equals((Object)t.getSubject()) || !pred.equals((Object)t.getPredicate())) continue;
            i.remove();
            return t.getObject();
        }
        return null;
    }

    private boolean hasObject(Node subj, Node pred) {
        for (Triple t : this._triples) {
            if (!subj.equals((Object)t.getSubject()) || !pred.equals((Object)t.getPredicate())) continue;
            return true;
        }
        return false;
    }

    private boolean hasObject(Node subj, Node pred, Node obj) {
        Iterator<Triple> i = this._triples.iterator();
        while (i.hasNext()) {
            Triple t = i.next();
            if (!subj.equals((Object)t.getSubject()) || !pred.equals((Object)t.getPredicate())) continue;
            i.remove();
            if (obj.equals((Object)t.getObject())) {
                return true;
            }
            throw new UnsupportedQueryException("Expecting rdf:type " + obj + " but found rdf:type " + t.getObject());
        }
        return false;
    }

    private ATermList createList(Node node) {
        if (node.equals((Object)RDF.nil.asNode())) {
            return ATermUtils.EMPTY_LIST;
        }
        if (this._terms.containsKey(node)) {
            return (ATermList)this._terms.get(node);
        }
        this.hasObject(node, RDF.type.asNode(), RDF.List.asNode());
        Node first = this.getObject(node, RDF.first.asNode());
        Node rest = this.getObject(node, RDF.rest.asNode());
        if (first == null || rest == null) {
            throw new UnsupportedQueryException("Invalid list structure: List " + node + " does not have a " + (first == null ? "rdf:first" : "rdf:rest") + " property.");
        }
        ATermList list = ATermUtils.makeList((ATerm)this.node2term(first), (ATermList)this.createList(rest));
        this._terms.put(node, (ATerm)list);
        return list;
    }

    private ATermAppl createRestriction(Node node) throws UnsupportedFeatureException {
        ATermAppl aTerm = ATermUtils.TOP;
        this.hasObject(node, RDF.type.asNode(), OWL.Restriction.asNode());
        Node p = this.getObject(node, OWL.onProperty.asNode());
        if (p == null) {
            return aTerm;
        }
        ATermAppl pt = this.node2term(p);
        if (!this._kb.isProperty((ATerm)pt)) {
            throw new UnsupportedQueryException("Property " + pt + " is not present in KB.");
        }
        Node o = null;
        o = this.getObject(node, OWL.hasValue.asNode());
        if (o != null) {
            if (OpenlletOptions.USE_PSEUDO_NOMINALS) {
                if (o.isLiteral()) {
                    aTerm = ATermUtils.makeMin((ATerm)pt, (int)1, (ATerm)ATermUtils.TOP_LIT);
                } else {
                    ATermAppl ind = ATermUtils.makeTermAppl((String)o.getURI());
                    if (!this._kb.isIndividual((ATerm)ind)) {
                        throw new UnsupportedQueryException("Individual " + ind + " is not present in KB.");
                    }
                    ATermAppl nom = ATermUtils.makeTermAppl((String)(String.valueOf(o.getURI()) + "_nom"));
                    aTerm = ATermUtils.makeSomeValues((ATerm)pt, (ATerm)nom);
                }
            } else {
                ATermAppl ot = this.node2term(o);
                aTerm = ATermUtils.makeHasValue((ATerm)pt, (ATerm)ot);
            }
        } else {
            o = this.getObject(node, OWL2.hasSelf.asNode());
            if (o != null) {
                ATermAppl ot = this.node2term(o);
                if (ATermUtils.isVar((ATermAppl)ot)) {
                    throw new UnsupportedQueryException("Variables not supported in hasSelf restriction");
                }
                aTerm = ATermUtils.makeSelf((ATermAppl)pt);
            } else {
                o = this.getObject(node, OWL.allValuesFrom.asNode());
                if (o != null) {
                    ATermAppl ot = this.node2term(o);
                    if (ATermUtils.isVar((ATermAppl)ot)) {
                        throw new UnsupportedQueryException("Variables not supported in allValuesFrom restriction");
                    }
                    aTerm = ATermUtils.makeAllValues((ATerm)pt, (ATerm)ot);
                } else {
                    o = this.getObject(node, OWL.someValuesFrom.asNode());
                    if (o != null) {
                        ATermAppl ot = this.node2term(o);
                        if (ATermUtils.isVar((ATermAppl)ot)) {
                            throw new UnsupportedQueryException("Variables not supported in someValuesFrom restriction");
                        }
                        aTerm = ATermUtils.makeSomeValues((ATerm)pt, (ATerm)ot);
                    } else {
                        o = this.getObject(node, OWL.minCardinality.asNode());
                        if (o != null) {
                            aTerm = this.createCardinalityRestriction(node, OWL.minCardinality.asNode(), pt, o);
                        } else {
                            o = this.getObject(node, OWL2.minQualifiedCardinality.asNode());
                            if (o != null) {
                                aTerm = this.createCardinalityRestriction(node, OWL2.minQualifiedCardinality.asNode(), pt, o);
                            } else {
                                o = this.getObject(node, OWL.maxCardinality.asNode());
                                if (o != null) {
                                    aTerm = this.createCardinalityRestriction(node, OWL.maxCardinality.asNode(), pt, o);
                                } else {
                                    o = this.getObject(node, OWL2.maxQualifiedCardinality.asNode());
                                    if (o != null) {
                                        aTerm = this.createCardinalityRestriction(node, OWL2.maxQualifiedCardinality.asNode(), pt, o);
                                    } else {
                                        o = this.getObject(node, OWL.cardinality.asNode());
                                        if (o != null) {
                                            aTerm = this.createCardinalityRestriction(node, OWL.cardinality.asNode(), pt, o);
                                        } else {
                                            o = this.getObject(node, OWL2.qualifiedCardinality.asNode());
                                            if (o != null) {
                                                aTerm = this.createCardinalityRestriction(node, OWL2.qualifiedCardinality.asNode(), pt, o);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return aTerm;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ATermAppl createCardinalityRestriction(Node node, Node restrictionType, ATermAppl pt, Node card) throws UnsupportedQueryException {
        try {
            ATermAppl c = null;
            Node qualification = null;
            qualification = this.getObject(node, OWL2.onClass.asNode());
            if (qualification != null) {
                if (qualification.isVariable()) {
                    throw new UnsupportedQueryException("Variables not allowed in cardinality qualification");
                }
                if (!this._kb.isObjectProperty((ATerm)pt)) {
                    return null;
                }
                c = this.node2term(qualification);
            } else {
                qualification = this.getObject(node, OWL2.onDataRange.asNode());
                if (qualification != null) {
                    if (qualification.isVariable()) {
                        throw new UnsupportedQueryException("Variables not allowed in cardinality qualification");
                    }
                    if (!this._kb.isDatatypeProperty((ATerm)pt)) {
                        return null;
                    }
                    c = this.node2term(qualification);
                } else {
                    PropertyType propType = this._kb.getPropertyType((ATerm)pt);
                    c = propType == PropertyType.OBJECT ? ATermUtils.TOP : (propType == PropertyType.DATATYPE ? ATermUtils.TOP_LIT : ATermUtils.TOP);
                }
            }
            int cardinality = Integer.parseInt(card.getLiteralLexicalForm());
            if (restrictionType.equals((Object)OWL.minCardinality.asNode()) || restrictionType.equals((Object)OWL2.minQualifiedCardinality.asNode())) {
                return ATermUtils.makeMin((ATerm)pt, (int)cardinality, (ATerm)c);
            }
            if (!restrictionType.equals((Object)OWL.maxCardinality.asNode()) && !restrictionType.equals((Object)OWL2.maxQualifiedCardinality.asNode())) {
                return ATermUtils.makeCard((ATerm)pt, (int)cardinality, (ATerm)c);
            }
            return ATermUtils.makeMax((ATerm)pt, (int)cardinality, (ATerm)c);
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "Invalid cardinality", ex);
            return null;
        }
    }

    private ATermAppl node2term(Node node) {
        if (!this._terms.containsKey(node)) {
            this.cache(node);
        }
        return (ATermAppl)this._terms.get(node);
    }

    private void cache(Node node) {
        if (this._terms.containsKey(node) || BuiltinTerm.isBuiltin(node)) {
            return;
        }
        ATermAppl aTerm = null;
        if (node.isLiteral()) {
            aTerm = JenaUtils.makeLiteral(node.getLiteral());
        } else if (this.hasObject(node, OWL.onProperty.asNode())) {
            aTerm = this.createRestriction(node);
            this._terms.put(node, (ATerm)aTerm);
        } else if (node.isBlank() || node.isVariable()) {
            Node o = null;
            o = this.getObject(node, OWL.intersectionOf.asNode());
            if (o != null) {
                ATermList list = this.createList(o);
                this.hasObject(node, RDF.type.asNode(), OWL.Class.asNode());
                aTerm = ATermUtils.makeAnd((ATermList)list);
            } else {
                o = this.getObject(node, OWL.unionOf.asNode());
                if (o != null) {
                    ATermList list = this.createList(o);
                    this.hasObject(node, RDF.type.asNode(), OWL.Class.asNode());
                    aTerm = ATermUtils.makeOr((ATermList)list);
                } else {
                    o = this.getObject(node, OWL.oneOf.asNode());
                    if (o != null) {
                        ATermList list = this.createList(o);
                        this.hasObject(node, RDF.type.asNode(), OWL.Class.asNode());
                        ATermList result = ATermUtils.EMPTY_LIST;
                        ATermList l = list;
                        while (!l.isEmpty()) {
                            ATermAppl nominal;
                            ATermAppl c = (ATermAppl)l.getFirst();
                            if (OpenlletOptions.USE_PSEUDO_NOMINALS) {
                                nominal = ATermUtils.makeTermAppl((String)(String.valueOf(c.getName()) + "_nominal"));
                                result = result.insert((ATerm)nominal);
                            } else {
                                nominal = ATermUtils.makeValue((ATerm)c);
                                result = result.insert((ATerm)nominal);
                            }
                            l = l.getNext();
                        }
                        aTerm = ATermUtils.makeOr((ATermList)result);
                    } else if (Var.isBlankNodeVar((Node)node) && (o = this.getObject(node, OWL.complementOf.asNode())) != null) {
                        ATermAppl complement = this.node2term(o);
                        this.hasObject(node, RDF.type.asNode(), OWL.Class.asNode());
                        aTerm = ATermUtils.makeNot((ATerm)complement);
                    } else if (node.isVariable()) {
                        aTerm = ATermUtils.makeVar((String)node.getName());
                    } else {
                        o = this.getObject(node, OWL.complementOf.asNode());
                        if (o != null) {
                            _logger.info("Blank _nodes in class variable positions are not supported");
                        }
                        aTerm = ATermUtils.makeBnode((String)node.getBlankNodeId().toString());
                    }
                }
            }
        } else {
            String uri = node.getURI();
            aTerm = ATermUtils.makeTermAppl((String)uri);
        }
        this._terms.put(node, (ATerm)aTerm);
    }

    private List<Triple> resolveParameterization(List<?> triples) {
        if (triples == null) {
            throw new NullPointerException("The set of _triples cannot be null");
        }
        if (this._initialBinding == null) {
            this._initialBinding = new QuerySolutionMap();
        }
        ArrayList<Triple> ret = new ArrayList<Triple>();
        Triple[] tripleArray = triples.toArray(new Triple[triples.size()]);
        int n = tripleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Triple t = tripleArray[n2];
            if (triples.contains(t)) {
                Node s = this.resolveParameterization(t.getSubject());
                Node p = this.resolveParameterization(t.getPredicate());
                Node o = this.resolveParameterization(t.getObject());
                ret.add(Triple.create((Node)s, (Node)p, (Node)o));
            }
            ++n2;
        }
        return ret;
    }

    private Node resolveParameterization(Node node) {
        if (node == null) {
            throw new NullPointerException("Node is null");
        }
        if (this._initialBinding == null) {
            throw new NullPointerException("Initial binding is null");
        }
        if (node.isConcrete()) {
            return node;
        }
        RDFNode binding = this._initialBinding.get(node.getName());
        if (binding == null) {
            return node;
        }
        return binding.asNode();
    }
}

