/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.cryptalgs;

import java.security.DigestException;
import java.security.MessageDigestSpi;
import java.util.Arrays;

public final class RIPEMD160
extends MessageDigestSpi {
    private int h0;
    private int h1;
    private int h2;
    private int h3;
    private int h4;
    private int[] X = new int[16];
    private int pos;
    private int length;
    private static final int[] Ks = new int[]{0, 1518500249, 1859775393, -1894007588, -1454113458};
    private static final int[] K2s = new int[]{1352829926, 1548603684, 1836072691, 2053994217, 0};
    private static final byte[] rs = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 7, 4, 13, 1, 10, 6, 15, 3, 12, 0, 9, 5, 2, 14, 11, 8, 3, 10, 14, 4, 9, 15, 8, 1, 2, 7, 0, 6, 13, 11, 5, 12, 1, 9, 11, 10, 0, 8, 12, 4, 13, 3, 7, 15, 14, 5, 6, 2, 4, 0, 5, 9, 7, 12, 2, 10, 14, 1, 3, 8, 11, 6, 15, 13};
    private static final byte[] r2s = new byte[]{5, 14, 7, 0, 9, 2, 11, 4, 13, 6, 15, 8, 1, 10, 3, 12, 6, 11, 3, 7, 0, 13, 5, 10, 14, 15, 8, 12, 4, 9, 1, 2, 15, 5, 1, 3, 7, 14, 6, 9, 11, 8, 12, 2, 10, 0, 4, 13, 8, 6, 4, 1, 3, 11, 15, 0, 5, 12, 2, 13, 9, 7, 10, 14, 12, 15, 10, 4, 1, 5, 8, 7, 6, 2, 13, 14, 0, 3, 9, 11};
    private static final byte[] ss = new byte[]{11, 14, 15, 12, 5, 8, 7, 9, 11, 13, 14, 15, 6, 7, 9, 8, 7, 6, 8, 13, 11, 9, 7, 15, 7, 12, 15, 9, 11, 7, 13, 12, 11, 13, 6, 7, 14, 9, 13, 15, 14, 8, 13, 6, 5, 12, 7, 5, 11, 12, 14, 15, 14, 15, 9, 8, 9, 14, 5, 6, 8, 6, 5, 12, 9, 15, 5, 11, 6, 8, 13, 12, 5, 12, 13, 14, 11, 8, 5, 6};
    private static final byte[] s2s = new byte[]{8, 9, 9, 11, 13, 15, 15, 5, 7, 7, 8, 11, 14, 14, 12, 6, 9, 13, 15, 7, 12, 8, 9, 11, 7, 7, 12, 7, 6, 15, 13, 11, 9, 7, 15, 11, 8, 6, 6, 14, 12, 13, 5, 14, 13, 13, 7, 5, 15, 5, 8, 11, 14, 14, 6, 14, 6, 9, 12, 9, 12, 5, 15, 8, 8, 5, 12, 9, 12, 5, 14, 6, 8, 13, 6, 5, 15, 13, 11, 11};

    public RIPEMD160() {
        this.engineReset();
    }

    @Override
    protected byte[] engineDigest() {
        long msgLength = (long)this.length << 3;
        this.engineUpdate((byte)-128);
        if (this.pos + 8 > 64) {
            while (this.pos != 0) {
                this.engineUpdate((byte)0);
            }
        }
        while (this.pos + 8 < 64) {
            this.engineUpdate((byte)0);
        }
        for (int i = 0; i < 8; ++i) {
            this.engineUpdate((byte)(msgLength >> (i << 3) & 0xFFL));
        }
        byte[] hashValue = new byte[this.engineGetDigestLength()];
        for (int i = 0; i < 4; ++i) {
            hashValue[i] = (byte)(this.h0 >> (i << 3) & 0xFF);
            hashValue[4 + i] = (byte)(this.h1 >> (i << 3) & 0xFF);
            hashValue[8 + i] = (byte)(this.h2 >> (i << 3) & 0xFF);
            hashValue[12 + i] = (byte)(this.h3 >> (i << 3) & 0xFF);
            hashValue[16 + i] = (byte)(this.h4 >> (i << 3) & 0xFF);
        }
        this.engineReset();
        return hashValue;
    }

    @Override
    protected int engineDigest(byte[] buf, int offset, int len) throws DigestException {
        if (len < this.engineGetDigestLength()) {
            throw new DigestException("buffer length too small to hold hash value");
        }
        byte[] hashValue = this.engineDigest();
        for (int i = 0; i < this.engineGetDigestLength(); ++i) {
            buf[i + offset] = hashValue[i];
        }
        return this.engineGetDigestLength();
    }

    @Override
    protected int engineGetDigestLength() {
        return 20;
    }

    @Override
    protected void engineReset() {
        this.h0 = 1732584193;
        this.h1 = -271733879;
        this.h2 = -1732584194;
        this.h3 = 271733878;
        this.h4 = -1009589776;
        Arrays.fill(this.X, 0);
        this.pos = 0;
        this.length = 0;
    }

    @Override
    protected void engineUpdate(byte input) {
        int n = this.pos >> 2;
        this.X[n] = this.X[n] ^ (input & 0xFF) << ((this.pos & 3) << 3);
        ++this.length;
        if (++this.pos == 64) {
            this.hashit();
            Arrays.fill(this.X, 0);
            this.pos = 0;
        }
    }

    @Override
    protected void engineUpdate(byte[] input, int offset, int len) {
        for (int i = offset; i < offset + len; ++i) {
            this.engineUpdate(input[i]);
        }
    }

    private void hashit() {
        int T;
        int E;
        int D;
        int C;
        int B;
        int A;
        int A2 = A = this.h0;
        int B2 = B = this.h1;
        int C2 = C = this.h2;
        int D2 = D = this.h3;
        int E2 = E = this.h4;
        for (byte j = 0; j < 80; j = (byte)(j + 1)) {
            T = this.roll(A + this.f(j, B, C, D) + this.X[this.r(j)] + this.K(j), this.s(j)) + E;
            A = E;
            E = D;
            D = this.roll(C, (byte)10);
            C = B;
            B = T;
            T = this.roll(A2 + this.f((byte)(79 - j), B2, C2, D2) + this.X[this.r2(j)] + this.K2(j), this.s2(j)) + E2;
            A2 = E2;
            E2 = D2;
            D2 = this.roll(C2, (byte)10);
            C2 = B2;
            B2 = T;
        }
        T = this.h1 + C + D2;
        this.h1 = this.h2 + D + E2;
        this.h2 = this.h3 + E + A2;
        this.h3 = this.h4 + A + B2;
        this.h4 = this.h0 + B + C2;
        this.h0 = T;
    }

    private int f(byte j, int x, int y, int z) {
        int ret = j >= 0 && j <= 15 ? x ^ y ^ z : (j >= 16 && j <= 31 ? x & y | ~x & z : (j >= 32 && j <= 47 ? (x | ~y) ^ z : (j >= 48 && j <= 63 ? x & z | y & ~z : (j >= 64 && j <= 79 ? x ^ (y | ~z) : -1))));
        return ret;
    }

    private int K(byte j) {
        return Ks[j >> 4];
    }

    private int K2(byte j) {
        return K2s[j >> 4];
    }

    private byte r(byte j) {
        return rs[j];
    }

    private byte r2(byte j) {
        return r2s[j];
    }

    private byte s(byte j) {
        return ss[j];
    }

    private byte s2(byte j) {
        return s2s[j];
    }

    private int roll(int x, byte num) {
        return x << num | x >>> 32 - num;
    }
}

