/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.util.Enumeration;
import java.util.Properties;
import org.kapott.hbci.GV.AbstractSEPAGV;
import org.kapott.hbci.GV_Result.AbstractGVRLastSEPA;
import org.kapott.hbci.manager.HBCIHandler;
import org.kapott.hbci.sepa.SepaVersion;
import org.kapott.hbci.status.HBCIMsgStatus;

public abstract class AbstractGVLastSEPA
extends AbstractSEPAGV {
    private static final SepaVersion DEFAULT = SepaVersion.PAIN_008_001_01;

    @Override
    protected SepaVersion getDefaultPainVersion() {
        return DEFAULT;
    }

    @Override
    protected SepaVersion.Type getPainType() {
        return SepaVersion.Type.PAIN_008;
    }

    @Override
    public String getPainJobName() {
        return "LastSEPA";
    }

    public AbstractGVLastSEPA(HBCIHandler handler, String lowlevelName, AbstractGVRLastSEPA result) {
        super(handler, lowlevelName, result);
        this.addConstraint("src.bic", "My.bic", null, 3);
        this.addConstraint("src.iban", "My.iban", null, 2);
        if (this.canNationalAcc(handler)) {
            this.addConstraint("src.country", "My.KIK.country", "", 0);
            this.addConstraint("src.blz", "My.KIK.blz", "", 3);
            this.addConstraint("src.number", "My.number", "", 2);
            this.addConstraint("src.subnumber", "My.subnumber", "", 3);
        }
        this.addConstraint("_sepadescriptor", "sepadescr", this.getPainVersion().getURN(), 0);
        this.addConstraint("_sepapain", "sepapain", null, 2);
        this.addConstraint("src.bic", "sepa.src.bic", "", 3);
        this.addConstraint("src.iban", "sepa.src.iban", null, 2);
        this.addConstraint("src.name", "sepa.src.name", null, 2);
        this.addConstraint("dst.bic", "sepa.dst.bic", "", 3, true);
        this.addConstraint("dst.iban", "sepa.dst.iban", null, 2, true);
        this.addConstraint("dst.name", "sepa.dst.name", null, 2, true);
        this.addConstraint("dst.addr.country", "sepa.dst.addr.country", "", 3, true);
        this.addConstraint("dst.addr.line1", "sepa.dst.addr.line1", "", 3, true);
        this.addConstraint("dst.addr.line2", "sepa.dst.addr.line2", "", 3, true);
        this.addConstraint("btg.value", "sepa.btg.value", null, 0, true);
        this.addConstraint("btg.curr", "sepa.btg.curr", "EUR", 0, true);
        this.addConstraint("usage", "sepa.usage", "", 0, true);
        this.addConstraint("sepaid", "sepa.sepaid", this.getSEPAMessageId(), 0);
        this.addConstraint("pmtinfid", "sepa.pmtinfid", this.getSEPAMessageId(), 0);
        this.addConstraint("endtoendid", "sepa.endtoendid", "NOTPROVIDED", 2, true);
        this.addConstraint("creditorid", "sepa.creditorid", null, 2, true);
        this.addConstraint("mandateid", "sepa.mandateid", null, 2, true);
        this.addConstraint("purposecode", "sepa.purposecode", "", 2, true);
        this.addConstraint("manddateofsig", "sepa.manddateofsig", null, 0, true);
        this.addConstraint("amendmandindic", "sepa.amendmandindic", Boolean.toString(false), 0, true);
        this.addConstraint("sequencetype", "sepa.sequencetype", "FRST", 0);
        this.addConstraint("targetdate", "sepa.targetdate", "1999-01-01", 0);
    }

    @Override
    protected void extractResults(HBCIMsgStatus msgstatus, String header, int idx) {
        Properties result = msgstatus.getData();
        String orderid = result.getProperty(header + ".orderid");
        ((AbstractGVRLastSEPA)this.jobResult).setOrderId(orderid);
        if (orderid != null && orderid.length() != 0) {
            Properties p = this.getLowlevelParams();
            Properties p2 = new Properties();
            Enumeration<?> e = p.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                p2.setProperty(key.substring(key.indexOf(".") + 1), p.getProperty(key));
            }
            this.getMainPassport().setPersistentData("termlast_" + orderid, p2);
        }
    }
}

