/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.util.Properties;
import org.kapott.hbci.GV.HBCIJobImpl;
import org.kapott.hbci.GV_Result.GVRCardList;
import org.kapott.hbci.manager.HBCIHandler;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.kapott.hbci.structures.Value;

public class GVCardList
extends HBCIJobImpl {
    public static String getLowlevelName() {
        return "CardList";
    }

    public GVCardList(HBCIHandler handler) {
        super(handler, GVCardList.getLowlevelName(), new GVRCardList());
        this.addConstraint("my.country", "KTV.KIK.country", "DE", 0);
        this.addConstraint("my.blz", "KTV.KIK.blz", null, 3);
        this.addConstraint("my.number", "KTV.number", null, 2);
        this.addConstraint("my.subnumber", "KTV.subnumber", "", 3);
    }

    @Override
    protected boolean redoAllowed() {
        return true;
    }

    @Override
    public void extractResults(HBCIMsgStatus msgstatus, String header, int idx) {
        Properties result = msgstatus.getData();
        GVRCardList.CardInfo info = new GVRCardList.CardInfo();
        info.cardnumber = result.getProperty(header + ".cardnumber");
        info.cardordernumber = result.getProperty(header + ".nextcardnumber");
        info.cardtype = Integer.parseInt(result.getProperty(header + ".cardtype"));
        info.comment = result.getProperty(header + ".comment");
        String st = result.getProperty(header + ".cardlimit.value");
        if (st != null) {
            info.limit = new Value(st, result.getProperty(header + ".cardlimit.curr"));
        }
        info.owner = result.getProperty(header + ".name");
        st = result.getProperty(header + ".validfrom");
        if (st != null) {
            info.validFrom = HBCIUtils.string2DateISO(st);
        }
        if ((st = result.getProperty(header + ".validuntil")) != null) {
            info.validUntil = HBCIUtils.string2DateISO(st);
        }
        ((GVRCardList)this.getJobResult()).addEntry(info);
    }

    @Override
    public void verifyConstraints() {
        super.verifyConstraints();
        this.checkAccountCRC("my");
    }
}

