/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.text.DecimalFormat;
import java.util.Properties;
import org.kapott.hbci.GV.AbstractGVLastSEPA;
import org.kapott.hbci.GV_Result.GVRDauerLastNew;
import org.kapott.hbci.exceptions.InvalidUserDataException;
import org.kapott.hbci.manager.HBCIHandler;
import org.kapott.hbci.manager.HBCIUtilsInternal;

public class GVDauerLastSEPANew
extends AbstractGVLastSEPA {
    public static String getLowlevelName() {
        return "DauerLastSEPANew";
    }

    public GVDauerLastSEPANew(HBCIHandler handler) {
        super(handler, GVDauerLastSEPANew.getLowlevelName(), new GVRDauerLastNew());
        this.addConstraint("type", "sepa.type", "CORE", 0);
        this.addConstraint("firstdate", "DauerDetails.firstdate", null, 0);
        this.addConstraint("timeunit", "DauerDetails.timeunit", null, 0);
        this.addConstraint("turnus", "DauerDetails.turnus", null, 0);
        this.addConstraint("execday", "DauerDetails.execday", null, 0);
        this.addConstraint("lastdate", "DauerDetails.lastdate", "", 0);
    }

    @Override
    public void setParam(String paramName, String value) {
        String timeunit;
        Properties res = this.getJobRestrictions();
        if (paramName.equals("timeunit")) {
            if (!value.equals("W") && !value.equals("M")) {
                String msg = HBCIUtilsInternal.getLocMsg("EXCMSG_INV_TIMEUNIT", value);
                if (!HBCIUtilsInternal.ignoreError(this.getMainPassport(), "client.errors.ignoreWrongJobDataErrors", msg)) {
                    throw new InvalidUserDataException(msg);
                }
            }
        } else if (paramName.equals("turnus")) {
            String timeunit2 = this.getLowlevelParams().getProperty(this.getName() + ".DauerDetails.timeunit");
            if (timeunit2 != null) {
                String st;
                if (timeunit2.equals("W")) {
                    String st2 = res.getProperty("turnusweeks");
                    if (st2 != null) {
                        String value2 = new DecimalFormat("00").format(Integer.parseInt(value));
                        if (!st2.equals("00") && !this.twoDigitValueInList(value2, st2)) {
                            String msg = HBCIUtilsInternal.getLocMsg("EXCMSG_INV_TURNUS", value);
                            if (!HBCIUtilsInternal.ignoreError(this.getMainPassport(), "client.errors.ignoreWrongJobDataErrors", msg)) {
                                throw new InvalidUserDataException(msg);
                            }
                        }
                    }
                } else if (timeunit2.equals("M") && (st = res.getProperty("turnusmonths")) != null) {
                    String value2 = new DecimalFormat("00").format(Integer.parseInt(value));
                    if (!st.equals("00") && !this.twoDigitValueInList(value2, st)) {
                        String msg = HBCIUtilsInternal.getLocMsg("EXCMSG_INV_TURNUS", value);
                        if (!HBCIUtilsInternal.ignoreError(this.getMainPassport(), "client.errors.ignoreWrongJobDataErrors", msg)) {
                            throw new InvalidUserDataException(msg);
                        }
                    }
                }
            }
        } else if (paramName.equals("execday") && (timeunit = this.getLowlevelParams().getProperty(this.getName() + ".DauerDetails.timeunit")) != null) {
            String st;
            if (timeunit.equals("W")) {
                String st3 = res.getProperty("daysperweek");
                if (st3 != null && !st3.equals("0") && !st3.contains(value)) {
                    String msg = HBCIUtilsInternal.getLocMsg("EXCMSG_INV_EXECDAY", value);
                    if (!HBCIUtilsInternal.ignoreError(this.getMainPassport(), "client.errors.ignoreWrongJobDataErrors", msg)) {
                        throw new InvalidUserDataException(msg);
                    }
                }
            } else if (timeunit.equals("M") && (st = res.getProperty("dayspermonth")) != null) {
                String value2 = new DecimalFormat("00").format(Integer.parseInt(value));
                if (!st.equals("00") && !this.twoDigitValueInList(value2, st)) {
                    String msg = HBCIUtilsInternal.getLocMsg("EXCMSG_INV_EXECDAY", value);
                    if (!HBCIUtilsInternal.ignoreError(this.getMainPassport(), "client.errors.ignoreWrongJobDataErrors", msg)) {
                        throw new InvalidUserDataException(msg);
                    }
                }
            }
        }
        super.setParam(paramName, value);
    }
}

