/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.io.ByteArrayInputStream;
import java.util.Calendar;
import java.util.Properties;
import org.kapott.hbci.GV.AbstractSEPAGV;
import org.kapott.hbci.GV.parsers.ISEPAParser;
import org.kapott.hbci.GV.parsers.SEPAParserFactory;
import org.kapott.hbci.GV_Result.GVRKUms;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.HBCIHandler;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.HBCIUtilsInternal;
import org.kapott.hbci.sepa.SepaVersion;
import org.kapott.hbci.status.HBCIMsgStatus;

public class GVKUmsAllCamt
extends AbstractSEPAGV {
    public static String getLowlevelName() {
        return "KUmsZeitCamt";
    }

    public GVKUmsAllCamt(HBCIHandler handler, String name) {
        super(handler, name, new GVRKUms());
    }

    @Override
    protected SepaVersion getDefaultPainVersion() {
        return SepaVersion.CAMT_052_001_01;
    }

    @Override
    protected SepaVersion.Type getPainType() {
        return SepaVersion.Type.CAMT_052;
    }

    public GVKUmsAllCamt(HBCIHandler handler) {
        this(handler, GVKUmsAllCamt.getLowlevelName());
        this.addConstraint("my.bic", "KTV.bic", null, 3);
        this.addConstraint("my.iban", "KTV.iban", null, 2);
        if (this.canNationalAcc(handler)) {
            this.addConstraint("my.country", "KTV.KIK.country", "DE", 0);
            this.addConstraint("my.blz", "KTV.KIK.blz", null, 3);
            this.addConstraint("my.number", "KTV.number", null, 2);
            this.addConstraint("my.subnumber", "KTV.subnumber", "", 3);
        }
        this.addConstraint("suppformat", "formats.suppformat", this.getPainVersion().getURN(), 0);
        this.addConstraint("dummy", "allaccounts", "N", 0);
        this.addConstraint("startdate", "startdate", this.getStartdate(), 0);
        this.addConstraint("enddate", "enddate", "", 0);
        this.addConstraint("maxentries", "maxentries", "", 0);
        this.addConstraint("offset", "offset", "", 0);
    }

    private String getStartdate() {
        Properties bpd = this.getJobRestrictions();
        String days = bpd.getProperty("timerange");
        String date = "";
        if (days != null && days.length() > 0 && days.matches("[0-9]{1,4}")) {
            Calendar cal = Calendar.getInstance();
            cal.add(5, -Integer.parseInt(days));
            date = HBCIUtils.date2StringISO(cal.getTime());
        }
        HBCIUtils.log("earliest start date according to BPD: " + (date != null && date.length() > 0 ? date : "<none>"), 4);
        return date;
    }

    @Override
    protected boolean redoAllowed() {
        return true;
    }

    @Override
    protected void extractResults(HBCIMsgStatus msgstatus, String header, int idx) {
        String booked;
        Properties data = msgstatus.getData();
        GVRKUms result = (GVRKUms)this.jobResult;
        String format = data.getProperty(header + ".format");
        int i = 0;
        while ((booked = data.getProperty(header + ".booked." + HBCIUtilsInternal.withCounter("message", i))) != null) {
            try {
                SepaVersion version = SepaVersion.choose(format, booked);
                ISEPAParser parser = SEPAParserFactory.get(version);
                HBCIUtils.log("  parsing camt data: " + booked, 5);
                result.camtBooked.add(booked);
                parser.parse(new ByteArrayInputStream(booked.getBytes("ISO-8859-1")), result.getDataPerDay());
                HBCIUtils.log("  parsed camt data, entries: " + result.getFlatData().size(), 4);
            }
            catch (Exception e) {
                HBCIUtils.log("  unable to parse camt data: " + e.getMessage(), 1);
                throw new HBCI_Exception("Error parsing CAMT document", e);
            }
            ++i;
        }
        String notbooked = data.getProperty(header + ".notbooked");
        if (notbooked != null) {
            try {
                SepaVersion version = SepaVersion.choose(format, notbooked);
                ISEPAParser parser = SEPAParserFactory.get(version);
                HBCIUtils.log("  parsing unbooked camt data: " + notbooked, 5);
                result.camtNotBooked.add(notbooked);
                parser.parse(new ByteArrayInputStream(notbooked.getBytes("ISO-8859-1")), result.getDataPerDayUnbooked());
                HBCIUtils.log("  parsed unbooked camt data, entries: " + result.getFlatDataUnbooked().size(), 4);
            }
            catch (Exception e) {
                HBCIUtils.log("  unable to parse unbooked camt data: " + e.getMessage(), 1);
                throw new HBCI_Exception("Error parsing CAMT document", e);
            }
        }
    }

    @Override
    public void verifyConstraints() {
        super.verifyConstraints();
        this.checkAccountCRC("my");
    }
}

