/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.io.UnsupportedEncodingException;
import java.util.Properties;
import org.kapott.hbci.GV.HBCIJobImpl;
import org.kapott.hbci.GV_Result.GVRKontoauszug;
import org.kapott.hbci.manager.HBCIHandler;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.kapott.hbci.swift.Swift;

public class GVKontoauszug
extends HBCIJobImpl {
    public static String getLowlevelName() {
        return "Kontoauszug";
    }

    public GVKontoauszug(HBCIHandler handler, String name) {
        super(handler, name, new GVRKontoauszug());
    }

    public GVKontoauszug(HBCIHandler handler) {
        this(handler, GVKontoauszug.getLowlevelName());
        boolean sepa = false;
        try {
            sepa = Integer.parseInt(this.getSegVersion()) >= 4;
        }
        catch (Exception e) {
            HBCIUtils.log(e);
        }
        boolean nat = this.canNationalAcc(handler);
        if (sepa) {
            this.addConstraint("my.bic", "My.bic", null, 3);
            this.addConstraint("my.iban", "My.iban", null, 2);
        }
        if (nat || !sepa) {
            this.addConstraint("my.country", "My.KIK.country", "DE", 0);
            this.addConstraint("my.blz", "My.KIK.blz", "", 3);
            this.addConstraint("my.number", "My.number", "", 2);
            this.addConstraint("my.subnumber", "My.subnumber", "", 3);
        }
        this.addConstraint("format", "format", "", 0);
        this.addConstraint("idx", "idx", "", 0);
        this.addConstraint("year", "year", "", 0);
        this.addConstraint("maxentries", "maxentries", "", 0);
        this.addConstraint("offset", "offset", "", 0);
    }

    @Override
    protected boolean redoAllowed() {
        return true;
    }

    @Override
    protected void extractResults(HBCIMsgStatus msgstatus, String header, int idx) {
        String date;
        Properties result = msgstatus.getData();
        GVRKontoauszug list = (GVRKontoauszug)this.jobResult;
        GVRKontoauszug.GVRKontoauszugEntry auszug = new GVRKontoauszug.GVRKontoauszugEntry();
        list.getEntries().add(auszug);
        GVRKontoauszug.Format format = GVRKontoauszug.Format.find(result.getProperty(header + ".format"));
        auszug.setFormat(format);
        String data = result.getProperty(header + ".booked");
        if (data != null && data.length() > 0) {
            if (format != null && format == GVRKontoauszug.Format.MT940) {
                data = Swift.decodeUmlauts(data);
            }
            try {
                auszug.setData(data.getBytes("ISO-8859-1"));
            }
            catch (UnsupportedEncodingException e) {
                HBCIUtils.log((Exception)e, 2);
                auszug.setData(data.getBytes());
            }
        }
        if ((date = result.getProperty(header + ".date")) != null && date.length() > 0) {
            auszug.setDate(HBCIUtils.string2DateISO(date));
        }
        String year = result.getProperty(header + ".year");
        String number = result.getProperty(header + ".number");
        if (year != null && year.length() > 0) {
            auszug.setYear(Integer.parseInt(year));
        }
        if (number != null && number.length() > 0) {
            auszug.setNumber(Integer.parseInt(number));
        }
        auszug.setStartDate(HBCIUtils.string2DateISO(result.getProperty(header + ".TimeRange.startdate")));
        auszug.setEndDate(HBCIUtils.string2DateISO(result.getProperty(header + ".TimeRange.enddate")));
        auszug.setAbschlussInfo(result.getProperty(header + ".abschlussinfo"));
        auszug.setKundenInfo(result.getProperty(header + ".kondinfo"));
        auszug.setWerbetext(result.getProperty(header + ".ads"));
        auszug.setIBAN(result.getProperty(header + ".iban"));
        auszug.setBIC(result.getProperty(header + ".bic"));
        auszug.setName(result.getProperty(header + ".name"));
        auszug.setName2(result.getProperty(header + ".name2"));
        auszug.setName3(result.getProperty(header + ".name3"));
        String receipt = result.getProperty(header + ".receipt");
        if (receipt != null) {
            try {
                auszug.setReceipt(receipt.getBytes("ISO-8859-1"));
            }
            catch (UnsupportedEncodingException e) {
                HBCIUtils.log((Exception)e, 2);
                auszug.setReceipt(receipt.getBytes());
            }
        }
    }

    @Override
    public void verifyConstraints() {
        super.verifyConstraints();
        this.checkAccountCRC("my");
    }
}

