/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV.generators;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.kapott.hbci.GV.generators.ISEPAGenerator;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.sepa.SepaVersion;

public abstract class AbstractSEPAGenerator<T>
implements ISEPAGenerator<T> {
    private static final Logger LOG = Logger.getLogger(AbstractSEPAGenerator.class.getName());

    protected void marshal(JAXBElement e, OutputStream os, boolean validate) throws Exception {
        SepaVersion version;
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{e.getDeclaredType()});
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        if (System.getProperty("sepa.pain.formatted", "false").equalsIgnoreCase("true")) {
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        }
        if ((version = this.getSepaVersion()) != null) {
            String file;
            String schemaLocation = version.getSchemaLocation();
            if (schemaLocation != null) {
                LOG.fine("appending schemaLocation " + schemaLocation);
                marshaller.setProperty("jaxb.schemaLocation", (Object)schemaLocation);
            }
            if ((file = version.getFile()) != null && validate) {
                StreamSource source = null;
                InputStream is = this.getClass().getClassLoader().getResourceAsStream(file);
                if (is != null) {
                    source = new StreamSource(is);
                } else {
                    File f = new File(file);
                    if (f.isFile() && f.canRead()) {
                        source = new StreamSource(f);
                    }
                }
                if (source == null) {
                    throw new HBCI_Exception("schema validation activated against " + file + " - but schema file could not be found");
                }
                LOG.fine("activating schema validation against " + file);
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                Schema schema = schemaFactory.newSchema(source);
                marshaller.setSchema(schema);
            }
        }
        marshaller.marshal((Object)e, os);
    }

    @Override
    public SepaVersion getSepaVersion() {
        return null;
    }
}

