/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV.generators;

import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Properties;
import javax.xml.datatype.XMLGregorianCalendar;
import org.kapott.hbci.GV.SepaUtil;
import org.kapott.hbci.GV.generators.AbstractSEPAGenerator;
import org.kapott.hbci.sepa.SepaVersion;
import org.kapott.hbci.sepa.jaxb.pain_001_001_11.AccountIdentification4Choice;
import org.kapott.hbci.sepa.jaxb.pain_001_001_11.ActiveOrHistoricCurrencyAndAmount;
import org.kapott.hbci.sepa.jaxb.pain_001_001_11.AmountType4Choice;
import org.kapott.hbci.sepa.jaxb.pain_001_001_11.BranchAndFinancialInstitutionIdentification6;
import org.kapott.hbci.sepa.jaxb.pain_001_001_11.CashAccount40;
import org.kapott.hbci.sepa.jaxb.pain_001_001_11.ChargeBearerType1Code;
import org.kapott.hbci.sepa.jaxb.pain_001_001_11.CreditTransferTransaction54;
import org.kapott.hbci.sepa.jaxb.pain_001_001_11.CustomerCreditTransferInitiationV11;
import org.kapott.hbci.sepa.jaxb.pain_001_001_11.DateAndDateTime2Choice;
import org.kapott.hbci.sepa.jaxb.pain_001_001_11.Document;
import org.kapott.hbci.sepa.jaxb.pain_001_001_11.FinancialInstitutionIdentification18;
import org.kapott.hbci.sepa.jaxb.pain_001_001_11.GenericFinancialIdentification1;
import org.kapott.hbci.sepa.jaxb.pain_001_001_11.GroupHeader95;
import org.kapott.hbci.sepa.jaxb.pain_001_001_11.ObjectFactory;
import org.kapott.hbci.sepa.jaxb.pain_001_001_11.PartyIdentification135;
import org.kapott.hbci.sepa.jaxb.pain_001_001_11.PaymentIdentification6;
import org.kapott.hbci.sepa.jaxb.pain_001_001_11.PaymentInstruction40;
import org.kapott.hbci.sepa.jaxb.pain_001_001_11.PaymentMethod3Code;
import org.kapott.hbci.sepa.jaxb.pain_001_001_11.PaymentTypeInformation26;
import org.kapott.hbci.sepa.jaxb.pain_001_001_11.Purpose2Choice;
import org.kapott.hbci.sepa.jaxb.pain_001_001_11.RemittanceInformation21;
import org.kapott.hbci.sepa.jaxb.pain_001_001_11.ServiceLevel8Choice;

public class GenUebSEPA00100111
extends AbstractSEPAGenerator<Properties> {
    @Override
    public SepaVersion getSepaVersion() {
        return SepaVersion.PAIN_001_001_11;
    }

    @Override
    public void generate(Properties sepaParams, OutputStream os, boolean validate) throws Exception {
        Integer maxIndex = SepaUtil.maxIndex(sepaParams);
        Document doc = new Document();
        doc.setCstmrCdtTrfInitn(new CustomerCreditTransferInitiationV11());
        doc.getCstmrCdtTrfInitn().setGrpHdr(new GroupHeader95());
        String sepaId = sepaParams.getProperty("sepaid");
        String pmtInfId = sepaParams.getProperty("pmtinfid");
        doc.getCstmrCdtTrfInitn().getGrpHdr().setMsgId(sepaId);
        doc.getCstmrCdtTrfInitn().getGrpHdr().setCreDtTm(SepaUtil.createCalendar(null));
        doc.getCstmrCdtTrfInitn().getGrpHdr().setNbOfTxs(String.valueOf(maxIndex != null ? maxIndex + 1 : 1));
        doc.getCstmrCdtTrfInitn().getGrpHdr().setInitgPty(new PartyIdentification135());
        doc.getCstmrCdtTrfInitn().getGrpHdr().getInitgPty().setNm(sepaParams.getProperty("src.name"));
        doc.getCstmrCdtTrfInitn().getGrpHdr().setCtrlSum(SepaUtil.sumBtgValue(sepaParams, maxIndex));
        ArrayList pmtInfs = (ArrayList)doc.getCstmrCdtTrfInitn().getPmtInf();
        PaymentInstruction40 pmtInf = new PaymentInstruction40();
        pmtInfs.add(pmtInf);
        pmtInf.setPmtInfId(pmtInfId != null && pmtInfId.length() > 0 ? pmtInfId : sepaId);
        pmtInf.setPmtMtd(PaymentMethod3Code.TRF);
        pmtInf.setNbOfTxs(String.valueOf(maxIndex != null ? maxIndex + 1 : 1));
        pmtInf.setCtrlSum(SepaUtil.sumBtgValue(sepaParams, maxIndex));
        pmtInf.setPmtTpInf(new PaymentTypeInformation26());
        ServiceLevel8Choice svc = new ServiceLevel8Choice();
        svc.setCd("SEPA");
        pmtInf.getPmtTpInf().getSvcLvl().add(svc);
        String date = sepaParams.getProperty("date");
        if (date == null) {
            date = "1999-01-01";
        }
        XMLGregorianCalendar d = SepaUtil.createCalendar(date);
        DateAndDateTime2Choice dd = new DateAndDateTime2Choice();
        dd.setDt(d);
        pmtInf.setReqdExctnDt(dd);
        pmtInf.setDbtr(new PartyIdentification135());
        pmtInf.setDbtrAcct(new CashAccount40());
        pmtInf.setDbtrAgt(new BranchAndFinancialInstitutionIdentification6());
        pmtInf.getDbtr().setNm(sepaParams.getProperty("src.name"));
        pmtInf.getDbtrAcct().setId(new AccountIdentification4Choice());
        pmtInf.getDbtrAcct().getId().setIBAN(sepaParams.getProperty("src.iban"));
        pmtInf.getDbtrAgt().setFinInstnId(new FinancialInstitutionIdentification18());
        String srcBic = sepaParams.getProperty("src.bic");
        if (srcBic != null && srcBic.length() > 0) {
            pmtInf.getDbtrAgt().getFinInstnId().setBICFI(srcBic);
        } else {
            pmtInf.getDbtrAgt().getFinInstnId().setOthr(new GenericFinancialIdentification1());
            pmtInf.getDbtrAgt().getFinInstnId().getOthr().setId("NOTPROVIDED");
        }
        pmtInf.setChrgBr(ChargeBearerType1Code.SLEV);
        ArrayList cdtTrxTxInfs = (ArrayList)pmtInf.getCdtTrfTxInf();
        if (maxIndex != null) {
            for (int tnr = 0; tnr <= maxIndex; ++tnr) {
                cdtTrxTxInfs.add(this.createCreditTransferTransaction(sepaParams, tnr));
            }
        } else {
            cdtTrxTxInfs.add(this.createCreditTransferTransaction(sepaParams, null));
        }
        String batch = SepaUtil.getProperty(sepaParams, "batchbook", null);
        if (batch != null) {
            pmtInf.setBtchBookg(batch.equals("1"));
        }
        ObjectFactory of = new ObjectFactory();
        this.marshal(of.createDocument(doc), os, validate);
    }

    private CreditTransferTransaction54 createCreditTransferTransaction(Properties sepaParams, Integer index) {
        String purposeCode;
        CreditTransferTransaction54 cdtTrxTxInf = new CreditTransferTransaction54();
        cdtTrxTxInf.setPmtId(new PaymentIdentification6());
        cdtTrxTxInf.getPmtId().setEndToEndId(SepaUtil.getProperty(sepaParams, SepaUtil.insertIndex("endtoendid", index), "NOTPROVIDED"));
        cdtTrxTxInf.setCdtr(new PartyIdentification135());
        cdtTrxTxInf.getCdtr().setNm(sepaParams.getProperty(SepaUtil.insertIndex("dst.name", index)));
        cdtTrxTxInf.setCdtrAcct(new CashAccount40());
        cdtTrxTxInf.getCdtrAcct().setId(new AccountIdentification4Choice());
        cdtTrxTxInf.getCdtrAcct().getId().setIBAN(sepaParams.getProperty(SepaUtil.insertIndex("dst.iban", index)));
        String dstBic = sepaParams.getProperty(SepaUtil.insertIndex("dst.bic", index));
        if (dstBic != null && dstBic.length() > 0) {
            cdtTrxTxInf.setCdtrAgt(new BranchAndFinancialInstitutionIdentification6());
            cdtTrxTxInf.getCdtrAgt().setFinInstnId(new FinancialInstitutionIdentification18());
            cdtTrxTxInf.getCdtrAgt().getFinInstnId().setBICFI(dstBic);
        }
        cdtTrxTxInf.setAmt(new AmountType4Choice());
        cdtTrxTxInf.getAmt().setInstdAmt(new ActiveOrHistoricCurrencyAndAmount());
        cdtTrxTxInf.getAmt().getInstdAmt().setValue(new BigDecimal(sepaParams.getProperty(SepaUtil.insertIndex("btg.value", index))));
        String currencyCode = sepaParams.getProperty(SepaUtil.insertIndex("btg.curr", index));
        if (currencyCode != null && currencyCode.length() > 0) {
            cdtTrxTxInf.getAmt().getInstdAmt().setCcy(currencyCode);
        } else {
            cdtTrxTxInf.getAmt().getInstdAmt().setCcy("EUR");
        }
        String usage = sepaParams.getProperty(SepaUtil.insertIndex("usage", index));
        if (usage != null && usage.length() > 0) {
            cdtTrxTxInf.setRmtInf(new RemittanceInformation21());
            cdtTrxTxInf.getRmtInf().getUstrd().add(usage);
        }
        if ((purposeCode = sepaParams.getProperty(SepaUtil.insertIndex("purposecode", index))) != null && purposeCode.length() > 0) {
            Purpose2Choice p = new Purpose2Choice();
            p.setCd(purposeCode);
            cdtTrxTxInf.setPurp(p);
        }
        return cdtTrxTxInf;
    }
}

