/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV.parsers;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.xml.bind.JAXB;
import org.kapott.hbci.GV.SepaUtil;
import org.kapott.hbci.GV.parsers.AbstractCamtParser;
import org.kapott.hbci.GV_Result.GVRKUms;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.sepa.jaxb.camt_052_001_03.AccountIdentification4Choice;
import org.kapott.hbci.sepa.jaxb.camt_052_001_03.AccountReport12;
import org.kapott.hbci.sepa.jaxb.camt_052_001_03.ActiveOrHistoricCurrencyAndAmount;
import org.kapott.hbci.sepa.jaxb.camt_052_001_03.BalanceType12Code;
import org.kapott.hbci.sepa.jaxb.camt_052_001_03.BankToCustomerAccountReportV03;
import org.kapott.hbci.sepa.jaxb.camt_052_001_03.BankTransactionCodeStructure4;
import org.kapott.hbci.sepa.jaxb.camt_052_001_03.BranchAndFinancialInstitutionIdentification5;
import org.kapott.hbci.sepa.jaxb.camt_052_001_03.CashAccount24;
import org.kapott.hbci.sepa.jaxb.camt_052_001_03.CashAccount25;
import org.kapott.hbci.sepa.jaxb.camt_052_001_03.CashBalance3;
import org.kapott.hbci.sepa.jaxb.camt_052_001_03.CreditDebitCode;
import org.kapott.hbci.sepa.jaxb.camt_052_001_03.DateAndDateTimeChoice;
import org.kapott.hbci.sepa.jaxb.camt_052_001_03.Document;
import org.kapott.hbci.sepa.jaxb.camt_052_001_03.EntryDetails2;
import org.kapott.hbci.sepa.jaxb.camt_052_001_03.EntryTransaction3;
import org.kapott.hbci.sepa.jaxb.camt_052_001_03.FinancialInstitutionIdentification8;
import org.kapott.hbci.sepa.jaxb.camt_052_001_03.GenericPersonIdentification1;
import org.kapott.hbci.sepa.jaxb.camt_052_001_03.Party11Choice;
import org.kapott.hbci.sepa.jaxb.camt_052_001_03.PartyIdentification43;
import org.kapott.hbci.sepa.jaxb.camt_052_001_03.PersonIdentification5;
import org.kapott.hbci.sepa.jaxb.camt_052_001_03.Purpose2Choice;
import org.kapott.hbci.sepa.jaxb.camt_052_001_03.ReportEntry3;
import org.kapott.hbci.sepa.jaxb.camt_052_001_03.TransactionAgents3;
import org.kapott.hbci.sepa.jaxb.camt_052_001_03.TransactionParties3;
import org.kapott.hbci.sepa.jaxb.camt_052_001_03.TransactionReferences3;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Saldo;
import org.kapott.hbci.structures.Value;

public class ParseCamt05200103
extends AbstractCamtParser {
    @Override
    public void parse(InputStream xml, List<GVRKUms.BTag> tage) {
        Document doc = (Document)JAXB.unmarshal((InputStream)xml, Document.class);
        BankToCustomerAccountReportV03 container = doc.getBkToCstmrAcctRpt();
        if (container == null) {
            HBCIUtils.log("camt document empty", 2);
            return;
        }
        List<AccountReport12> reports = container.getRpt();
        if (reports == null || reports.size() == 0) {
            HBCIUtils.log("camt document empty", 2);
            return;
        }
        for (AccountReport12 report : reports) {
            GVRKUms.UmsLine line;
            GVRKUms.BTag tag = this.createDay(report);
            tage.add(tag);
            BigDecimal saldo = tag.start.value.getBigDecimalValue();
            for (ReportEntry3 entry : report.getNtry()) {
                line = this.createLine(entry, saldo);
                if (line == null) continue;
                tag.lines.add(line);
                saldo = line.saldo.value.getBigDecimalValue();
            }
            if (tag.start.timestamp != null || tag.end.timestamp == null) continue;
            BigDecimal endSaldo = tag.end.value.getBigDecimalValue();
            int n = tag.lines.size();
            while (n > 0) {
                line = tag.lines.get(--n);
                line.saldo.value.setValue(endSaldo);
                endSaldo = endSaldo.subtract(line.value.getBigDecimalValue());
            }
        }
    }

    private GVRKUms.UmsLine createLine(ReportEntry3 entry, BigDecimal currSaldo) {
        Purpose2Choice purp;
        String[] parts;
        BankTransactionCodeStructure4 b;
        String code;
        List<String> usages;
        TransactionAgents3 banks;
        TransactionParties3 other;
        TransactionReferences3 ref;
        boolean rueckbuchung;
        GVRKUms.UmsLine line = new GVRKUms.UmsLine();
        line.isSepa = true;
        line.isCamt = true;
        line.other = new Konto();
        ActiveOrHistoricCurrencyAndAmount amt = entry.getAmt();
        BigDecimal bd = amt.getValue() != null ? amt.getValue() : BigDecimal.ZERO;
        line.value = new Value(this.checkDebit(bd, entry.getCdtDbtInd()));
        line.value.setCurr(amt.getCcy());
        line.isStorno = entry.isRvslInd() != null ? entry.isRvslInd() : false;
        DateAndDateTimeChoice bdate = entry.getBookgDt();
        line.bdate = bdate != null ? SepaUtil.toDate(bdate.getDt()) : null;
        DateAndDateTimeChoice vdate = entry.getValDt();
        Date date = line.valuta = vdate != null ? SepaUtil.toDate(vdate.getDt()) : null;
        if (line.bdate == null) {
            line.bdate = line.valuta;
        }
        if (line.valuta == null) {
            line.valuta = line.bdate;
        }
        line.saldo = new Saldo();
        line.saldo.value = new Value(currSaldo.add(line.value.getBigDecimalValue()));
        line.saldo.value.setCurr(line.value.getCurr());
        line.saldo.timestamp = line.bdate;
        line.text = this.trim(entry.getAddtlNtryInf());
        line.customerref = this.trim(entry.getAcctSvcrRef());
        List<EntryDetails2> details = entry.getNtryDtls();
        if (details.size() == 0) {
            line.usage.add(this.trim(entry.getAddtlNtryInf()));
            return line;
        }
        EntryDetails2 detail = details.get(0);
        List<EntryTransaction3> txList = detail.getTxDtls();
        if (txList.size() == 0) {
            return null;
        }
        boolean haben = entry.getCdtDbtInd() != null && entry.getCdtDbtInd() == CreditDebitCode.CRDT;
        EntryTransaction3 tx = txList.get(0);
        boolean bl = rueckbuchung = tx.getRtrInf() != null && tx.getRtrInf().getRsn() != null && tx.getRtrInf().getRsn().getCd() != null && tx.getRtrInf().getRsn().getCd().length() > 0;
        if (rueckbuchung) {
            boolean bl2 = haben = !haben;
        }
        if ((ref = tx.getRefs()) != null) {
            line.id = this.trim(ref.getPrtry() != null && ref.getPrtry().size() > 0 ? ref.getPrtry().get(0).getRef() : null);
            if (line.id == null) {
                line.id = Optional.ofNullable(entry.getAcctSvcrRef()).orElse(ref.getAcctSvcrRef());
            }
            line.endToEndId = this.trim(ref.getEndToEndId());
            line.mandateId = this.trim(ref.getMndtId());
        }
        if ((other = tx.getRltdPties()) != null) {
            CashAccount24 acc = haben ? other.getDbtrAcct() : other.getCdtrAcct();
            AccountIdentification4Choice id = acc != null ? acc.getId() : null;
            line.other.iban = this.trim(id != null ? id.getIBAN() : null);
            PartyIdentification43 name = haben ? other.getDbtr() : other.getCdtr();
            line.other.name = this.trim(name != null ? name.getNm() : null);
            Party11Choice id2 = name != null ? name.getId() : null;
            PersonIdentification5 prvtId = id2 != null ? id2.getPrvtId() : null;
            List<GenericPersonIdentification1> othr = prvtId != null ? prvtId.getOthr() : null;
            GenericPersonIdentification1 genericPersonIdentification1 = othr != null && !othr.isEmpty() ? othr.get(0) : null;
            line.other.creditorid = this.trim(genericPersonIdentification1 != null ? genericPersonIdentification1.getId() : null);
            name = haben ? other.getUltmtDbtr() : other.getUltmtCdtr();
            line.other.name2 = this.trim(name != null ? name.getNm() : null);
        }
        if ((banks = tx.getRltdAgts()) != null) {
            BranchAndFinancialInstitutionIdentification5 bank = haben ? banks.getDbtrAgt() : banks.getCdtrAgt();
            FinancialInstitutionIdentification8 bic = bank != null ? bank.getFinInstnId() : null;
            line.other.bic = this.trim(bic != null ? bic.getBICFI() : null);
        }
        List<String> list = usages = tx.getRmtInf() != null ? tx.getRmtInf().getUstrd() : null;
        if (usages != null && usages.size() > 0) {
            line.usage.addAll(this.trim(usages));
        }
        String string = code = (b = tx.getBkTxCd()) != null && b.getPrtry() != null ? b.getPrtry().getCd() : null;
        if (code != null && code.contains("+") && (parts = code.split("\\+")).length == 4) {
            line.gvcode = parts[1];
            line.primanota = parts[2];
            line.addkey = parts[3];
        }
        line.purposecode = this.trim((purp = tx.getPurp()) != null ? purp.getCd() : null);
        return line;
    }

    private GVRKUms.BTag createDay(AccountReport12 report) {
        GVRKUms.BTag tag = new GVRKUms.BTag();
        tag.starttype = (char)70;
        tag.endtype = (char)70;
        tag.start = new Saldo();
        tag.end = new Saldo();
        long day = 86400000L;
        if (report.getBal().size() > 0) {
            CashBalance3 secondBal;
            BalanceType12Code secondCode;
            CashBalance3 firstBal = report.getBal().get(0);
            BalanceType12Code firstCode = firstBal.getTp().getCdOrPrtry().getCd();
            if (firstCode == BalanceType12Code.PRCD || firstCode == BalanceType12Code.ITBD || firstCode == BalanceType12Code.OPBD) {
                tag.start.value = new Value(this.checkDebit(firstBal.getAmt().getValue(), firstBal.getCdtDbtInd()));
                tag.start.value.setCurr(firstBal.getAmt().getCcy());
                tag.start.timestamp = firstCode == BalanceType12Code.PRCD ? new Date(SepaUtil.toDate(firstBal.getDt().getDt()).getTime() + 86400000L) : new Date(SepaUtil.toDate(firstBal.getDt().getDt()).getTime());
            }
            if (report.getBal().size() > 1 && ((secondCode = (secondBal = report.getBal().get(1)).getTp().getCdOrPrtry().getCd()) == BalanceType12Code.CLBD || secondCode == BalanceType12Code.ITBD)) {
                tag.end.value = new Value(this.checkDebit(secondBal.getAmt().getValue(), secondBal.getCdtDbtInd()));
                tag.end.value.setCurr(secondBal.getAmt().getCcy());
                tag.end.timestamp = SepaUtil.toDate(secondBal.getDt().getDt());
            }
        }
        CashAccount25 acc = report.getAcct();
        tag.my = new Konto();
        tag.my.iban = this.trim(acc.getId().getIBAN());
        tag.my.curr = this.trim(acc.getCcy());
        BranchAndFinancialInstitutionIdentification5 bank = acc.getSvcr();
        if (bank != null && bank.getFinInstnId() != null) {
            tag.my.bic = this.trim(bank.getFinInstnId().getBICFI());
        }
        return tag;
    }

    private BigDecimal checkDebit(BigDecimal d, CreditDebitCode code) {
        if (d == null || code == null || code == CreditDebitCode.CRDT) {
            return d;
        }
        return BigDecimal.ZERO.subtract(d);
    }
}

