/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV.parsers;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.xml.bind.JAXB;
import org.kapott.hbci.GV.SepaUtil;
import org.kapott.hbci.GV.parsers.AbstractCamtParser;
import org.kapott.hbci.GV_Result.GVRKUms;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.sepa.jaxb.camt_052_001_09.AccountIdentification4Choice;
import org.kapott.hbci.sepa.jaxb.camt_052_001_09.AccountReport30;
import org.kapott.hbci.sepa.jaxb.camt_052_001_09.ActiveOrHistoricCurrencyAndAmount;
import org.kapott.hbci.sepa.jaxb.camt_052_001_09.BankToCustomerAccountReportV09;
import org.kapott.hbci.sepa.jaxb.camt_052_001_09.BankTransactionCodeStructure4;
import org.kapott.hbci.sepa.jaxb.camt_052_001_09.BranchAndFinancialInstitutionIdentification6;
import org.kapott.hbci.sepa.jaxb.camt_052_001_09.CashAccount40;
import org.kapott.hbci.sepa.jaxb.camt_052_001_09.CashAccount41;
import org.kapott.hbci.sepa.jaxb.camt_052_001_09.CashBalance8;
import org.kapott.hbci.sepa.jaxb.camt_052_001_09.CreditDebitCode;
import org.kapott.hbci.sepa.jaxb.camt_052_001_09.DateAndDateTime2Choice;
import org.kapott.hbci.sepa.jaxb.camt_052_001_09.Document;
import org.kapott.hbci.sepa.jaxb.camt_052_001_09.EntryDetails10;
import org.kapott.hbci.sepa.jaxb.camt_052_001_09.EntryTransaction11;
import org.kapott.hbci.sepa.jaxb.camt_052_001_09.FinancialInstitutionIdentification18;
import org.kapott.hbci.sepa.jaxb.camt_052_001_09.GenericPersonIdentification1;
import org.kapott.hbci.sepa.jaxb.camt_052_001_09.Party38Choice;
import org.kapott.hbci.sepa.jaxb.camt_052_001_09.Party40Choice;
import org.kapott.hbci.sepa.jaxb.camt_052_001_09.PartyIdentification135;
import org.kapott.hbci.sepa.jaxb.camt_052_001_09.PersonIdentification13;
import org.kapott.hbci.sepa.jaxb.camt_052_001_09.Purpose2Choice;
import org.kapott.hbci.sepa.jaxb.camt_052_001_09.ReportEntry11;
import org.kapott.hbci.sepa.jaxb.camt_052_001_09.TransactionAgents5;
import org.kapott.hbci.sepa.jaxb.camt_052_001_09.TransactionParties9;
import org.kapott.hbci.sepa.jaxb.camt_052_001_09.TransactionReferences6;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Saldo;
import org.kapott.hbci.structures.Value;

public class ParseCamt05200109
extends AbstractCamtParser {
    @Override
    public void parse(InputStream xml, List<GVRKUms.BTag> tage) {
        Document doc = (Document)JAXB.unmarshal((InputStream)xml, Document.class);
        BankToCustomerAccountReportV09 container = doc.getBkToCstmrAcctRpt();
        if (container == null) {
            HBCIUtils.log("camt document empty", 2);
            return;
        }
        List<AccountReport30> reports = container.getRpt();
        if (reports == null || reports.size() == 0) {
            HBCIUtils.log("camt document empty", 2);
            return;
        }
        for (AccountReport30 report : reports) {
            GVRKUms.UmsLine line;
            GVRKUms.BTag tag = this.createDay(report);
            tage.add(tag);
            BigDecimal saldo = tag.start.value.getBigDecimalValue();
            for (ReportEntry11 entry : report.getNtry()) {
                line = this.createLine(entry, saldo);
                if (line == null) continue;
                tag.lines.add(line);
                saldo = line.saldo.value.getBigDecimalValue();
            }
            if (tag.start.timestamp != null || tag.end.timestamp == null) continue;
            BigDecimal endSaldo = tag.end.value.getBigDecimalValue();
            int n = tag.lines.size();
            while (n > 0) {
                line = tag.lines.get(--n);
                line.saldo.value.setValue(endSaldo);
                endSaldo = endSaldo.subtract(line.value.getBigDecimalValue());
            }
        }
    }

    private GVRKUms.UmsLine createLine(ReportEntry11 entry, BigDecimal currSaldo) {
        Purpose2Choice purp;
        BankTransactionCodeStructure4 b;
        String code;
        List<String> usages;
        TransactionAgents5 banks;
        TransactionParties9 other;
        TransactionReferences6 ref;
        boolean rueckbuchung;
        GVRKUms.UmsLine line = new GVRKUms.UmsLine();
        line.isSepa = true;
        line.isCamt = true;
        line.other = new Konto();
        ActiveOrHistoricCurrencyAndAmount amt = entry.getAmt();
        BigDecimal bd = amt.getValue() != null ? amt.getValue() : BigDecimal.ZERO;
        line.value = new Value(this.checkDebit(bd, entry.getCdtDbtInd()));
        line.value.setCurr(amt.getCcy());
        line.isStorno = entry.isRvslInd() != null ? entry.isRvslInd() : false;
        DateAndDateTime2Choice bdate = entry.getBookgDt();
        line.bdate = bdate != null ? SepaUtil.toDate(bdate.getDt()) : null;
        DateAndDateTime2Choice vdate = entry.getValDt();
        Date date = line.valuta = vdate != null ? SepaUtil.toDate(vdate.getDt()) : null;
        if (line.bdate == null) {
            line.bdate = line.valuta;
        }
        if (line.valuta == null) {
            line.valuta = line.bdate;
        }
        line.saldo = new Saldo();
        line.saldo.value = new Value(currSaldo.add(line.value.getBigDecimalValue()));
        line.saldo.value.setCurr(line.value.getCurr());
        line.saldo.timestamp = line.bdate;
        line.text = this.trim(entry.getAddtlNtryInf());
        line.customerref = this.trim(entry.getAcctSvcrRef());
        List<EntryDetails10> details = entry.getNtryDtls();
        if (details.size() == 0) {
            line.usage.add(this.trim(entry.getAddtlNtryInf()));
            return line;
        }
        EntryDetails10 detail = details.get(0);
        List<EntryTransaction11> txList = detail.getTxDtls();
        if (txList.size() == 0) {
            return null;
        }
        boolean haben = entry.getCdtDbtInd() != null && entry.getCdtDbtInd() == CreditDebitCode.CRDT;
        EntryTransaction11 tx = txList.get(0);
        boolean bl = rueckbuchung = tx.getRtrInf() != null && tx.getRtrInf().getRsn() != null && tx.getRtrInf().getRsn().getCd() != null && tx.getRtrInf().getRsn().getCd().length() > 0;
        if (rueckbuchung) {
            boolean bl2 = haben = !haben;
        }
        if ((ref = tx.getRefs()) != null) {
            line.id = this.trim(ref.getPrtry() != null && ref.getPrtry().size() > 0 ? ref.getPrtry().get(0).getRef() : null);
            if (line.id == null) {
                line.id = Optional.ofNullable(entry.getAcctSvcrRef()).orElse(ref.getAcctSvcrRef());
            }
            line.endToEndId = this.trim(ref.getEndToEndId());
            line.mandateId = this.trim(ref.getMndtId());
        }
        if ((other = tx.getRltdPties()) != null) {
            CashAccount40 acc = haben ? other.getDbtrAcct() : other.getCdtrAcct();
            AccountIdentification4Choice id = acc != null ? acc.getId() : null;
            line.other.iban = this.trim(id != null ? id.getIBAN() : null);
            Party40Choice party = haben ? other.getDbtr() : other.getCdtr();
            PartyIdentification135 pi = party != null ? party.getPty() : null;
            line.other.name = this.trim(pi != null ? pi.getNm() : null);
            Party38Choice id2 = pi != null ? pi.getId() : null;
            PersonIdentification13 prvtId = id2 != null ? id2.getPrvtId() : null;
            List<GenericPersonIdentification1> othr = prvtId != null ? prvtId.getOthr() : null;
            GenericPersonIdentification1 genericPersonIdentification1 = othr != null && !othr.isEmpty() ? othr.get(0) : null;
            line.other.creditorid = this.trim(genericPersonIdentification1 != null ? genericPersonIdentification1.getId() : null);
            party = haben ? other.getUltmtDbtr() : other.getUltmtCdtr();
            pi = party != null ? party.getPty() : null;
            line.other.name2 = this.trim(pi != null ? pi.getNm() : null);
        }
        if ((banks = tx.getRltdAgts()) != null) {
            BranchAndFinancialInstitutionIdentification6 bank = haben ? banks.getDbtrAgt() : banks.getCdtrAgt();
            FinancialInstitutionIdentification18 bic = bank != null ? bank.getFinInstnId() : null;
            line.other.bic = this.trim(bic != null ? bic.getBICFI() : null);
        }
        List<String> list = usages = tx.getRmtInf() != null ? tx.getRmtInf().getUstrd() : null;
        if (usages != null && usages.size() > 0) {
            line.usage.addAll(this.trim(usages));
        }
        String string = code = (b = tx.getBkTxCd()) != null && b.getPrtry() != null ? b.getPrtry().getCd() : null;
        if (code != null && code.contains("+")) {
            String[] parts = code.split("\\+");
            if (parts.length == 4) {
                line.gvcode = parts[1];
                line.primanota = parts[2];
                line.addkey = parts[3];
            } else if (parts.length == 3) {
                line.gvcode = parts[0];
                line.primanota = parts[1];
                line.addkey = parts[2];
            }
        }
        line.purposecode = this.trim((purp = tx.getPurp()) != null ? purp.getCd() : null);
        return line;
    }

    private GVRKUms.BTag createDay(AccountReport30 report) {
        GVRKUms.BTag tag = new GVRKUms.BTag();
        tag.starttype = (char)70;
        tag.endtype = (char)70;
        tag.start = new Saldo();
        tag.end = new Saldo();
        long day = 86400000L;
        if (report.getBal().size() > 0) {
            CashBalance8 secondBal;
            String secondCode;
            CashBalance8 firstBal = report.getBal().get(0);
            String firstCode = firstBal.getTp().getCdOrPrtry().getCd();
            if (firstCode.equalsIgnoreCase("PRCD") || firstCode.equalsIgnoreCase("ITBD") || firstCode.equalsIgnoreCase("OPBD")) {
                tag.start.value = new Value(this.checkDebit(firstBal.getAmt().getValue(), firstBal.getCdtDbtInd()));
                tag.start.value.setCurr(firstBal.getAmt().getCcy());
                tag.start.timestamp = firstCode.equalsIgnoreCase("PRCD") ? new Date(SepaUtil.toDate(firstBal.getDt().getDt()).getTime() + 86400000L) : new Date(SepaUtil.toDate(firstBal.getDt().getDt()).getTime());
            }
            if (report.getBal().size() > 1 && ((secondCode = (secondBal = report.getBal().get(1)).getTp().getCdOrPrtry().getCd()).equalsIgnoreCase("CLBD") || secondCode.equalsIgnoreCase("ITBD"))) {
                tag.end.value = new Value(this.checkDebit(secondBal.getAmt().getValue(), secondBal.getCdtDbtInd()));
                tag.end.value.setCurr(secondBal.getAmt().getCcy());
                tag.end.timestamp = SepaUtil.toDate(secondBal.getDt().getDt());
            }
        }
        CashAccount41 acc = report.getAcct();
        tag.my = new Konto();
        tag.my.iban = this.trim(acc.getId().getIBAN());
        tag.my.curr = this.trim(acc.getCcy());
        BranchAndFinancialInstitutionIdentification6 bank = acc.getSvcr();
        if (bank != null && bank.getFinInstnId() != null) {
            tag.my.bic = this.trim(bank.getFinInstnId().getBICFI());
        }
        return tag;
    }

    private BigDecimal checkDebit(BigDecimal d, CreditDebitCode code) {
        if (d == null || code == null || code == CreditDebitCode.CRDT) {
            return d;
        }
        return BigDecimal.ZERO.subtract(d);
    }
}

