/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV.parsers;

import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import javax.xml.bind.JAXB;
import javax.xml.datatype.XMLGregorianCalendar;
import org.kapott.hbci.GV.SepaUtil;
import org.kapott.hbci.GV.parsers.AbstractSepaParser;
import org.kapott.hbci.GV.parsers.ISEPAParser;
import org.kapott.hbci.sepa.jaxb.pain_001_001_09.ActiveOrHistoricCurrencyAndAmount;
import org.kapott.hbci.sepa.jaxb.pain_001_001_09.CreditTransferTransaction34;
import org.kapott.hbci.sepa.jaxb.pain_001_001_09.CustomerCreditTransferInitiationV09;
import org.kapott.hbci.sepa.jaxb.pain_001_001_09.DateAndDateTime2Choice;
import org.kapott.hbci.sepa.jaxb.pain_001_001_09.Document;
import org.kapott.hbci.sepa.jaxb.pain_001_001_09.PaymentIdentification6;
import org.kapott.hbci.sepa.jaxb.pain_001_001_09.PaymentInstruction30;
import org.kapott.hbci.sepa.jaxb.pain_001_001_09.Purpose2Choice;
import org.kapott.hbci.tools.StringUtil;

public class ParsePain00100109
extends AbstractSepaParser<List<Properties>> {
    @Override
    public void parse(InputStream xml, List<Properties> sepaResults) {
        Document doc = (Document)JAXB.unmarshal((InputStream)xml, Document.class);
        CustomerCreditTransferInitiationV09 pain = doc.getCstmrCdtTrfInitn();
        if (pain == null) {
            return;
        }
        List<PaymentInstruction30> pmtInfs = pain.getPmtInf();
        for (PaymentInstruction30 pmtInf : pmtInfs) {
            List<CreditTransferTransaction34> txList = pmtInf.getCdtTrfTxInf();
            for (CreditTransferTransaction34 tx : txList) {
                PaymentIdentification6 pmtId;
                DateAndDateTime2Choice dt;
                XMLGregorianCalendar date;
                Purpose2Choice purp;
                String usage;
                Properties prop = new Properties();
                this.put(prop, ISEPAParser.Names.PMTINFID, pmtInf.getPmtInfId());
                this.put(prop, ISEPAParser.Names.SRC_NAME, pain.getGrpHdr().getInitgPty().getNm());
                this.put(prop, ISEPAParser.Names.SRC_IBAN, pmtInf.getDbtrAcct().getId().getIBAN());
                this.put(prop, ISEPAParser.Names.SRC_BIC, pmtInf.getDbtrAgt().getFinInstnId().getBICFI());
                this.put(prop, ISEPAParser.Names.BATCHBOOK, pmtInf.isBtchBookg() != null ? pmtInf.isBtchBookg().toString() : null);
                this.put(prop, ISEPAParser.Names.DST_NAME, tx.getCdtr().getNm());
                this.put(prop, ISEPAParser.Names.DST_IBAN, tx.getCdtrAcct().getId().getIBAN());
                try {
                    this.put(prop, ISEPAParser.Names.DST_BIC, tx.getCdtrAgt().getFinInstnId().getBICFI());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ActiveOrHistoricCurrencyAndAmount amt = tx.getAmt().getInstdAmt();
                this.put(prop, ISEPAParser.Names.VALUE, SepaUtil.format(amt.getValue()));
                this.put(prop, ISEPAParser.Names.CURR, amt.getCcy());
                if (tx.getRmtInf() != null && (usage = StringUtil.join(tx.getRmtInf().getUstrd(), System.getProperty("line.separator"))) != null) {
                    this.put(prop, ISEPAParser.Names.USAGE, usage);
                }
                if ((purp = tx.getPurp()) != null) {
                    this.put(prop, ISEPAParser.Names.PURPOSECODE, purp.getCd());
                }
                XMLGregorianCalendar xMLGregorianCalendar = date = (dt = pmtInf.getReqdExctnDt()) != null ? dt.getDt() : null;
                if (date != null) {
                    this.put(prop, ISEPAParser.Names.DATE, SepaUtil.format(date, null));
                }
                if ((pmtId = tx.getPmtId()) != null) {
                    this.put(prop, ISEPAParser.Names.ENDTOENDID, pmtId.getEndToEndId());
                }
                sepaResults.add(prop);
            }
        }
    }
}

