/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV.parsers;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import javax.xml.bind.JAXB;
import javax.xml.datatype.XMLGregorianCalendar;
import org.kapott.hbci.GV.SepaUtil;
import org.kapott.hbci.GV.parsers.AbstractSepaParser;
import org.kapott.hbci.GV.parsers.ISEPAParser;
import org.kapott.hbci.sepa.jaxb.pain_008_001_10.ActiveOrHistoricCurrencyAndAmount;
import org.kapott.hbci.sepa.jaxb.pain_008_001_10.CustomerDirectDebitInitiationV10;
import org.kapott.hbci.sepa.jaxb.pain_008_001_10.DirectDebitTransactionInformation28;
import org.kapott.hbci.sepa.jaxb.pain_008_001_10.Document;
import org.kapott.hbci.sepa.jaxb.pain_008_001_10.GenericPersonIdentification1;
import org.kapott.hbci.sepa.jaxb.pain_008_001_10.PaymentInstruction39;
import org.kapott.hbci.sepa.jaxb.pain_008_001_10.PaymentTypeInformation29;
import org.kapott.hbci.sepa.jaxb.pain_008_001_10.PersonIdentificationSchemeName1Choice;
import org.kapott.hbci.sepa.jaxb.pain_008_001_10.Purpose2Choice;
import org.kapott.hbci.tools.StringUtil;

public class ParsePain00800110
extends AbstractSepaParser<List<Properties>> {
    @Override
    public void parse(InputStream xml, List<Properties> sepaResults) {
        Document doc = (Document)JAXB.unmarshal((InputStream)xml, Document.class);
        CustomerDirectDebitInitiationV10 pain = doc.getCstmrDrctDbtInitn();
        if (pain == null) {
            return;
        }
        List<PaymentInstruction39> pmtInfs = pain.getPmtInf();
        for (PaymentInstruction39 pmtInf : pmtInfs) {
            List<DirectDebitTransactionInformation28> txList = pmtInf.getDrctDbtTxInf();
            for (DirectDebitTransactionInformation28 tx : txList) {
                PaymentTypeInformation29 pti;
                XMLGregorianCalendar date;
                Purpose2Choice purp;
                String usage;
                Properties prop = new Properties();
                this.put(prop, ISEPAParser.Names.PMTINFID, pmtInf.getPmtInfId());
                this.put(prop, ISEPAParser.Names.SRC_NAME, pain.getGrpHdr().getInitgPty().getNm());
                this.put(prop, ISEPAParser.Names.SRC_IBAN, pmtInf.getCdtrAcct().getId().getIBAN());
                this.put(prop, ISEPAParser.Names.SRC_BIC, pmtInf.getCdtrAgt().getFinInstnId().getBICFI());
                this.put(prop, ISEPAParser.Names.BATCHBOOK, pmtInf.isBtchBookg() != null ? pmtInf.isBtchBookg().toString() : null);
                this.put(prop, ISEPAParser.Names.DST_NAME, tx.getDbtr().getNm());
                this.put(prop, ISEPAParser.Names.DST_IBAN, tx.getDbtrAcct().getId().getIBAN());
                try {
                    this.put(prop, ISEPAParser.Names.DST_BIC, tx.getDbtrAgt().getFinInstnId().getBICFI());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ActiveOrHistoricCurrencyAndAmount amt = tx.getInstdAmt();
                this.put(prop, ISEPAParser.Names.VALUE, SepaUtil.format(amt.getValue()));
                this.put(prop, ISEPAParser.Names.CURR, amt.getCcy());
                if (tx.getRmtInf() != null && (usage = StringUtil.join(tx.getRmtInf().getUstrd(), System.getProperty("line.separator"))) != null) {
                    this.put(prop, ISEPAParser.Names.USAGE, usage);
                }
                if ((purp = tx.getPurp()) != null) {
                    this.put(prop, ISEPAParser.Names.PURPOSECODE, purp.getCd());
                }
                if ((date = pmtInf.getReqdColltnDt()) != null) {
                    this.put(prop, ISEPAParser.Names.TARGETDATE, SepaUtil.format(date, null));
                }
                this.put(prop, ISEPAParser.Names.ENDTOENDID, tx.getPmtId().getEndToEndId());
                try {
                    this.put(prop, ISEPAParser.Names.CREDITORID, this.findId(tx.getDrctDbtTx().getCdtrSchmeId().getId().getPrvtId().getOthr()));
                }
                catch (Exception e) {
                    this.put(prop, ISEPAParser.Names.CREDITORID, this.findId(pmtInf.getCdtrSchmeId().getId().getPrvtId().getOthr()));
                }
                this.put(prop, ISEPAParser.Names.MANDATEID, tx.getDrctDbtTx().getMndtRltdInf().getMndtId());
                XMLGregorianCalendar mandDate = tx.getDrctDbtTx().getMndtRltdInf().getDtOfSgntr();
                if (mandDate != null) {
                    this.put(prop, ISEPAParser.Names.MANDDATEOFSIG, SepaUtil.format(mandDate, null));
                }
                if ((pti = pmtInf.getPmtTpInf()) != null) {
                    this.put(prop, ISEPAParser.Names.SEQUENCETYPE, pti.getSeqTp() != null ? pti.getSeqTp().value() : "FRST");
                    this.put(prop, ISEPAParser.Names.LAST_TYPE, pti.getLclInstrm() != null ? pti.getLclInstrm().getCd() : "CORE");
                }
                sepaResults.add(prop);
            }
        }
    }

    private String findId(List<GenericPersonIdentification1> othr) {
        if (othr == null) {
            return null;
        }
        ArrayList<String> ids = new ArrayList<String>();
        for (GenericPersonIdentification1 o : othr) {
            String id = o.getId();
            if (id == null || id.length() == 0) continue;
            ids.add(id);
            PersonIdentificationSchemeName1Choice type = o.getSchmeNm();
            if (type == null || !Objects.equals("SEPA", type.getPrtry())) continue;
            return id;
        }
        return ids.size() > 0 ? (String)ids.get(0) : null;
    }
}

