/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV_Result;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.kapott.hbci.GV_Result.HBCIJobResultImpl;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.HBCIUtilsInternal;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Value;

public final class GVRDauerLastList
extends HBCIJobResultImpl {
    private final List<Dauer> entries = new ArrayList<Dauer>();

    public void addEntry(Dauer entry) {
        this.entries.add(entry);
    }

    public Dauer[] getEntries() {
        return this.entries.toArray(new Dauer[0]);
    }

    @Override
    public String toString() {
        StringBuilder ret = new StringBuilder();
        Iterator<Dauer> i = this.entries.iterator();
        while (i.hasNext()) {
            ret.append(HBCIUtilsInternal.getLocMsg("STANDINGORDER")).append(" #").append(i).append(System.getProperty("line.separator"));
            ret.append(i.next()).append(System.getProperty("line.separator"));
        }
        return ret.toString().trim();
    }

    public static final class Dauer {
        public Konto my;
        public Konto other;
        public Value value;
        public String key;
        public String addkey;
        public String[] usage = new String[0];
        public Date nextdate;
        public String orderid;
        public String type;
        public String sequencetype;
        public String creditorid;
        public String mandateid;
        public Date manddateofsig;
        public String endtoendid;
        public Date firstdate;
        public String timeunit;
        public int turnus;
        public int execday;
        public Date lastdate;
        public boolean aus_available;
        public boolean aus_annual;
        public Date aus_start;
        public Date aus_end;
        public String aus_breakcount;
        public Value aus_newvalue;
        public boolean can_change;
        public boolean can_skip;
        public boolean can_delete;
        public String pmtinfid;

        public void addUsage(String line) {
            ArrayList<String> a = new ArrayList<String>(Arrays.asList(this.usage));
            a.add(line);
            this.usage = a.toArray(this.usage);
        }

        public String toString() {
            StringBuilder ret = new StringBuilder();
            String linesep = System.getProperty("line.separator");
            ret.append("  ").append(HBCIUtilsInternal.getLocMsg("SRCACCOUNT")).append(": ").append(this.my.toString()).append(linesep);
            ret.append("  ").append(HBCIUtilsInternal.getLocMsg("DSTACCOUNT")).append(": ").append(this.other.toString()).append(linesep);
            ret.append("  ").append(HBCIUtilsInternal.getLocMsg("VALUE")).append(": ").append(this.value.toString()).append(linesep);
            ret.append("  ").append(HBCIUtilsInternal.getLocMsg("KEY")).append(": ").append(this.key).append("/").append(this.addkey).append(linesep);
            ret.append("  ").append(HBCIUtilsInternal.getLocMsg("USAGE")).append(":").append(linesep);
            for (String s : this.usage) {
                ret.append("    ").append(s).append(linesep);
            }
            if (this.nextdate != null) {
                ret.append("  ").append(HBCIUtilsInternal.getLocMsg("NEXTEXECDATE")).append(": ").append(HBCIUtils.date2StringLocal(this.nextdate)).append(linesep);
            }
            ret.append("  ").append(HBCIUtilsInternal.getLocMsg("ORDERID")).append(": ").append(this.orderid).append(linesep);
            ret.append("  ").append(HBCIUtilsInternal.getLocMsg("FIRSTLASTEXEC")).append(": ").append(HBCIUtils.date2StringLocal(this.firstdate)).append(" / ");
            ret.append(this.lastdate != null ? HBCIUtils.date2StringLocal(this.lastdate) : "N/A").append(linesep);
            ret.append("  ").append(HBCIUtilsInternal.getLocMsg("EXECDAY")).append(": ").append(this.execday).append(linesep);
            ret.append("  ").append(HBCIUtilsInternal.getLocMsg("UNITTURNUS")).append(": ").append(this.timeunit).append(" / ").append(this.turnus).append(linesep);
            ret.append("  (Aussetzung not yet implemented)");
            return ret.toString().trim();
        }
    }
}

