/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.dialog;

import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.kapott.hbci.dialog.DialogContext;
import org.kapott.hbci.dialog.DialogEvent;
import org.kapott.hbci.dialog.HBCIDialogEnd;
import org.kapott.hbci.dialog.KnownDialogTemplate;
import org.kapott.hbci.dialog.KnownReturncode;
import org.kapott.hbci.dialog.KnownTANProcess;
import org.kapott.hbci.dialog.RawHBCIDialog;
import org.kapott.hbci.dialog.SCARequest;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.Feature;
import org.kapott.hbci.manager.HBCIKernelImpl;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.kapott.hbci.tools.StringUtil;

public abstract class AbstractRawHBCIDialog
implements RawHBCIDialog {
    private KnownDialogTemplate template = null;
    private AtomicInteger executions = new AtomicInteger(0);

    AbstractRawHBCIDialog(KnownDialogTemplate template) {
        this.template = template;
    }

    @Override
    public final HBCIMsgStatus execute(DialogContext ctx) {
        HBCIMsgStatus status = null;
        do {
            if (ctx.isDialogEnd()) {
                ctx.setDialogEnd(false);
                HBCIDialogEnd end = new HBCIDialogEnd(new HBCIDialogEnd.Flag[0]);
                end.execute(ctx);
            }
            ctx.setRepeat(false);
            if (this.executions.get() > 2 && (!Feature.PINTAN_DECOUPLED_REFRESH.isEnabled() || ctx.getMsgStatus() != null && ctx.getMsgStatus().segStatus != null && KnownReturncode.W3956.searchReturnValue(ctx.getMsgStatus().segStatus.getWarnings()) == null)) {
                HBCIUtils.log("dialog loop detected for " + (Object)((Object)this.getTemplate()) + ", id " + ctx.getDialogId() + ", message number: " + ctx.getMsgNum() + ", execution count: " + this.executions.get(), 1);
                throw new HBCI_Exception("dialog loop detected for " + (Object)((Object)this.getTemplate()));
            }
            ctx.setDialogInit(this);
            HBCIPassportInternal p = ctx.getPassport();
            HBCIKernelImpl k = ctx.getKernel();
            p.onDialogEvent(DialogEvent.MSG_CREATE, ctx);
            String dialog = this.getActualTemplate(ctx);
            HBCIUtils.log("creating dialog " + dialog + ", id " + ctx.getDialogId() + ", message number: " + ctx.getMsgNum() + ", execution count: " + this.executions.get(), 4);
            k.rawNewMsg(dialog);
            this.applyData(ctx);
            p.onDialogEvent(DialogEvent.MSG_CREATED, ctx);
            HBCIUtils.log("sending message using dialog " + dialog + ", id " + ctx.getDialogId() + ", message number: " + ctx.getMsgNum(), 4);
            status = this.sendData(ctx);
            ctx.update(status);
            this.executions.incrementAndGet();
            p.onDialogEvent(DialogEvent.MSG_SENT, ctx);
            this.checkResult(ctx);
        } while (ctx.isRepeat());
        return status;
    }

    protected HBCIMsgStatus sendData(DialogContext ctx) {
        boolean a = ctx.isAnonymous();
        return ctx.getKernel().rawDoIt(!a, !a, !a);
    }

    protected void applyData(DialogContext ctx) {
        HBCIKernelImpl k = ctx.getKernel();
        k.rawSet("MsgHead.dialogid", ctx.getDialogId());
        k.rawSet("MsgHead.msgnum", Integer.toString(ctx.getMsgNum()));
        k.rawSet("MsgTail.msgnum", Integer.toString(ctx.getMsgNum()));
    }

    protected void checkResult(DialogContext ctx) {
    }

    @Override
    public SCARequest createSCARequest(Properties secmechInfo, int hktanVersion) {
        SCARequest r = new SCARequest();
        r.setVersion(hktanVersion);
        r.setVariant(KnownTANProcess.Variant.determine(secmechInfo != null ? secmechInfo.getProperty("process") : null));
        return r;
    }

    @Override
    public KnownDialogTemplate getTemplate() {
        return this.template;
    }

    @Override
    public void setTemplate(KnownDialogTemplate t) {
        this.template = t;
    }

    protected String getActualTemplate(DialogContext ctx) {
        return this.getTemplate().getName();
    }

    protected Integer getSegmentVersion(DialogContext ctx, String gvName, Integer defaultVersion) {
        HBCIPassportInternal p = ctx.getPassport();
        Properties props = p.getParamSegmentNames();
        String version = props.getProperty(gvName);
        if (!StringUtil.hasText(version)) {
            return defaultVersion;
        }
        try {
            return Integer.valueOf(version);
        }
        catch (Exception e) {
            HBCIUtils.log("invalid segment version: " + version, 2);
            return defaultVersion;
        }
    }
}

