/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.dialog;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.kapott.hbci.dialog.RawHBCIDialog;
import org.kapott.hbci.manager.HBCIDialog;
import org.kapott.hbci.manager.HBCIKernelImpl;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.status.HBCIMsgStatus;

public class DialogContext {
    private static final String DIALOGID_INITIAL = "0";
    private static final int MSGNUM_INITIAL = 1;
    private HBCIKernelImpl kernel;
    private HBCIPassportInternal passport;
    private HBCIMsgStatus msgStatus;
    private RawHBCIDialog init;
    private HBCIDialog dialog;
    private Map<String, Object> meta = new HashMap<String, Object>();
    private AtomicInteger msgNum = new AtomicInteger(1);
    private String dialogId;
    private boolean anonymous = false;
    private final AtomicBoolean repeat = new AtomicBoolean(false);
    private final AtomicBoolean dialogEnd = new AtomicBoolean(false);

    public static DialogContext create(HBCIKernelImpl kernel, HBCIPassportInternal passport) {
        DialogContext ctx = new DialogContext();
        ctx.kernel = kernel;
        ctx.passport = passport;
        return ctx;
    }

    private DialogContext() {
    }

    public HBCIKernelImpl getKernel() {
        return this.kernel;
    }

    public RawHBCIDialog getDialogInit() {
        return this.init;
    }

    void setDialogInit(RawHBCIDialog dialog) {
        this.init = dialog;
    }

    public HBCIMsgStatus getMsgStatus() {
        return this.msgStatus;
    }

    void update(HBCIMsgStatus msgStatus) {
        this.msgStatus = msgStatus;
        this.msgNum.incrementAndGet();
        if (this.msgStatus.isOK()) {
            Properties result = this.msgStatus.getData();
            String string = this.dialogId = result != null ? result.getProperty("MsgHead.dialogid", null) : null;
            if (this.dialogId != null) {
                HBCIUtils.log("new dialog-id: " + this.dialogId, 4);
            }
        }
    }

    public HBCIDialog getDialog() {
        return this.dialog;
    }

    public void setDialog(HBCIDialog dialog) {
        this.dialog = dialog;
    }

    public HBCIPassportInternal getPassport() {
        return this.passport;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public void setAnonymous(boolean anonymous) {
        this.anonymous = anonymous;
    }

    public Map<String, Object> getMeta() {
        return this.meta;
    }

    public String getDialogId() {
        return this.dialogId != null ? this.dialogId : DIALOGID_INITIAL;
    }

    void setDialogId(String dialogId) {
        this.dialogId = dialogId;
    }

    public int getMsgNum() {
        return this.msgNum.get();
    }

    public void setDialogEnd(boolean end) {
        this.dialogEnd.set(end);
    }

    public boolean isDialogEnd() {
        return this.dialogEnd.get();
    }

    public void setRepeat(boolean repeat) {
        this.repeat.set(repeat);
    }

    public boolean isRepeat() {
        return this.repeat.get();
    }
}

