/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.dialog;

import org.kapott.hbci.dialog.AbstractRawHBCIDialog;
import org.kapott.hbci.dialog.DialogContext;
import org.kapott.hbci.dialog.KnownDialogTemplate;
import org.kapott.hbci.exceptions.ProcessException;
import org.kapott.hbci.manager.HBCIKernelImpl;
import org.kapott.hbci.manager.HBCIUtilsInternal;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.status.HBCIMsgStatus;

public class HBCIDialogLockKeys
extends AbstractRawHBCIDialog {
    public HBCIDialogLockKeys() {
        super(KnownDialogTemplate.LOCKKEYS);
    }

    @Override
    protected void applyData(DialogContext ctx) {
        super.applyData(ctx);
        HBCIPassportInternal p = ctx.getPassport();
        HBCIKernelImpl k = ctx.getKernel();
        k.rawSet("KeyLock.KeyName.KIK.country", p.getCountry());
        k.rawSet("KeyLock.KeyName.KIK.blz", p.getBLZ());
        k.rawSet("KeyLock.KeyName.userid", p.getMySigKeyName());
        k.rawSet("KeyLock.KeyName.keynum", p.getMySigKeyNum());
        k.rawSet("KeyLock.KeyName.keyversion", p.getMySigKeyVersion());
        k.rawSet("KeyLock.SecProfile.method", p.getProfileMethod());
        k.rawSet("KeyLock.SecProfile.version", p.getProfileVersion());
        k.rawSet("KeyLock.locktype", "999");
    }

    @Override
    protected HBCIMsgStatus sendData(DialogContext ctx) {
        return ctx.getKernel().rawDoIt(true, true, false);
    }

    @Override
    protected void checkResult(DialogContext ctx) {
        super.checkResult(ctx);
        HBCIMsgStatus ret = ctx.getMsgStatus();
        if (!ret.isOK()) {
            throw new ProcessException(HBCIUtilsInternal.getLocMsg("EXCMSG_LOCKFAILED"), ret);
        }
    }
}

