/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.dialog;

import java.util.Date;
import java.util.Objects;
import java.util.Properties;
import org.kapott.hbci.dialog.AbstractRawHBCIDialog;
import org.kapott.hbci.dialog.DialogContext;
import org.kapott.hbci.dialog.KnownDialogTemplate;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.HBCIUtilsInternal;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.kapott.hbci.tools.StringUtil;

public class HBCIDialogSepaInfo
extends AbstractRawHBCIDialog {
    private static final String GVNAME = "SEPAInfo";

    public HBCIDialogSepaInfo() {
        super(KnownDialogTemplate.SEPAINFO);
    }

    public boolean required(DialogContext ctx) {
        HBCIPassportInternal p = ctx.getPassport();
        Properties upd = p.getUPD();
        if (upd == null) {
            return true;
        }
        return !upd.containsKey("_fetchedSepaInfo");
    }

    public boolean supported(DialogContext ctx) {
        return this.getSegmentVersion(ctx, GVNAME, null) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void checkResult(DialogContext ctx) {
        HBCIPassportInternal p = ctx.getPassport();
        Properties upd = p.getUPD();
        try {
            String header;
            String cansepa;
            super.checkResult(ctx);
            HBCIMsgStatus ret = ctx.getMsgStatus();
            if (!ret.isOK()) {
                return;
            }
            Properties result = ret.getData();
            if (result == null) {
                return;
            }
            if (upd == null) {
                HBCIUtils.log("suspect, got SEPAInfo result but have no UPD", 3);
                return;
            }
            int count = 0;
            block6: for (int i = 0; i < 500 && StringUtil.hasText(cansepa = result.getProperty((header = HBCIUtilsInternal.withCounter("SEPAInfoRes1.Acc", i)) + ".sepa")); ++i) {
                if (cansepa.equals("N")) continue;
                String iban = result.getProperty(header + ".iban");
                String bic = result.getProperty(header + ".bic");
                String country = result.getProperty(header + ".KIK.country");
                String blz = result.getProperty(header + ".KIK.blz");
                String number = result.getProperty(header + ".number");
                if (!StringUtil.hasText(iban)) continue;
                HBCIUtils.log("found BIC/IBAN = " + bic + "/" + iban + " for account " + country + "/" + blz + "/" + number, 4);
                for (int j = 0; j < 500; ++j) {
                    String h = HBCIUtilsInternal.withCounter("KInfo", j);
                    String n = upd.getProperty(h + ".KTV.number");
                    String c = upd.getProperty(h + ".KTV.KIK.country");
                    String b = upd.getProperty(h + ".KTV.KIK.blz");
                    if (!StringUtil.hasText(n)) continue block6;
                    if (!Objects.equals(country, c) || !Objects.equals(blz, b) || !Objects.equals(number, n)) continue;
                    ++count;
                    HBCIUtils.log("updating BIC/IBAN = " + bic + "/" + iban + " for account " + country + "/" + blz + "/" + number, 4);
                    if (StringUtil.hasText(iban)) {
                        upd.setProperty(h + ".KTV.iban", iban);
                        upd.setProperty(h + ".iban", iban);
                    }
                    if (!StringUtil.hasText(bic)) continue block6;
                    upd.setProperty(h + ".KTV.bic", bic);
                    continue block6;
                }
            }
            String name = count == 1 ? "Konto" : "Konten";
            HBCIUtils.log("IBAN/BIC f\u00fcr " + count + " " + name + " empfangen", 3);
        }
        finally {
            if (p != null && upd != null) {
                upd.setProperty("_fetchedSepaInfo", new Date().toString());
                p.saveChanges();
            }
        }
    }
}

