/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.dialog;

import java.util.Date;
import java.util.Objects;
import java.util.Properties;
import org.kapott.hbci.dialog.AbstractRawHBCIDialog;
import org.kapott.hbci.dialog.DialogContext;
import org.kapott.hbci.dialog.KnownDialogTemplate;
import org.kapott.hbci.manager.HBCIKernelImpl;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.HBCIUtilsInternal;
import org.kapott.hbci.passport.AbstractPinTanPassport;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.kapott.hbci.tools.StringUtil;

public class HBCIDialogTanMedia
extends AbstractRawHBCIDialog {
    private static final String GVNAME = "TANMediaList";

    public HBCIDialogTanMedia() {
        super(KnownDialogTemplate.TANMEDIA);
    }

    public boolean required(DialogContext ctx) {
        HBCIPassportInternal p = ctx.getPassport();
        Properties upd = p.getUPD();
        if (upd == null) {
            return true;
        }
        return !upd.containsKey("_fetchedTanMedia");
    }

    public boolean supported(DialogContext ctx) {
        HBCIPassportInternal p;
        HBCIPassportInternal hBCIPassportInternal = p = ctx != null ? ctx.getPassport() : null;
        if (p == null || !(p instanceof AbstractPinTanPassport)) {
            return false;
        }
        return this.getSegmentVersion(ctx, GVNAME, 0) >= 2;
    }

    @Override
    protected void applyData(DialogContext ctx) {
        super.applyData(ctx);
        HBCIKernelImpl k = ctx.getKernel();
        Integer version = this.getSegmentVersion(ctx, GVNAME, 5);
        k.rawSet(GVNAME + version + ".mediatype", "0");
        k.rawSet(GVNAME + version + ".mediacategory", "A");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void checkResult(DialogContext ctx) {
        HBCIPassportInternal p = ctx.getPassport();
        Properties upd = null;
        try {
            String header;
            super.checkResult(ctx);
            HBCIMsgStatus ret = ctx.getMsgStatus();
            if (!ret.isOK()) {
                return;
            }
            Properties result = ret.getData();
            if (result == null) {
                return;
            }
            Integer version = this.getSegmentVersion(ctx, GVNAME, 5);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < 100 && result.getProperty((header = HBCIUtilsInternal.withCounter("TANMediaListRes" + version + ".MediaInfo", i)) + ".mediacategory") != null; ++i) {
                String name;
                String status = result.getProperty(header + ".status");
                if (!Objects.equals(status, "1") || !StringUtil.hasText(name = result.getProperty(header + ".medianame"))) continue;
                if (sb.length() != 0) {
                    sb.append("|");
                }
                sb.append(name);
            }
            String names = sb.toString();
            if (!StringUtil.hasText(names)) {
                return;
            }
            HBCIUtils.log("TAN-Medienbezeichnungen empfangen: " + names, 3);
            upd = p.getUPD();
            if (upd == null) {
                upd = new Properties();
                p.setUPD(upd);
            }
            upd.setProperty("tanmedia.names", names);
        }
        finally {
            if (p != null && upd != null) {
                upd.setProperty("_fetchedTanMedia", new Date().toString());
                p.saveChanges();
            }
        }
    }
}

