/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.dialog;

import java.util.ArrayList;
import java.util.List;
import org.kapott.hbci.GV.HBCIJobImpl;
import org.kapott.hbci.dialog.HBCIMessage;

public class HBCIMessageQueue {
    private List<HBCIMessage> messages = new ArrayList<HBCIMessage>();

    public HBCIMessageQueue() {
        this.append(new HBCIMessage());
    }

    public List<HBCIMessage> getMessages() {
        return new ArrayList<HBCIMessage>(this.messages);
    }

    public HBCIMessage poll() {
        while (this.messages.size() > 0) {
            HBCIMessage m = this.messages.remove(0);
            if (m.getTaskCount() <= 0) continue;
            return m;
        }
        return null;
    }

    public int getTaskCount() {
        int count = 0;
        for (HBCIMessage msg : this.messages) {
            count += msg.getTaskCount();
        }
        return count;
    }

    public HBCIJobImpl findTask(String hbciCode) {
        if (hbciCode == null) {
            return null;
        }
        for (HBCIMessage msg : this.messages) {
            HBCIJobImpl task = msg.findTask(hbciCode);
            if (task == null) continue;
            return task;
        }
        return null;
    }

    public HBCIMessage getLast() {
        return this.messages.get(this.messages.size() - 1);
    }

    public void append(HBCIMessage message) {
        this.messages.add(message);
    }

    public HBCIMessage insertBefore(HBCIMessage message) {
        if (message == null) {
            throw new IllegalArgumentException("no message given");
        }
        int pos = this.messages.indexOf(message);
        if (pos == -1) {
            throw new IllegalArgumentException("message unknown to queue");
        }
        HBCIMessage m = new HBCIMessage();
        this.messages.add(pos, m);
        return m;
    }

    public HBCIMessage insertAfter(HBCIMessage message) {
        if (message == null) {
            throw new IllegalArgumentException("no message given");
        }
        int pos = this.messages.indexOf(message);
        if (pos == -1) {
            throw new IllegalArgumentException("message unknown to queue");
        }
        HBCIMessage m = new HBCIMessage();
        this.messages.add(pos + 1, m);
        return m;
    }
}

