/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.dialog;

import java.util.ArrayList;
import java.util.List;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.kapott.hbci.status.HBCIRetVal;

public enum KnownReturncode {
    W3040("3040"),
    W3072("3072"),
    W3076("3076"),
    W3920("3920"),
    W3956("3956"),
    E9340("9340"),
    E9930("9930"),
    E9931("9931"),
    E9942("9942"),
    E9391("9391");

    public static final KnownReturncode[] LIST_AUTH_FAIL;
    private String code = null;

    private KnownReturncode(String code) {
        this.code = code;
    }

    public boolean is(String code) {
        return code != null && this.code.equals(code);
    }

    public static boolean contains(String code, KnownReturncode ... codes) {
        return KnownReturncode.find(code, codes) != null;
    }

    public static KnownReturncode find(String code, KnownReturncode ... codes) {
        if (code == null || code.length() == 0 || codes == null || codes.length == 0) {
            return null;
        }
        for (KnownReturncode c : codes) {
            if (!c.is(code)) continue;
            return c;
        }
        return null;
    }

    public List<HBCIRetVal> searchReturnValues(HBCIRetVal[] rets) {
        ArrayList<HBCIRetVal> result = new ArrayList<HBCIRetVal>();
        if (rets == null || rets.length == 0) {
            return result;
        }
        for (HBCIRetVal ret : rets) {
            if (!this.is(ret.code)) continue;
            result.add(ret);
        }
        return result;
    }

    public List<HBCIRetVal> searchReturnValues(HBCIMsgStatus status) {
        ArrayList<HBCIRetVal> result = new ArrayList<HBCIRetVal>();
        if (status == null) {
            return result;
        }
        if (status.globStatus != null) {
            result.addAll(this.searchReturnValues(status.globStatus.getRetVals()));
        }
        if (status.segStatus != null) {
            result.addAll(this.searchReturnValues(status.segStatus.getRetVals()));
        }
        return result;
    }

    public HBCIRetVal searchReturnValue(HBCIRetVal[] rets) {
        List<HBCIRetVal> found = this.searchReturnValues(rets);
        return !found.isEmpty() ? found.get(0) : null;
    }

    static {
        LIST_AUTH_FAIL = new KnownReturncode[]{E9340, E9930, E9931, E9942};
    }
}

