/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.manager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class FlickerRenderer {
    public static final int FREQUENCY_DEFAULT = 10;
    public static final int FREQUENCY_MIN = 2;
    public static final int FREQUENCY_MAX = 40;
    private int halfbyteid = 0;
    private int clock = 0;
    private List<int[]> bitarray = null;
    private Thread thread = null;
    private int iterations = 0;
    private int freq = 10;

    public FlickerRenderer(String code) {
        code = "0FFF" + code;
        HashMap<String, int[]> bcdmap = new HashMap<String, int[]>();
        bcdmap.put("0", new int[]{0, 0, 0, 0, 0});
        bcdmap.put("1", new int[]{0, 1, 0, 0, 0});
        bcdmap.put("2", new int[]{0, 0, 1, 0, 0});
        bcdmap.put("3", new int[]{0, 1, 1, 0, 0});
        bcdmap.put("4", new int[]{0, 0, 0, 1, 0});
        bcdmap.put("5", new int[]{0, 1, 0, 1, 0});
        bcdmap.put("6", new int[]{0, 0, 1, 1, 0});
        bcdmap.put("7", new int[]{0, 1, 1, 1, 0});
        bcdmap.put("8", new int[]{0, 0, 0, 0, 1});
        bcdmap.put("9", new int[]{0, 1, 0, 0, 1});
        bcdmap.put("A", new int[]{0, 0, 1, 0, 1});
        bcdmap.put("B", new int[]{0, 1, 1, 0, 1});
        bcdmap.put("C", new int[]{0, 0, 0, 1, 1});
        bcdmap.put("D", new int[]{0, 1, 0, 1, 1});
        bcdmap.put("E", new int[]{0, 0, 1, 1, 1});
        bcdmap.put("F", new int[]{0, 1, 1, 1, 1});
        this.bitarray = new ArrayList<int[]>();
        for (int i = 0; i < code.length(); i += 2) {
            this.bitarray.add((int[])bcdmap.get(Character.toString(code.charAt(i + 1))));
            this.bitarray.add((int[])bcdmap.get(Character.toString(code.charAt(i))));
        }
    }

    public void setFrequency(int hz) {
        if (hz < 2 || hz > 40) {
            return;
        }
        this.freq = hz;
    }

    public final synchronized void start() {
        this.stop();
        this.thread = new Thread("Flicker Update-Thread"){

            @Override
            public void run() {
                FlickerRenderer.this.halfbyteid = 0;
                FlickerRenderer.this.clock = 1;
                try {
                    while (true) {
                        int[] bits = (int[])FlickerRenderer.this.bitarray.get(FlickerRenderer.this.halfbyteid);
                        bits[0] = FlickerRenderer.this.clock;
                        FlickerRenderer.this.paint(bits[0] == 1, bits[1] == 1, bits[2] == 1, bits[3] == 1, bits[4] == 1);
                        FlickerRenderer.this.clock--;
                        if (FlickerRenderer.this.clock < 0) {
                            FlickerRenderer.this.clock = 1;
                            FlickerRenderer.this.halfbyteid++;
                            if (FlickerRenderer.this.halfbyteid >= FlickerRenderer.this.bitarray.size()) {
                                FlickerRenderer.this.halfbyteid = 0;
                                FlickerRenderer.this.iterations++;
                                FlickerRenderer.this.done(FlickerRenderer.this.iterations);
                            }
                        }
                        long sleep = 1000L / (long)FlickerRenderer.this.freq;
                        1.sleep(sleep);
                    }
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        };
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        block7: {
            if (this.thread != null) {
                try {
                    if (this.thread == null) break block7;
                    this.thread.interrupt();
                    Thread thread = this.thread;
                    synchronized (thread) {
                        this.thread.notifyAll();
                    }
                }
                finally {
                    this.thread = null;
                }
            }
        }
    }

    public void paint(boolean b1, boolean b2, boolean b3, boolean b4, boolean b5) {
    }

    public void done(int iterations) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void waitFor() {
        if (this.thread == null) {
            return;
        }
        Thread thread = this.thread;
        synchronized (thread) {
            if (this.thread == null) {
                return;
            }
            try {
                this.thread.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

