/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.manager;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.kapott.hbci.GV.HBCIJobImpl;
import org.kapott.hbci.dialog.DialogContext;
import org.kapott.hbci.dialog.DialogEvent;
import org.kapott.hbci.dialog.HBCIDialogInit;
import org.kapott.hbci.dialog.HBCIMessage;
import org.kapott.hbci.dialog.HBCIMessageQueue;
import org.kapott.hbci.dialog.KnownReturncode;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.HBCIHandler;
import org.kapott.hbci.manager.HBCIInstitute;
import org.kapott.hbci.manager.HBCIKernelImpl;
import org.kapott.hbci.manager.HBCIUser;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.HBCIUtilsInternal;
import org.kapott.hbci.passport.HBCIPassport;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.passport.HBCIPassportList;
import org.kapott.hbci.status.HBCIDialogStatus;
import org.kapott.hbci.status.HBCIInstMessage;
import org.kapott.hbci.status.HBCIMsgStatus;

public final class HBCIDialog {
    private boolean isAnon;
    private String anonSuffix;
    private String dialogid;
    private long msgnum;
    private HBCIMessageQueue queue;
    private Properties listOfGVs = new Properties();
    private HBCIHandler parentHandler;

    public HBCIDialog(HBCIHandler parentHandler) {
        HBCIUtils.log("creating new dialog", 4);
        this.parentHandler = parentHandler;
        this.isAnon = ((HBCIPassportInternal)parentHandler.getPassport()).isAnonymous();
        this.anonSuffix = this.isAnon ? "Anon" : "";
        this.reset();
    }

    public HBCIHandler getParentHandler() {
        return this.parentHandler;
    }

    private HBCIMsgStatus doDialogInit() {
        HBCIMsgStatus ret = null;
        try {
            HBCIPassportInternal mainPassport = (HBCIPassportInternal)this.getParentHandler().getPassport();
            HBCIKernelImpl kernel = (HBCIKernelImpl)this.getParentHandler().getKernel();
            HBCIUtils.log("checking whether passport is supported (but ignoring result)", 4);
            boolean s = mainPassport.isSupported();
            HBCIUtils.log("passport supported: " + s, 4);
            HBCIUtils.log(HBCIUtilsInternal.getLocMsg("STATUS_DIALOG_INIT"), 3);
            HBCIUtilsInternal.getCallback().status((HBCIPassport)mainPassport, 17, null);
            DialogContext ctx = DialogContext.create(kernel, mainPassport);
            ctx.setDialog(this);
            ctx.setAnonymous(this.isAnon);
            HBCIDialogInit init = new HBCIDialogInit();
            ret = init.execute(ctx);
            if (ret.isOK()) {
                Properties result = ret.getData();
                HBCIInstitute inst = new HBCIInstitute(kernel, mainPassport, false);
                inst.updateBPD(result);
                inst.extractKeys(result);
                HBCIUser user = new HBCIUser(kernel, mainPassport, false);
                user.updateUPD(result);
                mainPassport.saveChanges();
                this.msgnum = ctx.getMsgNum();
                this.dialogid = ctx.getDialogId();
                HBCIInstMessage msg = null;
                int i = 0;
                while (true) {
                    try {
                        String header = HBCIUtilsInternal.withCounter("KIMsg", i);
                        msg = new HBCIInstMessage(result, header);
                    }
                    catch (Exception e) {
                        break;
                    }
                    HBCIUtilsInternal.getCallback().callback(mainPassport, 14, msg.toString(), 0, new StringBuffer());
                    ++i;
                }
            }
            HBCIUtilsInternal.getCallback().status((HBCIPassport)mainPassport, 18, new Object[]{ret, this.dialogid});
            if (!KnownReturncode.E9391.searchReturnValues(ret).isEmpty()) {
                try {
                    HBCIUtils.log("found 9391 code in response, performing new sync", 3);
                    HBCIUser user = new HBCIUser(kernel, mainPassport, false);
                    user.fetchSysId();
                }
                catch (Exception e) {
                    HBCIUtils.log("failed: " + e.getMessage(), 3);
                    HBCIUtils.log(e, 4);
                }
            }
        }
        catch (Exception e) {
            if (ret == null) {
                ret = new HBCIMsgStatus();
            }
            ret.addException(e);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private HBCIMsgStatus[] doJobs() {
        HBCIUtils.log(HBCIUtilsInternal.getLocMsg("LOG_PROCESSING_JOBS"), 3);
        HBCIHandler h = this.getParentHandler();
        HBCIKernelImpl k = (HBCIKernelImpl)h.getKernel();
        HBCIPassportInternal p = (HBCIPassportInternal)h.getPassport();
        DialogContext ctx = DialogContext.create(k, p);
        ctx.setDialog(this);
        ctx.setAnonymous(this.isAnon);
        ArrayList<HBCIMsgStatus> allStatuses = new ArrayList<HBCIMsgStatus>();
        int msgCount = 0;
        HBCIMessage msg = null;
        block9: while (true) {
            p.onDialogEvent(DialogEvent.JOBS_CREATED, ctx);
            msg = this.queue.poll();
            if (msg == null) {
                HBCIUtils.log("dialog completed after " + msgCount + " messages", 4);
                break;
            }
            List<HBCIJobImpl> tasks = msg.getTasks();
            if (tasks.size() == 0) {
                HBCIUtils.log("no tasks in message #" + msgCount + ", skipping", 2);
                continue;
            }
            ++msgCount;
            HBCIMsgStatus msgstatus = null;
            try {
                HBCIPassportList msgPassports = new HBCIPassportList();
                HBCIUtils.log("generating msg #" + msgCount, 4);
                k.rawNewMsg("CustomMsg");
                k.rawSet("MsgHead.dialogid", this.dialogid);
                k.rawSet("MsgHead.msgnum", this.getMsgNum());
                k.rawSet("MsgTail.msgnum", this.getMsgNum());
                int taskNum = 0;
                for (HBCIJobImpl hBCIJobImpl : tasks) {
                    String name = hBCIJobImpl.getName();
                    if (hBCIJobImpl.skipped()) {
                        HBCIUtils.log("skipping task " + name, 4);
                        continue;
                    }
                    HBCIUtils.log("adding task " + name, 4);
                    HBCIUtilsInternal.getCallback().status((HBCIPassport)p, 1, hBCIJobImpl);
                    hBCIJobImpl.applyOffset();
                    hBCIJobImpl.setIdx(taskNum);
                    String header = HBCIUtilsInternal.withCounter("GV", taskNum);
                    Properties props = hBCIJobImpl.getLowlevelParams();
                    Enumeration<Object> e = props.keys();
                    while (e.hasMoreElements()) {
                        String key = (String)e.nextElement();
                        k.rawSet(header + "." + key, props.getProperty(key));
                    }
                    msgPassports.addAll(hBCIJobImpl.getSignaturePassports());
                    ++taskNum;
                }
                if (taskNum == 0) {
                    HBCIUtils.log("no tasks in message #" + msgCount + ", skipping", 4);
                    continue;
                }
                msgstatus = k.rawDoIt(msgPassports, true, true, true);
                this.nextMsgNum();
                int segnum = this.findTaskSegment(msgstatus);
                if (segnum != 0) {
                    for (HBCIJobImpl task2 : tasks) {
                        String name = task2.getName();
                        if (task2.skipped()) {
                            HBCIUtils.log("skipping results for task " + name, 4);
                            continue;
                        }
                        try {
                            HBCIUtils.log("filling results for task " + name, 4);
                            task2.fillJobResult(msgstatus, segnum);
                            HBCIUtilsInternal.getCallback().status((HBCIPassport)p, 2, task2);
                        }
                        catch (Exception e) {
                            msgstatus.addException(e);
                        }
                    }
                }
                if (msgstatus.hasExceptions()) {
                    HBCIUtils.log("aborting current loop because of errors", 1);
                    break;
                }
                Object var13_18 = null;
                Iterator<HBCIJobImpl> iterator = tasks.iterator();
                while (true) {
                    void var13_19;
                    if (!iterator.hasNext()) continue block9;
                    HBCIJobImpl task = iterator.next();
                    String name = task.getName();
                    if (task.skipped()) {
                        HBCIUtils.log("skipping repeat for task " + name, 4);
                        continue;
                    }
                    HBCIJobImpl redo = task.redo();
                    if (redo == null) continue;
                    if (var13_19 == null) {
                        HBCIMessage hBCIMessage = new HBCIMessage();
                        this.queue.append(hBCIMessage);
                    }
                    HBCIUtils.log("repeat task " + redo.getName(), 4);
                    var13_19.append(redo);
                }
            }
            catch (Exception e) {
                HBCIUtils.log(e);
                if (msgstatus == null) continue;
                msgstatus.addException(e);
                continue;
            }
            finally {
                if (msgstatus == null) continue;
                allStatuses.add(msgstatus);
                continue;
            }
            break;
        }
        return allStatuses.size() > 0 ? allStatuses.toArray(new HBCIMsgStatus[allStatuses.size()]) : new HBCIMsgStatus[]{};
    }

    private int findTaskSegment(HBCIMsgStatus msgstatus) {
        Properties result = msgstatus.getData();
        for (int segnum = 1; segnum < 1000; ++segnum) {
            String path = result.getProperty(Integer.toString(segnum));
            if (path == null) {
                return -1;
            }
            if (!path.startsWith("CustomMsg.GV")) continue;
            return segnum;
        }
        return -1;
    }

    @Deprecated
    private HBCIMsgStatus doDialogEnd() {
        HBCIMsgStatus ret = new HBCIMsgStatus();
        HBCIHandler handler = this.getParentHandler();
        HBCIPassportInternal mainPassport = (HBCIPassportInternal)handler.getPassport();
        HBCIKernelImpl kernel = (HBCIKernelImpl)handler.getKernel();
        try {
            HBCIUtils.log(HBCIUtilsInternal.getLocMsg("LOG_DIALOG_END"), 3);
            HBCIUtilsInternal.getCallback().status((HBCIPassport)mainPassport, 19, null);
            kernel.rawNewMsg("DialogEnd" + this.anonSuffix);
            kernel.rawSet("DialogEndS.dialogid", this.dialogid);
            kernel.rawSet("MsgHead.dialogid", this.dialogid);
            kernel.rawSet("MsgHead.msgnum", this.getMsgNum());
            kernel.rawSet("MsgTail.msgnum", this.getMsgNum());
            this.nextMsgNum();
            ret = kernel.rawDoIt(!this.isAnon, !this.isAnon, !this.isAnon);
            HBCIUtilsInternal.getCallback().status((HBCIPassport)mainPassport, 20, ret);
        }
        catch (Exception e) {
            ret.addException(e);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HBCIDialogStatus doIt() {
        try {
            HBCIUtils.log("executing dialog", 4);
            HBCIDialogStatus ret = new HBCIDialogStatus();
            HBCIMsgStatus initStatus = this.doDialogInit();
            ret.setInitStatus(initStatus);
            if (initStatus.isOK()) {
                ret.setMsgStatus(this.doJobs());
                ret.setEndStatus(this.doDialogEnd());
            }
            HBCIDialogStatus hBCIDialogStatus = ret;
            return hBCIDialogStatus;
        }
        finally {
            this.reset();
        }
    }

    private void reset() {
        try {
            this.dialogid = null;
            this.msgnum = 1L;
            this.queue = new HBCIMessageQueue();
            this.listOfGVs.clear();
        }
        catch (Exception e) {
            HBCIUtils.log(e);
        }
    }

    public String getDialogID() {
        return this.dialogid;
    }

    public String getMsgNum() {
        return Long.toString(this.msgnum);
    }

    public void nextMsgNum() {
        ++this.msgnum;
    }

    private int getTotalNumberOfGVSegsInCurrentMessage() {
        int total = 0;
        Enumeration<Object> e = this.listOfGVs.keys();
        while (e.hasMoreElements()) {
            String hbciCode = (String)e.nextElement();
            int counter = Integer.parseInt(this.listOfGVs.getProperty(hbciCode));
            total += counter;
        }
        HBCIUtils.log("there are currently " + total + " GV segs in this message", 4);
        return total;
    }

    public void addTask(HBCIJobImpl job) {
        try {
            HBCIUtils.log(HBCIUtilsInternal.getLocMsg("EXCMSG_ADDJOB", job.getName()), 4);
            job.verifyConstraints();
            String hbciCode = job.getHBCICode();
            int gva_counter = this.listOfGVs.size();
            String counter_st = this.listOfGVs.getProperty(hbciCode);
            int gv_counter = counter_st != null ? Integer.parseInt(counter_st) : 0;
            int total_counter = this.getTotalNumberOfGVSegsInCurrentMessage();
            ++gv_counter;
            ++total_counter;
            if (counter_st == null) {
                ++gva_counter;
            }
            HBCIPassportInternal passport = (HBCIPassportInternal)this.getParentHandler().getPassport();
            int maxGVA = passport.getMaxGVperMsg();
            int maxGVSegJob = job.getMaxNumberPerMsg();
            int maxGVSegTotal = passport.getMaxGVSegsPerMsg();
            if (maxGVA > 0 && gva_counter > maxGVA || maxGVSegJob > 0 && gv_counter > maxGVSegJob || maxGVSegTotal > 0 && total_counter > maxGVSegTotal) {
                if (maxGVSegTotal > 0 && total_counter > maxGVSegTotal) {
                    HBCIUtils.log("have to generate new message because current type of passport only allows " + maxGVSegTotal + " GV segs per message", 4);
                } else {
                    HBCIUtils.log("have to generate new message because of BPD restrictions for number of tasks per message; adding job to this new message", 4);
                }
                this.newMsg();
                gv_counter = 1;
                total_counter = 1;
            }
            this.listOfGVs.setProperty(hbciCode, Integer.toString(gv_counter));
            this.queue.getLast().append(job);
        }
        catch (Exception e) {
            String msg = HBCIUtilsInternal.getLocMsg("EXCMSG_CANTADDJOB", job.getName());
            if (!HBCIUtilsInternal.ignoreError(null, "client.errors.ignoreAddJobErrors", msg + ": " + HBCIUtils.exception2String(e))) {
                throw new HBCI_Exception(msg, e);
            }
            HBCIUtils.log("task " + job.getName() + " will not be executed in current dialog", 1);
        }
    }

    public HBCIMessageQueue getMessageQueue() {
        return this.queue;
    }

    public void newMsg() {
        HBCIUtils.log("starting new message", 4);
        this.queue.append(new HBCIMessage());
        this.listOfGVs.clear();
    }
}

