/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.manager;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.Security;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.ResourceBundle;
import org.kapott.cryptalgs.CryptAlgs4JavaProvider;
import org.kapott.hbci.GV_Result.GVRKUms;
import org.kapott.hbci.callback.HBCICallback;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.exceptions.InvalidArgumentException;
import org.kapott.hbci.exceptions.InvalidUserDataException;
import org.kapott.hbci.manager.AccountCRCAlgs;
import org.kapott.hbci.manager.BankInfo;
import org.kapott.hbci.manager.HBCIUtilsInternal;
import org.kapott.hbci.manager.LogFilter;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.swift.Swift;

public final class HBCIUtils {
    public static final String PRODUCT_ID = "36792786FA12F235F04647689";
    private static final String VERSION = HBCIUtils.class.getPackage().getImplementationVersion();
    public static final int LOG_NONE = 0;
    public static final int LOG_ERR = 1;
    public static final int LOG_WARN = 2;
    public static final int LOG_INFO = 3;
    public static final int LOG_DEBUG = 4;
    public static final int LOG_DEBUG2 = 5;
    public static final int LOG_INTERN = 6;
    private static Hashtable<ThreadGroup, Properties> configs;
    private static char[] base64table;

    private static void initDataStructures() {
        configs = new Hashtable();
        HBCIUtilsInternal.callbacks = new Hashtable();
        HBCIUtilsInternal.blzs = new Properties();
        HBCIUtilsInternal.banks = new HashMap<String, BankInfo>();
        HBCIUtilsInternal.locMsgs = new Hashtable();
        HBCIUtilsInternal.locales = new Hashtable();
    }

    private HBCIUtils() {
    }

    public static Properties loadPropertiesFile(ClassLoader cl, String configfile) {
        Properties props = null;
        if (configfile != null) {
            try {
                block8: {
                    if (cl == null) {
                        try {
                            throw new Exception();
                        }
                        catch (Exception e) {
                            StackTraceElement[] stackTrace = e.getStackTrace();
                            if (stackTrace.length > 1) {
                                String classname = stackTrace[1].getClassName();
                                cl = Class.forName(classname).getClassLoader();
                            }
                            if (cl != null) break block8;
                            cl = ClassLoader.getSystemClassLoader();
                        }
                    }
                }
                InputStream f = null;
                f = cl.getResourceAsStream(configfile);
                if (f == null) {
                    throw new InvalidUserDataException("*** can not load config file " + configfile);
                }
                props = new Properties();
                props.load(f);
                f.close();
            }
            catch (Exception e) {
                throw new HBCI_Exception("*** can not load config file " + configfile, e);
            }
        }
        return props;
    }

    public static synchronized void init(Properties props, HBCICallback callback) {
        try {
            HBCIUtils.initThread(props, callback);
            HBCIUtils.log("hbci4java " + HBCIUtils.version(), 3);
            if (Objects.equals(HBCIUtils.getParam("client.product.name", PRODUCT_ID), PRODUCT_ID)) {
                HBCIUtils.log("*************************************************************************", 2);
                HBCIUtils.log("** WARNING                                                             **", 2);
                HBCIUtils.log("**                                                                     **", 2);
                HBCIUtils.log("** HBCI4Java is currently using a product registration that should     **", 2);
                HBCIUtils.log("** ONLY be used for internal testing, not for production purpose!!     **", 2);
                HBCIUtils.log("**                                                                     **", 2);
                HBCIUtils.log("** Please go to https://www.hbci-zka.de/register/prod_register.htm     **", 2);
                HBCIUtils.log("** and create your own registration (it's free)                        **", 2);
                HBCIUtils.log("**                                                                     **", 2);
                HBCIUtils.log("** After receiving your registration, add this line to your code:      **", 2);
                HBCIUtils.log("** HBCIUtils.setParam(\"client.product.name\",\"<your registration>\");    **", 2);
                HBCIUtils.log("**                                                                     **", 2);
                HBCIUtils.log("** This test registration can be invalidated at any time!!             **", 2);
                HBCIUtils.log("**                                                                     **", 2);
                HBCIUtils.log("*************************************************************************", 2);
            }
            HBCIUtils.refreshBLZList(HBCIUtils.class.getClassLoader());
            if (Security.getProvider("CryptAlgs4Java") == null) {
                Security.addProvider(new CryptAlgs4JavaProvider());
            }
        }
        catch (Exception e) {
            throw new HBCI_Exception("*** error while initializing HBCI4Java", e);
        }
    }

    @Deprecated
    public static synchronized void init(ClassLoader cl, String configfile, HBCICallback callback) {
        HBCIUtils.init(HBCIUtils.loadPropertiesFile(cl, configfile), callback);
    }

    @Deprecated
    public static synchronized void initThread(ClassLoader cl, String configfile) {
        HBCIUtils.initThread(cl, configfile, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void initThread(Properties props, HBCICallback callback) {
        ThreadGroup threadgroup = Thread.currentThread().getThreadGroup();
        if (HBCIUtilsInternal.callbacks.get(threadgroup) != null) {
            HBCIUtils.log("will not initialize this threadgroup because it is already initialized", 2);
        } else {
            try {
                ThreadGroup parent;
                Properties config = new Properties();
                if (props != null) {
                    config.putAll((Map<?, ?>)props);
                }
                Hashtable<ThreadGroup, Properties> hashtable = configs;
                synchronized (hashtable) {
                    configs.put(threadgroup, config);
                }
                if (HBCIUtils.getParam("kernel.rewriter") == null) {
                    HBCIUtils.setParam("kernel.rewriter", "InvalidSegment,WrongStatusSegOrder,WrongSequenceNumbers,MissingMsgRef,HBCIVersion,SigIdLeadingZero,InvalidSuppHBCIVersion,SecTypeTAN,KUmsDelimiters,KUmsEmptyBDateSets");
                }
                if (callback == null && (callback = HBCIUtilsInternal.callbacks.get(parent = Thread.currentThread().getThreadGroup().getParent())) == null) {
                    throw new NullPointerException("no callback specified");
                }
                HBCIUtilsInternal.callbacks.put(threadgroup, callback);
                HBCIUtils.initLocale();
                HBCIUtils.log("initialized HBCI4Java for thread group " + threadgroup.getName(), 4);
            }
            catch (Exception ex) {
                throw new HBCI_Exception("*** could not init HBCI4Java for thread group " + threadgroup.getName(), ex);
            }
        }
    }

    @Deprecated
    public static synchronized void initThread(ClassLoader cl, String configfile, HBCICallback callback) {
        HBCIUtils.initThread(HBCIUtils.loadPropertiesFile(cl, configfile), callback);
    }

    public static synchronized void doneThread() {
        HBCIUtils.log("removing all data for current thread", 4);
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        HBCIUtilsInternal.callbacks.remove(group);
        configs.remove(group);
        HBCIUtilsInternal.locMsgs.remove(group);
        HBCIUtilsInternal.locales.remove(group);
    }

    public static synchronized void done() {
        HBCIUtils.log("destroying all HBCI4Java resources", 4);
        HBCIUtils.initDataStructures();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initLocale() {
        Locale locale;
        String localeLang = HBCIUtils.getParam("kernel.locale.language", "");
        String localeCountry = HBCIUtils.getParam("kernel.locale.country", "");
        String localeVariant = HBCIUtils.getParam("kernel.locale.variant", "");
        if (localeLang.trim().length() == 0) {
            locale = Locale.getDefault();
            HBCIUtils.log("using default system locale " + locale.toString(), 4);
        } else {
            locale = new Locale(localeLang.trim(), localeCountry.trim(), localeVariant.trim());
            HBCIUtils.log("using specified locale " + locale.toString(), 4);
        }
        ThreadGroup threadgroup = Thread.currentThread().getThreadGroup();
        Hashtable<ThreadGroup, Object> hashtable = HBCIUtilsInternal.locales;
        synchronized (hashtable) {
            HBCIUtilsInternal.locales.put(threadgroup, locale);
        }
        hashtable = HBCIUtilsInternal.locMsgs;
        synchronized (hashtable) {
            HBCIUtilsInternal.locMsgs.put(threadgroup, ResourceBundle.getBundle("hbci4java-messages", locale));
        }
    }

    public static Locale getLocale() {
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        return HBCIUtilsInternal.locales.get(group);
    }

    public static String getParam(String st, String def) {
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        Properties config = HBCIUtils.getParams();
        if (config == null) {
            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_THREAD_NOTINIT", group.getName()));
        }
        return config.getProperty(st, def);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getParams() {
        Properties params;
        ThreadGroup threadgroup = Thread.currentThread().getThreadGroup();
        Hashtable<ThreadGroup, Properties> hashtable = configs;
        synchronized (hashtable) {
            params = configs.get(threadgroup);
        }
        return params;
    }

    public static String getParam(String st) {
        return HBCIUtils.getParam(st, null);
    }

    public static String getNameForBLZ(String blz) {
        BankInfo info = HBCIUtils.getBankInfo(blz);
        if (info == null) {
            return "";
        }
        return info.getName() != null ? info.getName() : "";
    }

    public static BankInfo getBankInfo(String blz) {
        return HBCIUtilsInternal.banks.get(blz);
    }

    public static List<BankInfo> searchBankInfo(String query) {
        if (query != null) {
            query = query.trim();
        }
        LinkedList<BankInfo> list = new LinkedList<BankInfo>();
        if (query == null || query.length() < 3) {
            return list;
        }
        query = query.toLowerCase();
        for (BankInfo info : HBCIUtilsInternal.banks.values()) {
            String blz = info.getBlz();
            String bic = info.getBic();
            String name = info.getName();
            String loc = info.getLocation();
            if (blz != null && blz.startsWith(query)) {
                list.add(info);
                continue;
            }
            if (bic != null && bic.toLowerCase().startsWith(query)) {
                list.add(info);
                continue;
            }
            if (name != null && name.toLowerCase().contains(query)) {
                list.add(info);
                continue;
            }
            if (loc == null || !loc.toLowerCase().contains(query)) continue;
            list.add(info);
        }
        Collections.sort(list, new Comparator<BankInfo>(){

            @Override
            public int compare(BankInfo o1, BankInfo o2) {
                if (o1 == null || o1.getBlz() == null) {
                    return -1;
                }
                if (o2 == null || o2.getBlz() == null) {
                    return 1;
                }
                return o1.getBlz().compareTo(o2.getBlz());
            }
        });
        return list;
    }

    @Deprecated
    public static String getBICForBLZ(String blz) {
        BankInfo info = HBCIUtils.getBankInfo(blz);
        if (info == null) {
            return "";
        }
        return info.getBic() != null ? info.getBic() : "";
    }

    public static String getIBANForKonto(Konto k) {
        String konto = k.number;
        if (k.subnumber != null && k.subnumber.length() > 0 && k.subnumber.matches("[0-9]{1,8}") && k.number.length() + k.subnumber.length() <= 10) {
            konto = konto + k.subnumber;
        }
        String zeros = "0000000000";
        String filledKonto = zeros.substring(0, 10 - konto.length()) + konto;
        StringBuffer sb = new StringBuffer();
        sb.append(k.blz);
        sb.append(filledKonto);
        sb.append("1314");
        sb.append("00");
        BigInteger mod = new BigInteger(sb.toString()).mod(new BigInteger("97"));
        String checksum = String.valueOf(98 - mod.intValue());
        if (checksum.length() < 2) {
            checksum = "0" + checksum;
        }
        StringBuffer result = new StringBuffer();
        result.append("DE");
        result.append(checksum);
        result.append(k.blz);
        result.append(filledKonto);
        return result.toString();
    }

    @Deprecated
    public static String getHBCIHostForBLZ(String blz) {
        BankInfo info = HBCIUtils.getBankInfo(blz);
        if (info == null) {
            return "";
        }
        return info.getRdhAddress() != null ? info.getRdhAddress() : "";
    }

    @Deprecated
    public static String getPinTanURLForBLZ(String blz) {
        BankInfo info = HBCIUtils.getBankInfo(blz);
        if (info == null) {
            return "";
        }
        return info.getPinTanAddress() != null ? info.getPinTanAddress() : "";
    }

    @Deprecated
    public static String getHBCIVersionForBLZ(String blz) {
        BankInfo info = HBCIUtils.getBankInfo(blz);
        if (info == null) {
            return "";
        }
        return info.getRdhVersion() != null ? info.getRdhVersion().getId() : "";
    }

    @Deprecated
    public static String getPinTanVersionForBLZ(String blz) {
        BankInfo info = HBCIUtils.getBankInfo(blz);
        if (info == null) {
            return "";
        }
        return info.getPinTanVersion() != null ? info.getPinTanVersion().getId() : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setParam(String key, String value) {
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        Properties config = HBCIUtils.getParams();
        if (config == null) {
            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_THREAD_NOTINIT", group.getName()));
        }
        Properties properties = config;
        synchronized (properties) {
            if (value != null) {
                config.setProperty(key, value);
            } else {
                config.remove(key);
            }
        }
    }

    public static synchronized void log(String st, int level) {
        if (level <= Integer.parseInt(HBCIUtils.getParam("log.loglevel.default", "2"))) {
            StackTraceElement trace = null;
            try {
                throw new Exception("");
            }
            catch (Exception e) {
                trace = e.getStackTrace()[1];
                int filterLevel = Integer.parseInt(HBCIUtils.getParam("log.filter", "2"));
                if (filterLevel != 0) {
                    st = LogFilter.getInstance().filterLine(st, filterLevel);
                }
                HBCIUtilsInternal.getCallback().log(st, level, new Date(), trace);
            }
        }
    }

    public static synchronized void log(Exception ... exceptions) {
        if (exceptions == null) {
            return;
        }
        for (Exception e : exceptions) {
            HBCIUtils.log(e, 1);
        }
    }

    public static String exception2String(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString().trim();
    }

    public static String exception2StringShort(Exception e) {
        StringBuffer st = new StringBuffer();
        for (Throwable e2 = e; e2 != null; e2 = e2.getCause()) {
            String exClass = e2.getClass().getName();
            String msg = e2.getMessage();
            if (msg == null) continue;
            st.setLength(0);
            st.append(exClass);
            st.append(": ");
            st.append(msg);
        }
        return st.toString().trim();
    }

    public static synchronized void log(Exception e, int level) {
        HBCIUtils.log(HBCIUtils.exception2String(e), level);
    }

    public static String data2hex(byte[] data) {
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            String st = Integer.toHexString(data[i]);
            if (st.length() == 1) {
                st = '0' + st;
            }
            st = st.substring(st.length() - 2);
            ret.append(st).append(" ");
        }
        return ret.toString();
    }

    public static String date2StringLocal(Date date) {
        String ret;
        try {
            ret = DateFormat.getDateInstance(3, HBCIUtils.getLocale()).format(date);
        }
        catch (Exception e) {
            throw new InvalidArgumentException(date.toString());
        }
        return ret;
    }

    public static Date string2DateLocal(String date) {
        Date ret;
        try {
            ret = DateFormat.getDateInstance(3, HBCIUtils.getLocale()).parse(date);
        }
        catch (Exception e) {
            throw new InvalidArgumentException(date);
        }
        return ret;
    }

    public static String time2StringLocal(Date date) {
        String ret;
        try {
            ret = DateFormat.getTimeInstance(3, HBCIUtils.getLocale()).format(date);
        }
        catch (Exception e) {
            throw new InvalidArgumentException(date.toString());
        }
        return ret;
    }

    public static Date string2TimeLocal(String date) {
        Date ret;
        try {
            ret = DateFormat.getTimeInstance(3, HBCIUtils.getLocale()).parse(date);
        }
        catch (Exception e) {
            throw new InvalidArgumentException(date);
        }
        return ret;
    }

    public static String datetime2StringLocal(Date date) {
        String ret;
        try {
            ret = DateFormat.getDateTimeInstance(3, 3, HBCIUtils.getLocale()).format(date);
        }
        catch (Exception e) {
            throw new InvalidArgumentException(date.toString());
        }
        return ret;
    }

    public static Date strings2DateTimeLocal(String date, String time) {
        Date ret;
        try {
            ret = time != null ? DateFormat.getDateTimeInstance(3, 3, HBCIUtils.getLocale()).parse(date + " " + time) : DateFormat.getDateInstance(3, HBCIUtils.getLocale()).parse(date);
        }
        catch (Exception e) {
            throw new InvalidArgumentException(date + " / " + time);
        }
        return ret;
    }

    public static String date2StringISO(Date date) {
        return new SimpleDateFormat("yyyy-MM-dd").format(date);
    }

    public static Date string2DateISO(String st) {
        try {
            return new SimpleDateFormat("yyyy-MM-dd").parse(st);
        }
        catch (ParseException e) {
            throw new InvalidArgumentException(st);
        }
    }

    public static String time2StringISO(Date date) {
        return new SimpleDateFormat("HH:mm:ss").format(date);
    }

    public static Date string2TimeISO(String st) {
        try {
            return new SimpleDateFormat("HH:mm:ss").parse(st);
        }
        catch (ParseException e) {
            throw new InvalidArgumentException(st);
        }
    }

    public static String datetime2StringISO(Date date) {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date);
    }

    public static Date strings2DateTimeISO(String date, String time) {
        Date result;
        if (date == null) {
            throw new InvalidArgumentException("*** date must not be null");
        }
        try {
            result = time != null ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(date + " " + time) : new SimpleDateFormat("yyyy-MM-dd").parse(date);
        }
        catch (ParseException e) {
            throw new InvalidArgumentException(date + " / " + time);
        }
        return result;
    }

    private static void errDeprecated(String method) {
        HBCIUtils.log("programming error: the method " + method + "() has been deprecated, is very dangerous and will be removed soon.", 1);
        HBCIUtils.log("programming error: please check your application to replace calls to " + method + "() with calls to either " + method + "Local() or " + method + "ISO()", 1);
    }

    @Deprecated
    public static String date2String(Date date) {
        HBCIUtils.errDeprecated("date2String");
        return HBCIUtils.date2StringLocal(date);
    }

    @Deprecated
    public static Date string2Date(String st) {
        HBCIUtils.errDeprecated("string2Date");
        return HBCIUtils.string2DateLocal(st);
    }

    @Deprecated
    public static String time2String(Date date) {
        HBCIUtils.errDeprecated("time2String");
        return HBCIUtils.time2StringLocal(date);
    }

    @Deprecated
    public static Date string2Time(String st) {
        HBCIUtils.errDeprecated("string2Time");
        return HBCIUtils.string2TimeLocal(st);
    }

    @Deprecated
    public static String datetime2String(Date date) {
        HBCIUtils.errDeprecated("datetime2String");
        return HBCIUtils.datetime2StringLocal(date);
    }

    @Deprecated
    public static Date strings2DateTime(String date, String time) {
        HBCIUtils.errDeprecated("strings2DateTime");
        return HBCIUtils.strings2DateTimeLocal(date, time);
    }

    public static String encodeBase64(byte[] x) {
        try {
            int origSize = x.length;
            if (origSize % 3 != 0) {
                byte[] temp = new byte[(origSize / 3 + 1) * 3];
                System.arraycopy(x, 0, temp, 0, origSize);
                x = temp;
            }
            StringBuffer ret = new StringBuffer();
            for (int readPos = 0; readPos < x.length << 3; readPos += 6) {
                int modulus = readPos & 7;
                if (readPos >> 3 < origSize) {
                    int value = modulus <= 2 ? x[readPos >> 3] >> 2 - modulus & 0x3F : x[readPos >> 3] << modulus - 2 & 0x3F | x[(readPos >> 3) + 1] >> 10 - modulus & (1 << modulus - 2) - 1;
                    ret.append(base64table[value]);
                    continue;
                }
                ret.append('=');
            }
            return ret.toString();
        }
        catch (Exception ex) {
            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_UTIL_ENCB64"), ex);
        }
    }

    public static byte[] decodeBase64(String st) {
        try {
            byte[] source = st.getBytes("ISO-8859-1");
            byte[] ret = new byte[st.length()];
            int retlen = 0;
            int needFromFirst = 6;
            int needFromSecond = 2;
            boolean abort = false;
            int byteCounter = 0;
            int[] values = new int[2];
            for (int readPos = 0; readPos < source.length; ++readPos) {
                values[0] = 0;
                values[1] = 0;
                for (int step = 0; step < 2; ++step) {
                    int value = 0;
                    while (!(readPos + step >= source.length || (value = source[readPos + step]) >= 48 && value <= 57 || value >= 65 && value <= 90 || value >= 97 && value <= 122 || value == 43 || value == 47 || value == 61)) {
                        ++readPos;
                    }
                    if (!(value >= 48 && value <= 57 || value >= 65 && value <= 90 || value >= 97 && value <= 122 || value == 43 || value == 47)) {
                        abort = true;
                        break;
                    }
                    value = (char)value == '/' ? 63 : ((char)value == '+' ? 62 : ((char)value <= '9' ? 52 + value - 48 : ((char)value <= 'Z' ? (value -= 65) : 26 + value - 97)));
                    if (step == 0) {
                        values[0] = value << 8 - needFromFirst & 0xFF;
                        continue;
                    }
                    values[1] = value >> 6 - needFromSecond & 0xFF;
                }
                if (abort) break;
                ret[retlen++] = (byte)(values[0] | values[1]);
                if ((byteCounter & 3) == 2) {
                    ++readPos;
                    ++byteCounter;
                    needFromFirst = 6;
                    needFromSecond = 2;
                } else {
                    needFromFirst = 6 - needFromSecond;
                    needFromSecond = 8 - needFromFirst;
                }
                ++byteCounter;
            }
            byte[] ret2 = new byte[retlen];
            System.arraycopy(ret, 0, ret2, 0, retlen);
            return ret2;
        }
        catch (Exception ex) {
            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_UTIL_DECB64"), ex);
        }
    }

    private static Method getAccountCRCMethodByAlg(String alg) {
        Class<AccountCRCAlgs> cl = null;
        Method method = null;
        try {
            cl = AccountCRCAlgs.class;
            method = cl.getMethod("alg_" + alg, int[].class, int[].class);
        }
        catch (Exception e) {
            HBCIUtils.log("CRC algorithm " + alg + " not yet implemented", 2);
        }
        return method;
    }

    public static boolean canCheckAccountCRC(String blz) {
        BankInfo info = HBCIUtils.getBankInfo(blz);
        if (info == null) {
            return false;
        }
        String alg = info.getChecksumMethod();
        if (alg == null || alg.length() != 2) {
            return false;
        }
        Method method = HBCIUtils.getAccountCRCMethodByAlg(alg);
        return method != null;
    }

    public static boolean checkAccountCRC(String blz, String number) {
        String alg;
        BankInfo info = HBCIUtils.getBankInfo(blz);
        String string = alg = info != null ? info.getChecksumMethod() : null;
        if (alg == null || alg.length() != 2) {
            HBCIUtils.log("no crc information about " + blz + " in database", 4);
            return true;
        }
        HBCIUtils.log("crc-checking " + blz + "/" + number, 4);
        return HBCIUtils.checkAccountCRCByAlg(alg, blz, number);
    }

    private static int[] string2Ints(String st, int target_length) {
        int[] numbers = new int[target_length];
        int st_len = st.length();
        for (int i = 0; i < st_len; ++i) {
            char ch = st.charAt(i);
            numbers[target_length - st_len + i] = ch - 48;
        }
        return numbers;
    }

    public static boolean checkAccountCRCByAlg(String alg, String blz, String number) {
        boolean ret = true;
        if (blz == null || number == null) {
            throw new NullPointerException("blz and number must not be null");
        }
        if (number.length() <= 10) {
            Method method = HBCIUtils.getAccountCRCMethodByAlg(alg);
            if (method != null) {
                try {
                    int[] blz_digits = HBCIUtils.string2Ints(blz, 8);
                    int[] number_digits = HBCIUtils.string2Ints(number, 10);
                    Object[] args = new Object[]{blz_digits, number_digits};
                    ret = (Boolean)method.invoke(null, args);
                    HBCIUtils.log("CRC check for " + blz + "/" + number + " with alg " + alg + ": " + ret, 4);
                }
                catch (Exception e) {
                    throw new HBCI_Exception(e);
                }
            }
        } else {
            HBCIUtils.log("can not check account numbers with more than 10 digits (" + number + ")- skipping CRC check", 2);
        }
        return ret;
    }

    @Deprecated
    public static boolean checkAccountCRCByAlg(String alg, String number) {
        return HBCIUtils.checkAccountCRCByAlg(alg, "", number);
    }

    public static boolean checkIBANCRC(String iban) {
        return AccountCRCAlgs.checkIBAN(iban);
    }

    public static boolean checkCredtitorIdCRC(String creditorId) {
        return AccountCRCAlgs.checkCreditorId(creditorId);
    }

    private static void refreshBLZList(ClassLoader cl) throws IOException {
        InputStream f;
        String blzpath = HBCIUtils.getParam("kernel.kernel.blzpath");
        if (blzpath == null) {
            blzpath = "";
        }
        if ((f = cl.getResourceAsStream(blzpath = blzpath + "blz.properties")) == null) {
            throw new InvalidUserDataException(HBCIUtilsInternal.getLocMsg("EXCMSG_BLZLOAD", blzpath));
        }
        HBCIUtils.refreshBLZList(f);
        f.close();
    }

    public static synchronized void refreshBLZList(InputStream in) throws IOException {
        HBCIUtils.log("trying to load BLZ data", 4);
        InputStreamReader isr = new InputStreamReader(in, "UTF-8");
        HBCIUtilsInternal.blzs.clear();
        HBCIUtilsInternal.blzs.load(isr);
        HBCIUtilsInternal.banks.clear();
        for (Map.Entry<Object, Object> e : HBCIUtilsInternal.blzs.entrySet()) {
            String blz = (String)e.getKey();
            String value = (String)e.getValue();
            BankInfo info = BankInfo.parse(value);
            info.setBlz(blz);
            HBCIUtilsInternal.banks.put(blz, info);
        }
    }

    public static BigDecimal string2BigDecimal(String st) {
        BigDecimal result = new BigDecimal(st);
        result.setScale(2, 6);
        return result;
    }

    public static String bigDecimal2String(BigDecimal value) {
        DecimalFormat format = new DecimalFormat("0.00");
        DecimalFormatSymbols symbols = format.getDecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        format.setDecimalFormatSymbols(symbols);
        format.setDecimalSeparatorAlwaysShown(true);
        return format.format(value);
    }

    @Deprecated
    public static double string2Value(String st) {
        return Double.parseDouble(st);
    }

    @Deprecated
    public static String value2String(double value) {
        DecimalFormat format = new DecimalFormat("0.00");
        DecimalFormatSymbols symbols = format.getDecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        format.setDecimalFormatSymbols(symbols);
        format.setDecimalSeparatorAlwaysShown(true);
        return format.format(value);
    }

    public static String version() {
        return VERSION != null ? VERSION : "DEV";
    }

    public static GVRKUms parseMT940(String mt940) {
        GVRKUms result = new GVRKUms();
        result.appendMT940Data(Swift.decodeUmlauts(mt940));
        return result;
    }

    static {
        base64table = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        HBCIUtils.initDataStructures();
    }
}

