/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.manager;

import java.util.Hashtable;
import org.kapott.hbci.manager.HBCIUtils;

public class ThreadSyncer {
    private String name;
    private boolean waiting;
    private boolean notified;
    private boolean timeouted;
    private Hashtable<String, Object> data;

    public ThreadSyncer(String name) {
        this.name = name;
        this.waiting = false;
        this.notified = false;
        this.timeouted = false;
        this.data = new Hashtable();
    }

    public synchronized void startWaiting(long seconds, String errMsg) {
        try {
            if (!this.notified) {
                HBCIUtils.log(this.name + ".startWaiting: !notified, waiting now", 4);
                this.waiting = true;
                this.wait(seconds * 1000L);
                this.waiting = false;
                if (!this.notified) {
                    HBCIUtils.log(this.name + ".startWaiting: end of wait: !notified (timeouted)", 4);
                    this.timeouted = true;
                    throw new RuntimeException(this.name + ": " + errMsg);
                }
                HBCIUtils.log(this.name + ".startWaiting: end of wait: notified, normal end of wait", 4);
                this.notified = false;
            } else {
                HBCIUtils.log(this.name + ".startWaiting: notified (notified before wait())", 4);
                this.notified = false;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void stopWaiting() {
        HBCIUtils.log(this.name + ".stopWaiting", 4);
        this.notified = true;
        if (this.waiting) {
            HBCIUtils.log(this.name + ".stopWaiting: someone waits, so notify()", 4);
            this.notify();
        } else {
            if (this.timeouted) {
                HBCIUtils.log(this.name + ".stopWaiting: trying to awake a timeouted wait() - aborting", 4);
                this.timeouted = false;
                throw new RuntimeException(this.name + ": can not awake a timeouted wait()");
            }
            HBCIUtils.log(this.name + ".stopWaiting: no one waits, so we do nothing", 4);
        }
    }

    public void setData(String key, Object obj) {
        if (obj != null) {
            this.data.put(key, obj);
        } else {
            this.data.remove(key);
        }
    }

    public void clearData() {
        this.data.clear();
    }

    public Object getData(String key) {
        return this.data.get(key);
    }
}

