/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.passport;

import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import org.kapott.cryptalgs.SignatureParamSpec;
import org.kapott.hbci.comm.Comm;
import org.kapott.hbci.dialog.DialogContext;
import org.kapott.hbci.dialog.DialogEvent;
import org.kapott.hbci.dialog.KnownDialogTemplate;
import org.kapott.hbci.dialog.RawHBCIDialog;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.HBCIKernelImpl;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.AbstractHBCIPassport;
import org.kapott.hbci.passport.InitLetterPassport;
import org.kapott.hbci.tools.CryptUtils;

public abstract class AbstractRDHPassport
extends AbstractHBCIPassport
implements InitLetterPassport {
    protected AbstractRDHPassport(Object init) {
        super(init);
    }

    @Override
    public String getPassportTypeName() {
        return "RDH";
    }

    @Override
    public boolean isSupported() {
        boolean ret = false;
        if (this.getBPD() != null) {
            String[][] methods = this.getSuppSecMethods();
            String passportVersion = this.getProfileVersion();
            boolean noPassportVersion = passportVersion.length() == 0;
            for (int i = 0; i < methods.length; ++i) {
                String method = methods[i][0];
                String version = methods[i][1];
                if (!method.equals("RDH") || !noPassportVersion && !passportVersion.equals(version)) continue;
                ret = true;
                break;
            }
        } else {
            ret = true;
        }
        return ret;
    }

    @Override
    public Comm getCommInstance() {
        return Comm.getInstance("Standard", this);
    }

    @Override
    public String getSysStatus() {
        return "1";
    }

    @Override
    public boolean needInstKeys() {
        return true;
    }

    @Override
    public boolean needUserKeys() {
        return true;
    }

    @Override
    public boolean needUserSig() {
        return false;
    }

    @Override
    public String getProfileMethod() {
        return "RDH";
    }

    @Override
    public String getCryptKeyType() {
        return "6";
    }

    @Override
    public String getSigFunction() {
        String ret = this.getHBCIVersion().equals("300") ? "2" : "1";
        HBCIUtils.log("using sig function " + ret, 5);
        return ret;
    }

    @Override
    public String getSigAlg() {
        return "10";
    }

    @Override
    public String getSigMode() {
        int profile = Integer.parseInt(this.getProfileVersion());
        String ret = null;
        switch (profile) {
            case 1: {
                ret = "16";
                break;
            }
            case 2: {
                ret = "17";
                break;
            }
            case 10: {
                ret = "19";
                break;
            }
            default: {
                throw new HBCI_Exception("*** dont know which sigmode to use for profile rdh-" + profile);
            }
        }
        HBCIUtils.log("using sig mode " + ret, 5);
        return ret;
    }

    @Override
    public String getCryptFunction() {
        return "4";
    }

    @Override
    public String getCryptAlg() {
        return "13";
    }

    @Override
    public String getCryptMode() {
        int profile = Integer.parseInt(this.getProfileVersion());
        String ret = null;
        switch (profile) {
            case 1: {
                ret = "2";
                break;
            }
            case 2: {
                ret = "2";
                break;
            }
            case 10: {
                ret = "2";
                break;
            }
            default: {
                throw new HBCI_Exception("*** dont know which cryptmode to use for profile rdh-" + profile);
            }
        }
        HBCIUtils.log("using crypt mode " + ret, 5);
        return ret;
    }

    protected int getCryptDataSize(Key key) {
        int profile = Integer.parseInt(this.getProfileVersion());
        int ret = -1;
        switch (profile) {
            case 1: 
            case 2: 
            case 10: {
                int bits = ((RSAPublicKey)key).getModulus().bitLength();
                int bytes = bits >> 3;
                if ((bits & 7) != 0) {
                    ++bytes;
                }
                ret = bytes;
                break;
            }
            default: {
                throw new HBCI_Exception("*** dont know which crypt data size to use for profile rdh-" + profile);
            }
        }
        HBCIUtils.log("using crypt data size " + ret, 5);
        return ret;
    }

    @Override
    public String getHashAlg() {
        int profile = Integer.parseInt(this.getProfileVersion());
        String ret = null;
        switch (profile) {
            case 1: {
                ret = "999";
                break;
            }
            case 2: {
                ret = "999";
                break;
            }
            case 10: {
                ret = "6";
                break;
            }
            default: {
                throw new HBCI_Exception("*** dont know which hashalg to use for profile rdh-" + profile);
            }
        }
        HBCIUtils.log("using hash alg " + ret, 5);
        return ret;
    }

    @Override
    public SignatureParamSpec getSignatureParamSpec() {
        int profile = Integer.parseInt(this.getProfileVersion());
        String hashalg = null;
        String hashprovider = null;
        switch (profile) {
            case 1: {
                hashalg = "RIPEMD160";
                hashprovider = "CryptAlgs4Java";
                break;
            }
            case 2: {
                hashalg = "RIPEMD160";
                hashprovider = "CryptAlgs4Java";
                break;
            }
            case 10: {
                hashalg = "SHA-256";
                break;
            }
            default: {
                throw new HBCI_Exception("*** dont know which hash instance to use for profile rdh-" + profile);
            }
        }
        HBCIUtils.log("using hash instance " + hashalg + "/" + hashprovider, 5);
        return new SignatureParamSpec(hashalg, hashprovider);
    }

    protected Signature getSignatureInstance() {
        int profile = Integer.parseInt(this.getProfileVersion());
        String sigalg = null;
        String sigprovider = null;
        switch (profile) {
            case 1: {
                sigalg = "ISO9796p1";
                sigprovider = "CryptAlgs4Java";
                break;
            }
            case 2: {
                sigalg = "ISO9796p2";
                sigprovider = "CryptAlgs4Java";
                break;
            }
            case 10: {
                sigalg = "PKCS1_PSS";
                sigprovider = "CryptAlgs4Java";
                break;
            }
            default: {
                throw new HBCI_Exception("*** dont know which signature instance to use for profile rdh-" + profile);
            }
        }
        HBCIUtils.log("using sig instance " + sigalg + "/" + sigprovider, 5);
        try {
            Signature sig = Signature.getInstance(sigalg, sigprovider);
            sig.setParameter(this.getSignatureParamSpec());
            return sig;
        }
        catch (Exception ex) {
            throw new HBCI_Exception("*** signing of message failed", ex);
        }
    }

    protected SecretKey createMsgKey() {
        try {
            KeyGenerator generator = KeyGenerator.getInstance("DESede");
            SecretKey key = generator.generateKey();
            String provider = CryptUtils.getSecurityProvider();
            SecretKeyFactory factory = provider == null ? SecretKeyFactory.getInstance("DESede") : SecretKeyFactory.getInstance("DESede", provider);
            DESedeKeySpec spec = (DESedeKeySpec)factory.getKeySpec(key, DESedeKeySpec.class);
            byte[] bytes = spec.getKey();
            System.arraycopy(bytes, 0, bytes, 16, 8);
            spec = new DESedeKeySpec(bytes);
            key = factory.generateSecret(spec);
            return key;
        }
        catch (Exception ex) {
            throw new HBCI_Exception("*** can not create message key", ex);
        }
    }

    @Override
    public byte[] hash(byte[] data) {
        byte[] result = data;
        if (this.getHashAlg().equals("6")) {
            MessageDigest dig;
            try {
                dig = MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            result = dig.digest(data);
        }
        return result;
    }

    @Override
    public void onDialogEvent(DialogEvent event, DialogContext ctx) {
        super.onDialogEvent(event, ctx);
        if (event != DialogEvent.MSG_CREATED) {
            return;
        }
        RawHBCIDialog init = ctx.getDialogInit();
        if (init.getTemplate() != KnownDialogTemplate.INIT || ctx.isAnonymous()) {
            return;
        }
        if (!this.needInstKeys()) {
            return;
        }
        HBCIKernelImpl k = ctx.getKernel();
        k.rawSet("KeyReq.SecProfile.method", this.getProfileMethod());
        k.rawSet("KeyReq.SecProfile.version", this.getProfileVersion());
        k.rawSet("KeyReq.KeyName.keytype", "V");
        k.rawSet("KeyReq.KeyName.KIK.country", this.getCountry());
        k.rawSet("KeyReq.KeyName.KIK.blz", this.getBLZ());
        k.rawSet("KeyReq.KeyName.userid", this.getInstEncKeyName());
        k.rawSet("KeyReq.KeyName.keynum", this.getInstEncKeyNum());
        k.rawSet("KeyReq.KeyName.keyversion", this.getInstEncKeyVersion());
        if (this.hasInstSigKey()) {
            k.rawSet("KeyReq_2.SecProfile.method", this.getProfileMethod());
            k.rawSet("KeyReq_2.SecProfile.version", this.getProfileVersion());
            k.rawSet("KeyReq_2.KeyName.keytype", "S");
            k.rawSet("KeyReq_2.KeyName.KIK.country", this.getCountry());
            k.rawSet("KeyReq_2.KeyName.KIK.blz", this.getBLZ());
            k.rawSet("KeyReq_2.KeyName.userid", this.getInstSigKeyName());
            k.rawSet("KeyReq_2.KeyName.keynum", this.getInstSigKeyNum());
            k.rawSet("KeyReq_2.KeyName.keyversion", this.getInstSigKeyVersion());
        }
    }
}

