/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.passport;

import java.io.File;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.kapott.cryptalgs.SignatureParamSpec;
import org.kapott.hbci.comm.Comm;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.HBCIKey;
import org.kapott.hbci.manager.HBCIKeyUtil;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.HBCIUtilsInternal;
import org.kapott.hbci.passport.AbstractHBCIPassport;
import org.kapott.hbci.passport.FileBasedPassport;
import org.kapott.hbci.passport.HBCIPassport;
import org.kapott.hbci.passport.InitLetterPassport;
import org.kapott.hbci.passport.storage.PassportData;
import org.kapott.hbci.passport.storage.PassportStorage;
import org.kapott.hbci.tools.CryptUtils;

public class HBCIPassportRAH10
extends AbstractHBCIPassport
implements InitLetterPassport,
FileBasedPassport {
    private static final String PROFILE_NAME = "RAH";
    private static final String PROFILE_VERSION = "10";
    public static final String PARAM_PREFIX = "client.passport.RAH10";
    private String filename = null;
    private PassportData data = null;

    public HBCIPassportRAH10(Object initObject) {
        super(initObject);
        this.setParamHeader(PARAM_PREFIX);
        String prefix = this.getParamHeader();
        this.filename = HBCIUtils.getParam(prefix + ".filename");
        if (this.filename == null) {
            throw new NullPointerException(prefix + ".filename must not be null");
        }
        HBCIUtils.log("using passport file " + this.filename, 4);
        if (!HBCIUtils.getParam(prefix + ".init", "1").equals("1")) {
            return;
        }
        HBCIUtils.log("loading data from " + this.filename, 4);
        this.setFilterType("None");
        this.setPort(new Integer(3000));
        if (!new File(this.filename).canRead()) {
            HBCIUtils.log("have to create new passport file", 3);
            this.askForMissingData(true, true, true, true, false, true, true);
            this.saveChanges();
        }
        this.init(PassportStorage.load((HBCIPassport)this, new File(this.filename)));
        if (this.askForMissingData(true, true, true, true, false, true, true)) {
            this.saveChanges();
        }
    }

    protected HBCIPassportRAH10(Object initObject, PassportData data) {
        super(initObject);
        this.setParamHeader(PARAM_PREFIX);
        this.setFilterType("None");
        this.setPort(new Integer(3000));
        this.init(data);
    }

    protected void init(PassportData data) {
        this.data = data;
        this.setBLZ(data.blz);
        this.setCountry(data.country);
        this.setHost(data.host);
        this.setPort(data.port);
        this.setUserId(data.userId);
        this.setCustomerId(data.customerId);
        this.setSysId(data.sysId);
        this.setSigId(data.sigId);
        this.setHBCIVersion(data.hbciVersion);
        this.setBPD(data.bpd);
        this.setUPD(data.upd);
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    protected PassportData getUpdatedData() {
        if (this.data == null) {
            this.data = new PassportData();
        }
        this.data.country = this.getCountry();
        this.data.blz = this.getBLZ();
        this.data.host = this.getHost();
        this.data.port = this.getPort();
        this.data.userId = this.getUserId();
        this.data.customerId = this.getCustomerId();
        this.data.sysId = this.getSysId();
        this.data.sigId = this.getSigId();
        this.data.hbciVersion = this.getHBCIVersion();
        this.data.bpd = this.getBPD();
        this.data.upd = this.getUPD();
        return this.data;
    }

    @Override
    public void saveChanges() {
        try {
            PassportStorage.save((HBCIPassport)this, this.getUpdatedData(), new File(this.filename));
        }
        catch (HBCI_Exception he) {
            throw he;
        }
        catch (Exception e) {
            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_PASSPORT_WRITEERR"), e);
        }
    }

    @Override
    public String getPassportTypeName() {
        return PROFILE_NAME;
    }

    @Override
    public String getProfileMethod() {
        return PROFILE_NAME;
    }

    @Override
    public String getProfileVersion() {
        return PROFILE_VERSION;
    }

    @Override
    public void resetPassphrase() {
    }

    @Override
    public String getSysStatus() {
        return "1";
    }

    @Override
    public boolean needUserSig() {
        return false;
    }

    @Override
    public void setInstSigKey(HBCIKey key) {
        this.data.instSigKey = key;
    }

    @Override
    public void setInstEncKey(HBCIKey key) {
        this.data.instEncKey = key;
    }

    @Override
    public void setMyPublicSigKey(HBCIKey key) {
        this.data.myPublicSigKey = key;
    }

    @Override
    public void setMyPrivateSigKey(HBCIKey key) {
        this.data.myPrivateSigKey = key;
    }

    @Override
    public void setMyPublicEncKey(HBCIKey key) {
        this.data.myPublicEncKey = key;
    }

    @Override
    public void setMyPrivateEncKey(HBCIKey key) {
        this.data.myPrivateEncKey = key;
    }

    @Override
    public void setMyPublicDigKey(HBCIKey key) {
    }

    @Override
    public void setMyPrivateDigKey(HBCIKey key) {
    }

    @Override
    public String getInstSigKeyName() {
        return HBCIKeyUtil.getUserId(this.getInstSigKey());
    }

    @Override
    public String getInstSigKeyNum() {
        return HBCIKeyUtil.getNum(this.getInstSigKey());
    }

    @Override
    public String getInstSigKeyVersion() {
        return HBCIKeyUtil.getVersion(this.getInstSigKey());
    }

    @Override
    public String getInstEncKeyName() {
        return HBCIKeyUtil.getUserId(this.getInstEncKey());
    }

    @Override
    public String getInstEncKeyNum() {
        return HBCIKeyUtil.getNum(this.getInstEncKey());
    }

    @Override
    public String getInstEncKeyVersion() {
        return HBCIKeyUtil.getVersion(this.getInstEncKey());
    }

    @Override
    public String getMySigKeyName() {
        return HBCIKeyUtil.getUserId(this.getMyPublicSigKey());
    }

    @Override
    public String getMySigKeyNum() {
        return HBCIKeyUtil.getNum(this.getMyPublicSigKey());
    }

    @Override
    public String getMySigKeyVersion() {
        return HBCIKeyUtil.getVersion(this.getMyPublicSigKey());
    }

    @Override
    public String getMyEncKeyName() {
        return HBCIKeyUtil.getUserId(this.getMyPublicEncKey());
    }

    @Override
    public String getMyEncKeyNum() {
        return HBCIKeyUtil.getNum(this.getMyPublicEncKey());
    }

    @Override
    public String getMyEncKeyVersion() {
        return HBCIKeyUtil.getVersion(this.getMyPublicEncKey());
    }

    @Override
    public String getCryptKeyType() {
        return "6";
    }

    @Override
    public String getCryptFunction() {
        return "4";
    }

    @Override
    public String getCryptAlg() {
        return "14";
    }

    @Override
    public String getCryptMode() {
        return "2";
    }

    @Override
    public String getSigFunction() {
        return "2";
    }

    @Override
    public String getSigAlg() {
        return PROFILE_VERSION;
    }

    @Override
    public String getSigMode() {
        return "19";
    }

    @Override
    public String getHashAlg() {
        return "6";
    }

    @Override
    public byte[] hash(byte[] data) {
        return CryptUtils.hash(data, "SHA-256");
    }

    @Override
    public byte[] sign(byte[] data) {
        PrivateKey key = (PrivateKey)this.getMyPrivateSigKey().key;
        byte[] sig = CryptUtils.sign(data, key, "PKCS1_PSS", "SHA-256");
        return CryptUtils.padLeft(sig, (RSAPublicKey)this.getMyPublicSigKey().key);
    }

    @Override
    public boolean verify(byte[] data, byte[] sig) {
        PublicKey key = (PublicKey)this.getInstSigKey().key;
        return CryptUtils.verifySignature(data, sig, key, "PKCS1_PSS", "SHA-256");
    }

    @Override
    public byte[][] encrypt(byte[] plainMsg) {
        try {
            String provider = CryptUtils.getSecurityProvider();
            KeyGenerator keygen = provider != null ? KeyGenerator.getInstance("AES", provider) : KeyGenerator.getInstance("AES");
            keygen.init(256);
            SecretKey msgKey = keygen.generateKey();
            byte[][] ret = new byte[][]{this.encryptKey(msgKey.getEncoded()), this.encryptMessage(plainMsg, msgKey)};
            return ret;
        }
        catch (HBCI_Exception e) {
            throw e;
        }
        catch (Exception e2) {
            throw new HBCI_Exception(e2);
        }
    }

    private byte[] encryptMessage(byte[] plainMsg, SecretKey msgkey) {
        try {
            String provider = CryptUtils.getSecurityProvider();
            Cipher cipher = provider == null ? Cipher.getInstance("AES/CBC/ISO7816-4Padding") : Cipher.getInstance("AES/CBC/ISO7816-4Padding", provider);
            byte[] iv = new byte[16];
            Arrays.fill(iv, (byte)0);
            IvParameterSpec spec = new IvParameterSpec(iv);
            cipher.init(1, (Key)msgkey, spec);
            byte[] result = cipher.doFinal(plainMsg);
            return result;
        }
        catch (HBCI_Exception e) {
            throw e;
        }
        catch (Exception ex) {
            throw new HBCI_Exception(ex);
        }
    }

    private byte[] encryptKey(byte[] plainKey) {
        try {
            RSAPublicKey key = (RSAPublicKey)this.getInstEncKey().key;
            int tSize = CryptUtils.getCryptDataSize(key);
            byte[] plainText = CryptUtils.padLeft(plainKey, tSize);
            BigInteger m = new BigInteger(1, plainText);
            BigInteger c = m.modPow(key.getPublicExponent(), key.getModulus());
            byte[] result = c.toByteArray();
            return HBCIPassportRAH10.checkForCryptDataSize(result, tSize);
        }
        catch (HBCI_Exception e) {
            throw e;
        }
        catch (Exception ex) {
            throw new HBCI_Exception(ex);
        }
    }

    @Override
    public byte[] decrypt(byte[] cryptedKey, byte[] encryptedMsg) {
        try {
            String provider = CryptUtils.getSecurityProvider();
            HBCIUtils.log("decrypting message key", 4);
            RSAPrivateKey key = (RSAPrivateKey)this.getMyPrivateEncKey().key;
            BigInteger e = key.getPrivateExponent();
            BigInteger m = key.getModulus();
            BigInteger c = new BigInteger(1, cryptedKey);
            byte[] plainKey = c.modPow(e, m).toByteArray();
            if (plainKey.length > 32) {
                plainKey = Arrays.copyOfRange(plainKey, plainKey.length - 32, plainKey.length);
            }
            HBCIUtils.log("decrypting message", 4);
            SecretKeySpec msgKey = new SecretKeySpec(plainKey, "AES");
            Cipher cm = provider == null ? Cipher.getInstance("AES/CBC/ISO7816-4Padding") : Cipher.getInstance("AES/CBC/ISO7816-4Padding", provider);
            byte[] iv = new byte[16];
            Arrays.fill(iv, (byte)0);
            IvParameterSpec spec = new IvParameterSpec(iv);
            cm.init(2, (Key)msgKey, spec);
            byte[] decrypt = cm.doFinal(encryptedMsg);
            byte[] res = new byte[decrypt.length + 1];
            System.arraycopy(decrypt, 0, res, 0, decrypt.length);
            res[res.length - 1] = 1;
            return res;
        }
        catch (HBCI_Exception e) {
            throw e;
        }
        catch (Exception ex) {
            throw new HBCI_Exception(ex);
        }
    }

    @Override
    public HBCIKey[][] generateNewUserKeys() {
        HBCIKey[] newSigKey = new HBCIKey[2];
        HBCIKey[] newEncKey = new HBCIKey[2];
        try {
            HBCIUtils.log("Erzeuge neue Benutzerschl\u00fcssel", 3);
            String profileVersion = this.getProfileVersion();
            String num = this.hasMySigKey() ? this.getMyPublicSigKey().num : profileVersion;
            String version = this.hasMySigKey() ? this.getMyPublicSigKey().version : "0";
            version = Integer.toString(Integer.parseInt(version) + 1);
            int keySize = 4096;
            HBCIKey k = this.getInstSigKey();
            if (k == null) {
                k = this.getInstEncKey();
            }
            if (k != null) {
                RSAPublicKey pkey = (RSAPublicKey)k.key;
                keySize = pkey.getModulus().bitLength();
            }
            String blz = this.getBLZ();
            String country = this.getCountry();
            String userid = this.getUserId();
            for (int i = 0; i < 2; ++i) {
                KeyPairGenerator keygen = KeyPairGenerator.getInstance("RSA");
                keygen.initialize(keySize);
                KeyPair pair = keygen.generateKeyPair();
                if (i == 0) {
                    newSigKey[0] = new HBCIKey(country, blz, userid, num, version, pair.getPublic());
                    newSigKey[1] = new HBCIKey(country, blz, userid, num, version, pair.getPrivate());
                    continue;
                }
                newEncKey[0] = new HBCIKey(country, blz, userid, num, version, pair.getPublic());
                newEncKey[1] = new HBCIKey(country, blz, userid, num, version, pair.getPrivate());
            }
        }
        catch (Exception ex) {
            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_GENKEYS_ERR"), ex);
        }
        HBCIKey[][] ret = new HBCIKey[][]{newSigKey, newEncKey};
        return ret;
    }

    @Override
    public SignatureParamSpec getSignatureParamSpec() {
        try {
            return new SignatureParamSpec("SHA-256", null);
        }
        catch (Exception e) {
            throw new HBCI_Exception(e);
        }
    }

    @Override
    public boolean isSupported() {
        if (this.getBPD() == null) {
            return true;
        }
        for (String[] entry : this.getSuppSecMethods()) {
            if (!PROFILE_NAME.equals(entry[0]) || !PROFILE_VERSION.equals(entry[1])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean needInstKeys() {
        return true;
    }

    @Override
    public boolean needUserKeys() {
        return true;
    }

    @Override
    public boolean hasInstSigKey() {
        return this.getInstSigKey() != null;
    }

    @Override
    public boolean hasInstEncKey() {
        return this.getInstEncKey() != null;
    }

    @Override
    public boolean hasMySigKey() {
        return this.getMyPublicSigKey() != null;
    }

    @Override
    public boolean hasMyEncKey() {
        return this.getMyPublicEncKey() != null;
    }

    @Override
    public HBCIKey getMyPublicSigKey() {
        return this.data.myPublicSigKey;
    }

    @Override
    public HBCIKey getMyPublicEncKey() {
        return this.data.myPublicEncKey;
    }

    @Override
    public HBCIKey getMyPublicDigKey() {
        return null;
    }

    @Override
    public HBCIKey getMyPrivateSigKey() {
        return this.data.myPrivateSigKey;
    }

    @Override
    public HBCIKey getMyPrivateEncKey() {
        return this.data.myPrivateEncKey;
    }

    @Override
    public HBCIKey getMyPrivateDigKey() {
        return null;
    }

    @Override
    public HBCIKey getInstSigKey() {
        return this.data.instSigKey;
    }

    @Override
    public HBCIKey getInstEncKey() {
        return this.data.instEncKey;
    }

    @Override
    public Comm getCommInstance() {
        return Comm.getInstance("Standard", this);
    }
}

