/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.passport;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.HBCIKey;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.HBCIUtilsInternal;
import org.kapott.hbci.manager.LogFilter;
import org.kapott.hbci.passport.AbstractRDHSWFileBasedPassport;
import org.kapott.hbci.passport.rdhXfile.HBCIAccount;
import org.kapott.hbci.passport.rdhXfile.RDHXFile;
import org.kapott.hbci.passport.rdhXfile.TLV;
import org.kapott.hbci.tools.IOUtils;

public class HBCIPassportRDHXFile
extends AbstractRDHSWFileBasedPassport {
    private byte[] passphrase;
    private RDHXFile filecontent;
    private int entryIdx;
    private String forcedProfileVersion = null;

    public HBCIPassportRDHXFile(Object init, int dummy) {
        super(init);
    }

    protected String getCompatName() {
        return "RDHXFile";
    }

    public HBCIPassportRDHXFile(Object initObject) {
        this(initObject, 0);
        this.setParamHeader("client.passport." + this.getCompatName());
        String fname = HBCIUtils.getParam(this.getParamHeader() + ".filename");
        if (fname == null) {
            throw new NullPointerException(this.getParamHeader() + ".filename must not be null");
        }
        HBCIUtils.log("loading passport data from file " + fname, 4);
        this.setFilename(fname);
        boolean init = HBCIUtils.getParam(this.getParamHeader() + ".init", "1").equals("1");
        if (init) {
            BufferedInputStream is;
            block14: {
                HBCIUtils.log("loading data from file " + this.getFilename(), 4);
                this.setFilterType("None");
                this.setPort(new Integer(3000));
                if (!new File(this.getFilename()).canRead()) {
                    HBCIUtils.log("have to create new passport file", 2);
                    this.askForMissingData(true, true, true, false, false, true, true);
                    this.saveChanges();
                }
                is = null;
                try {
                    TLV[] accountFields;
                    if (this.passphrase == null) {
                        StringBuffer retData = new StringBuffer();
                        HBCIUtilsInternal.getCallback().callback(this, 21, HBCIUtilsInternal.getLocMsg("CALLB_NEED_PASS"), 1, retData);
                        LogFilter.getInstance().addSecretData(retData.toString(), "X", 1);
                        this.setPassphrase(retData.toString().getBytes());
                    }
                    is = new BufferedInputStream(new FileInputStream(fname));
                    byte[] data = IOUtils.read(is);
                    ((InputStream)is).close();
                    this.filecontent = new RDHXFile(data, this.passphrase);
                    this.entryIdx = 0;
                    TLV[] hbciAccounts = this.filecontent.getFields(HBCIAccount.class);
                    if (hbciAccounts.length > 1) {
                        StringBuffer possibilities = new StringBuffer();
                        for (int i = 0; i < hbciAccounts.length; ++i) {
                            HBCIAccount hbciAccount = (HBCIAccount)hbciAccounts[i];
                            if (i != 0) {
                                possibilities.append("|");
                            }
                            possibilities.append(i);
                            possibilities.append(";" + hbciAccount.getBLZ());
                            possibilities.append(";" + hbciAccount.getUserId());
                        }
                        HBCIUtilsInternal.getCallback().callback(this, 23, "*** select one of the following entries", 2, possibilities);
                        this.entryIdx = Integer.parseInt(possibilities.toString());
                    }
                    if ((accountFields = this.filecontent.getFields(HBCIAccount.class)).length != 0) {
                        HBCIAccount hbciAccount = (HBCIAccount)accountFields[this.entryIdx];
                        this.setBLZ(hbciAccount.getBLZ());
                        this.setCountry(hbciAccount.getCountry());
                        this.setHost(hbciAccount.getHost());
                        this.setUserId(hbciAccount.getUserId());
                        this.setCustomerId(hbciAccount.getCustomerId());
                        this.setSysId(hbciAccount.getSysId());
                        this.setSigId(new Long(hbciAccount.getSigId()));
                        this.setInstSigKey(this.filecontent.getBankSigKey(hbciAccount));
                        this.setInstEncKey(this.filecontent.getBankEncKey(hbciAccount));
                        HBCIKey[] userkeys = hbciAccount.getUserSigKeys();
                        if (userkeys != null) {
                            this.setMyPublicSigKey(userkeys[0]);
                            this.setMyPrivateSigKey(userkeys[1]);
                        }
                        if ((userkeys = hbciAccount.getUserEncKeys()) != null) {
                            this.setMyPublicEncKey(userkeys[0]);
                            this.setMyPrivateEncKey(userkeys[1]);
                        }
                    }
                    if (!this.askForMissingData(true, true, true, false, false, true, true)) break block14;
                    this.saveChanges();
                }
                catch (Exception e) {
                    try {
                        throw new HBCI_Exception("*** error while reading passport file", e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.close(is);
                        throw throwable;
                    }
                }
            }
            IOUtils.close(is);
        }
    }

    @Override
    public void saveChanges() {
        try {
            HBCIAccount hbciAccount;
            TLV[] accountFields;
            if (this.passphrase == null) {
                StringBuffer retData = new StringBuffer();
                HBCIUtilsInternal.getCallback().callback(this, 22, HBCIUtilsInternal.getLocMsg("CALLB_NEED_PASS"), 1, retData);
                LogFilter.getInstance().addSecretData(retData.toString(), "X", 1);
                this.setPassphrase(retData.toString().getBytes());
            }
            File passportfile = new File(this.getFilename());
            File directory = passportfile.getAbsoluteFile().getParentFile();
            String prefix = passportfile.getName() + "_";
            File tempfile = File.createTempFile(prefix, "", directory);
            if (this.filecontent == null) {
                this.filecontent = new RDHXFile(this.passphrase);
            }
            if ((accountFields = this.filecontent.getFields(HBCIAccount.class)).length == 0) {
                hbciAccount = new HBCIAccount();
                this.filecontent.addField(hbciAccount);
            } else {
                hbciAccount = (HBCIAccount)accountFields[this.entryIdx];
            }
            hbciAccount.setCountry(this.getCountry());
            hbciAccount.setBLZ(this.getBLZ());
            hbciAccount.setHost(this.getHost());
            hbciAccount.setUserId(this.getUserId());
            hbciAccount.setCustomerId(this.getCustomerId());
            hbciAccount.setSysId(this.getSysId());
            hbciAccount.setSigId(this.getSigId());
            this.filecontent.setBankSigKey(hbciAccount, this.getInstSigKey());
            this.filecontent.setBankEncKey(hbciAccount, this.getInstEncKey());
            hbciAccount.setUserSigKeys(new HBCIKey[]{this.getMyPublicSigKey(), this.getMyPrivateSigKey()});
            hbciAccount.setUserEncKeys(new HBCIKey[]{this.getMyPublicEncKey(), this.getMyPrivateEncKey()});
            int pversion = Integer.parseInt(this.getProfileVersion());
            byte[] data = this.filecontent.getFileData(pversion);
            FileOutputStream fo = new FileOutputStream(tempfile);
            fo.write(data);
            fo.close();
            IOUtils.safeReplace(passportfile, tempfile);
        }
        catch (Exception e) {
            throw new HBCI_Exception("*** saving of passport file failed", e);
        }
    }

    @Override
    public String getProfileVersion() {
        String result = this.forcedProfileVersion;
        if (result == null) {
            HBCIUtils.log("no RDH profile version explicity specified - starting autodetection", 4);
            if (this.getHBCIVersion().length() != 0 && !this.getHBCIVersion().startsWith("3")) {
                result = "1";
                this.setProfileVersion(result);
                HBCIUtils.log("this is HBCI version '" + this.getHBCIVersion() + "', which only supports RDH-1", 4);
            } else {
                HBCIKey key = this.getMyPublicSigKey();
                if (key != null) {
                    result = key.num;
                    this.setProfileVersion(result);
                    HBCIUtils.log("using user sig key num '" + result + "' as profile version", 4);
                } else {
                    key = this.getInstEncKey();
                    if (key != null && (key.num.equals("1") || key.num.equals("2") || key.num.equals("10"))) {
                        result = key.num;
                        HBCIUtils.log("using inst enc key num '" + result + "' as RDH profile version", 4);
                    } else {
                        HBCIUtils.log("no keys found in passport - so we use the highest available profile", 4);
                        String[][] methods = this.getSuppSecMethods();
                        int maxVersion = 0;
                        for (int i = 0; i < methods.length; ++i) {
                            String method = methods[i][0];
                            int version = Integer.parseInt(methods[i][1]);
                            if (!method.equals("RDH") || version != 1 && version != 2 && version != 10 || version <= maxVersion) continue;
                            maxVersion = version;
                        }
                        if (maxVersion != 0) {
                            result = Integer.toString(maxVersion);
                            this.setProfileVersion(result);
                        }
                        HBCIUtils.log("using RDH profile '" + result + "' taken from supported profiles (BPD)", 4);
                    }
                }
            }
        } else {
            HBCIUtils.log("using forced RDH profile version '" + result + "'", 4);
        }
        return result;
    }

    @Override
    public void setProfileVersion(String version) {
        if (version != null) {
            Integer.parseInt(version);
        }
        this.forcedProfileVersion = version;
    }

    @Override
    public void resetPassphrase() {
        this.passphrase = null;
    }

    public void setPassphrase(byte[] passphrase) {
        this.passphrase = passphrase;
        if (this.filecontent != null) {
            this.filecontent.setPassphrase(passphrase);
        }
    }
}

