/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.passport;

import java.io.File;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;
import org.kapott.cryptalgs.SignatureParamSpec;
import org.kapott.hbci.datatypes.SyntaxCtr;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.HBCIKey;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.HBCIUtilsInternal;
import org.kapott.hbci.manager.LogFilter;
import org.kapott.hbci.passport.AbstractRDHPassport;
import org.kapott.hbci.passport.HBCIPassport;
import org.kapott.hbci.passport.HBCIPassportChipcard;
import org.kapott.hbci.passport.storage.PassportData;
import org.kapott.hbci.passport.storage.PassportStorage;
import org.kapott.hbci.smartcardio.RSABankData;
import org.kapott.hbci.smartcardio.RSACardService;
import org.kapott.hbci.smartcardio.RSAKeyData;
import org.kapott.hbci.smartcardio.SmartCardService;
import org.kapott.hbci.tools.CryptUtils;
import org.kapott.hbci.tools.IOUtils;

public class HBCIPassportRSA
extends AbstractRDHPassport
implements HBCIPassportChipcard {
    private static final int KEY_INST_SIG = 0;
    private static final int KEY_INST_ENC = 1;
    private static final int KEY_MY_PUBLIC_SIG = 2;
    private static final int KEY_MY_PUBLIC_ENC = 3;
    private String filename;
    private HBCIKey[] keys;
    private String cardid;
    private boolean pinEntered;
    private int useSoftPin;
    private byte[] softPin;
    private int entryIdx;
    private String forcedProfileVersion;
    private String bankId;
    private String defaultCustomerId;
    private RSACardService cardService;

    public HBCIPassportRSA(Object init, int dummy) {
        super(init);
        this.setParamHeader("client.passport.RSA");
        this.forcedProfileVersion = null;
        this.keys = new HBCIKey[4];
        for (int n = 0; n < 4; ++n) {
            this.keys[n] = null;
        }
    }

    public HBCIPassportRSA(Object init) {
        this(init, 0);
        try {
            this.setUseSoftPin(Integer.parseInt(HBCIUtils.getParam(this.getParamHeader() + ".softpin", "-1")));
            this.setSoftPin(new byte[0]);
            this.setPINEntered(false);
            this.setEntryIdx(Integer.parseInt(HBCIUtils.getParam(this.getParamHeader() + ".entryidx", "1")));
            HBCIUtils.log("initializing javax.smartcardio", 4);
            HBCIUtilsInternal.getCallback().callback(this, 2, HBCIUtilsInternal.getLocMsg("CALLB_NEED_CHIPCARD"), 0, null);
            this.initCT();
            HBCIUtilsInternal.getCallback().callback(this, 6, "", 0, null);
            this.setPort(new Integer(3000));
            this.setFilterType("None");
            try {
                this.readBankData();
                this.readKeyData();
            }
            catch (HBCI_Exception e) {
                throw e;
            }
            catch (Exception e) {
                throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_PASSPORT_INSTDATAERR"), e);
            }
            String path = HBCIUtils.getParam(this.getParamHeader() + ".path", "./");
            this.setFileName(HBCIUtilsInternal.withCounter(path + this.getCardId(), this.getEntryIdx() - 1));
            HBCIUtils.log("loading passport data from file " + this.getFileName(), 4);
            File file = new File(this.getFileName());
            if (!(file.exists() && file.isFile() && file.canRead())) {
                HBCIUtils.log("have to create new passport file", 2);
                this.askForMissingData(true, true, true, false, false, true, true);
                this.saveChanges();
            }
            PassportData data = PassportStorage.load((HBCIPassport)this, file);
            this.setBPD(data.bpd);
            this.setUPD(data.upd);
            this.setHBCIVersion(data.hbciVersion);
            this.setSysId(data.sysId);
            this.setCustomerId(data.customerId);
        }
        catch (Exception e) {
            try {
                this.closeCT();
            }
            catch (Exception e2) {
                HBCIUtils.log(e2);
            }
            if (e instanceof HBCI_Exception) {
                throw (HBCI_Exception)e;
            }
            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_CTERR"), e);
        }
    }

    @Override
    public String getCustomerId() {
        if (this.getStoredCustomerId() == null || this.getStoredCustomerId().length() == 0) {
            if (this.getDefaultCustomerId() == null || this.getDefaultCustomerId().length() == 0) {
                return this.getUserId();
            }
            return this.getDefaultCustomerId();
        }
        return this.getStoredCustomerId();
    }

    public String getDefaultCustomerId() {
        return this.defaultCustomerId;
    }

    public void setDefaultCustomerId(String defaultCustomerId) {
        this.defaultCustomerId = defaultCustomerId;
    }

    public void setBankId(String bankId) {
        this.bankId = bankId;
    }

    public String getBankId() {
        return this.bankId;
    }

    @Override
    public void setFileName(String filename) {
        this.filename = IOUtils.safeFilename(filename);
    }

    @Override
    public String getFileName() {
        return this.filename;
    }

    public void setCardId(String cardid) {
        this.cardid = cardid;
    }

    public String getCardId() {
        return this.cardid;
    }

    public void setPINEntered(boolean pinEntered) {
        this.pinEntered = pinEntered;
    }

    public boolean isPINEntered() {
        return this.pinEntered;
    }

    public void setUseSoftPin(int useSoftPin) {
        this.useSoftPin = useSoftPin;
    }

    public int getUseSoftPin() {
        return this.useSoftPin;
    }

    public void setSoftPin(byte[] softPin) {
        LogFilter.getInstance().addSecretData(new String(softPin), "X", 1);
        this.softPin = softPin;
    }

    public byte[] getSoftPin() {
        return this.softPin;
    }

    public void setEntryIdx(int entryIdx) {
        this.entryIdx = entryIdx;
    }

    public int getEntryIdx() {
        return this.entryIdx;
    }

    @Override
    public void setProfileVersion(String version) {
        if (version != null) {
            Integer.parseInt(version);
        }
        this.forcedProfileVersion = version;
    }

    @Override
    public String getProfileVersion() {
        String result = this.forcedProfileVersion;
        if (result == null) {
            HBCIUtils.log("no RDH profile version explicity specified - starting autodetection", 4);
            if (this.getHBCIVersion().length() != 0 && !this.getHBCIVersion().startsWith("3")) {
                result = "1";
                this.setProfileVersion(result);
                HBCIUtils.log("this is HBCI version '" + this.getHBCIVersion() + "', which only supports RDH-1", 4);
            } else {
                HBCIKey key = this.getMyPublicSigKey();
                if (key != null) {
                    result = key.num;
                    this.setProfileVersion(result);
                    HBCIUtils.log("using user sig key num '" + result + "' as profile version", 4);
                } else {
                    key = this.getInstEncKey();
                    if (key != null && (key.num.equals("1") || key.num.equals("2") || key.num.equals("10"))) {
                        result = key.num;
                        HBCIUtils.log("using inst enc key num '" + result + "' as RDH profile version", 4);
                    } else {
                        HBCIUtils.log("no keys found in passport - so we use the highest available profile", 4);
                        String[][] methods = this.getSuppSecMethods();
                        int maxVersion = 0;
                        for (int i = 0; i < methods.length; ++i) {
                            String method = methods[i][0];
                            int version = Integer.parseInt(methods[i][1]);
                            if (!method.equals("RDH") || version != 1 && version != 2 && version != 10 || version <= maxVersion) continue;
                            maxVersion = version;
                        }
                        if (maxVersion != 0) {
                            result = Integer.toString(maxVersion);
                            this.setProfileVersion(result);
                        }
                        HBCIUtils.log("using RDH profile '" + result + "' taken from supported profiles (BPD)", 4);
                    }
                }
            }
        } else {
            HBCIUtils.log("using forced RDH profile version '" + result + "'", 4);
        }
        return result;
    }

    private void setKey(int i, HBCIKey key) {
        this.keys[i] = key;
    }

    private HBCIKey getKey(int i) {
        return this.keys[i];
    }

    @Override
    public void setInstSigKey(HBCIKey key) {
        this.setKey(0, key);
    }

    @Override
    public void setInstEncKey(HBCIKey key) {
        this.setKey(1, key);
    }

    @Override
    public void setMyPublicSigKey(HBCIKey key) {
        this.setKey(2, key);
    }

    @Override
    public void setMyPrivateSigKey(HBCIKey key) {
    }

    @Override
    public void setMyPublicEncKey(HBCIKey key) {
        this.setKey(3, key);
    }

    @Override
    public void setMyPrivateEncKey(HBCIKey key) {
    }

    @Override
    public void setMyPublicDigKey(HBCIKey key) {
    }

    @Override
    public void setMyPrivateDigKey(HBCIKey key) {
    }

    @Override
    public String getInstSigKeyName() {
        return this.getInstSigKey() != null ? this.getInstSigKey().userid : null;
    }

    @Override
    public String getInstSigKeyNum() {
        return this.getInstSigKey() != null ? this.getInstSigKey().num : null;
    }

    @Override
    public String getInstSigKeyVersion() {
        return this.getInstSigKey() != null ? this.getInstSigKey().version : null;
    }

    @Override
    public String getInstEncKeyName() {
        return this.getInstEncKey() != null ? this.getInstEncKey().userid : null;
    }

    @Override
    public String getInstEncKeyNum() {
        return this.getInstEncKey() != null ? this.getInstEncKey().num : null;
    }

    @Override
    public String getInstEncKeyVersion() {
        return this.getInstEncKey() != null ? this.getInstEncKey().version : null;
    }

    @Override
    public String getMySigKeyName() {
        return this.getMyPublicSigKey() != null ? this.getMyPublicSigKey().userid : null;
    }

    @Override
    public String getMySigKeyNum() {
        return this.getMyPublicSigKey() != null ? this.getMyPublicSigKey().num : null;
    }

    @Override
    public String getMySigKeyVersion() {
        return this.getMyPublicSigKey() != null ? this.getMyPublicSigKey().version : null;
    }

    @Override
    public String getMyEncKeyName() {
        return this.getMyPublicEncKey() != null ? this.getMyPublicEncKey().userid : null;
    }

    @Override
    public String getMyEncKeyNum() {
        return this.getMyPublicEncKey() != null ? this.getMyPublicEncKey().num : null;
    }

    @Override
    public String getMyEncKeyVersion() {
        return this.getMyPublicEncKey() != null ? this.getMyPublicEncKey().version : null;
    }

    @Override
    public byte[] hash(byte[] data) {
        MessageDigest dig;
        data = super.hash(data);
        SignatureParamSpec sps = this.getSignatureParamSpec();
        try {
            dig = MessageDigest.getInstance(sps.getHashAlg(), sps.getProvider());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchProviderException e) {
            throw new RuntimeException(e);
        }
        return dig.digest(data);
    }

    @Override
    public byte[] sign(byte[] data) {
        this.checkPIN();
        return this.ctSign(data);
    }

    @Override
    public boolean verify(byte[] data, byte[] sig) {
        this.checkPIN();
        return this.ctVerify(data, sig);
    }

    private byte[] encryptMessage(byte[] plainMsg, SecretKey msgkey) {
        try {
            String provider = CryptUtils.getSecurityProvider();
            Cipher cipher = provider == null ? Cipher.getInstance("DESede/CBC/NoPadding") : Cipher.getInstance("DESede/CBC/NoPadding", provider);
            byte[] iv = new byte[8];
            Arrays.fill(iv, (byte)0);
            IvParameterSpec spec = new IvParameterSpec(iv);
            cipher.init(1, (Key)msgkey, spec);
            return cipher.doFinal(plainMsg);
        }
        catch (Exception ex) {
            throw new HBCI_Exception("*** can not encrypt message", ex);
        }
    }

    private byte[] encryptKey(SecretKey msgkey) {
        try {
            String provider = CryptUtils.getSecurityProvider();
            SecretKeyFactory factory = provider == null ? SecretKeyFactory.getInstance("DESede") : SecretKeyFactory.getInstance("DESede", provider);
            DESedeKeySpec spec = (DESedeKeySpec)factory.getKeySpec(msgkey, DESedeKeySpec.class);
            byte[] plainKey = spec.getKey();
            int cryptDataSize = this.getCryptDataSize(this.getInstEncKey().key);
            byte[] plainText = new byte[cryptDataSize];
            Arrays.fill(plainText, (byte)0);
            System.arraycopy(plainKey, 0, plainText, plainText.length - 16, 16);
            byte[] result = this.ctEncipher(plainText);
            result = HBCIPassportRSA.checkForCryptDataSize(result, cryptDataSize);
            return result;
        }
        catch (Exception ex) {
            throw new HBCI_Exception("*** can not encrypt message key", ex);
        }
    }

    @Override
    public byte[][] encrypt(byte[] plainMsg) {
        try {
            SecretKey msgkey = this.createMsgKey();
            byte[] cryptMsg = this.encryptMessage(plainMsg, msgkey);
            byte[] cryptKey = this.encryptKey(msgkey);
            byte[][] ret = new byte[][]{cryptKey, cryptMsg};
            return ret;
        }
        catch (Exception ex) {
            throw new HBCI_Exception("*** error while encrypting", ex);
        }
    }

    @Override
    public byte[] decrypt(byte[] cryptedKey, byte[] cryptedMsg) {
        try {
            byte[] plainKey = this.ctDecipher(cryptedKey);
            byte[] realPlainKey = new byte[24];
            System.arraycopy(plainKey, plainKey.length - 16, realPlainKey, 0, 16);
            System.arraycopy(plainKey, plainKey.length - 16, realPlainKey, 16, 8);
            DESedeKeySpec spec = new DESedeKeySpec(realPlainKey);
            String provider = CryptUtils.getSecurityProvider();
            SecretKeyFactory fac = provider == null ? SecretKeyFactory.getInstance("DESede") : SecretKeyFactory.getInstance("DESede", provider);
            SecretKey key = fac.generateSecret(spec);
            Cipher cipher = provider == null ? Cipher.getInstance("DESede/CBC/NoPadding") : Cipher.getInstance("DESede/CBC/NoPadding", provider);
            byte[] ivarray = new byte[8];
            Arrays.fill(ivarray, (byte)0);
            IvParameterSpec iv = new IvParameterSpec(ivarray);
            cipher.init(2, (Key)key, iv);
            return cipher.doFinal(cryptedMsg);
        }
        catch (Exception ex) {
            throw new HBCI_Exception("*** error while decrypting message", ex);
        }
    }

    @Override
    public void close() {
        super.close();
        this.resetPassphrase();
        this.setPINEntered(false);
        this.closeCT();
    }

    @Override
    public void saveBankData() {
        try {
            this.checkPIN();
            this.ctSaveBankData();
        }
        catch (Exception e) {
            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_PASSPORT_INSTSAVEERR"), e);
        }
    }

    @Override
    public void resetPassphrase() {
    }

    @Override
    public boolean hasInstSigKey() {
        return this.getInstSigKey() != null;
    }

    @Override
    public boolean hasInstEncKey() {
        return this.getInstEncKey() != null;
    }

    @Override
    public boolean hasMySigKey() {
        return this.getMyPublicSigKey() != null;
    }

    @Override
    public boolean hasMyEncKey() {
        return this.getMyPublicEncKey() != null;
    }

    @Override
    public HBCIKey getMyPublicSigKey() {
        return this.getKey(2);
    }

    @Override
    public HBCIKey getMyPublicEncKey() {
        return this.getKey(3);
    }

    @Override
    public HBCIKey getMyPublicDigKey() {
        return null;
    }

    @Override
    public HBCIKey getMyPrivateSigKey() {
        return this.getMyPublicSigKey();
    }

    @Override
    public HBCIKey getMyPrivateEncKey() {
        return this.getMyPublicEncKey();
    }

    @Override
    public HBCIKey getMyPrivateDigKey() {
        return this.getMyPublicDigKey();
    }

    @Override
    public HBCIKey getInstSigKey() {
        return this.getKey(0);
    }

    @Override
    public HBCIKey getInstEncKey() {
        return this.getKey(1);
    }

    @Override
    public void saveChanges() {
        try {
            this.checkPIN();
            this.ctSaveBankData();
            this.ctSaveSigId();
            PassportData data = new PassportData();
            data.bpd = this.getBPD();
            data.upd = this.getUPD();
            data.hbciVersion = this.getHBCIVersion();
            data.sysId = this.getSysId();
            data.customerId = this.getCustomerId();
            PassportStorage.save((HBCIPassport)this, data, new File(this.getFileName()));
        }
        catch (HBCI_Exception he) {
            throw he;
        }
        catch (Exception e) {
            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_PASSPORT_WRITEERR"), e);
        }
    }

    public void readBankData() {
        try {
            this.checkPIN();
            this.ctReadBankData();
        }
        catch (Exception e) {
            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_PASSPORT_INSTSAVEERR"), e);
        }
    }

    public void readKeyData() {
        try {
            this.checkPIN();
            this.ctReadKeyData();
        }
        catch (Exception e) {
            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_PASSPORT_INSTSAVEERR"), e);
        }
    }

    private void checkPIN() {
        block12: {
            try {
                if (this.isPINEntered()) break block12;
                if (this.getUseSoftPin() == 1) {
                    String pin = HBCIUtils.getParam(this.getParamHeader() + ".pin");
                    if (pin == null || pin.length() == 0) {
                        StringBuffer temppin = new StringBuffer();
                        HBCIUtilsInternal.getCallback().callback(this, 4, HBCIUtilsInternal.getLocMsg("CALLB_NEED_SOFTPIN"), 1, temppin);
                        if (temppin.length() == 0) {
                            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_PINZERO"));
                        }
                        pin = temppin.toString();
                        LogFilter.getInstance().addSecretData(pin, "X", 1);
                    }
                    this.setSoftPin(pin.getBytes("ISO-8859-1"));
                } else {
                    HBCIUtilsInternal.getCallback().callback(this, 3, HBCIUtilsInternal.getLocMsg("CALLB_NEED_HARDPIN"), 0, null);
                }
                try {
                    this.ctEnterPIN();
                    this.setPINEntered(true);
                }
                catch (Exception e) {
                    HBCIUtils.setParam(this.getParamHeader() + ".pin", null);
                    this.setSoftPin(new byte[0]);
                }
                finally {
                    if (this.getUseSoftPin() != 1) {
                        HBCIUtilsInternal.getCallback().callback(this, 5, null, 0, null);
                    }
                }
            }
            catch (Exception e) {
                throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_PINERR"), e);
            }
        }
    }

    protected void initCT() {
        this.cardService = (RSACardService)SmartCardService.createInstance(RSACardService.class, HBCIUtils.getParam(this.getParamHeader() + ".pcsc.name", null));
        this.setCID(this.cardService.getCID());
        this.setCardId(this.cardService.getCardId());
    }

    protected void ctEnterPIN() {
        if (this.getUseSoftPin() == 1) {
            this.cardService.verifySoftPIN(16, this.getSoftPin());
        } else {
            this.cardService.verifyHardPIN(16);
        }
    }

    protected void ctReadBankData() {
        int idx = this.getEntryIdx() - 1;
        RSABankData bankData = this.cardService.readBankData(idx);
        this.setBLZ(bankData.getBankCode());
        this.setCountry(SyntaxCtr.getName(bankData.getCountry()));
        this.setHost(bankData.getComAddress());
        this.setUserId(bankData.getUserId());
        this.setBankId(bankData.getBankId());
        this.setSysId(bankData.getSystemId());
        this.setDefaultCustomerId(bankData.getCustomerId());
    }

    protected void ctSaveBankData() {
        int idx = this.getEntryIdx() - 1;
        RSABankData bankData = this.cardService.readBankData(idx);
        bankData.setCountry(SyntaxCtr.getCode(this.getCountry()));
        bankData.setBankCode(this.getBLZ());
        bankData.setComAddress(this.getHost());
        bankData.setUserId(this.getUserId());
        bankData.setBankId(this.getBankId());
        this.cardService.writeBankData(idx, bankData);
    }

    protected void ctReadKeyData() {
        int idx = this.getEntryIdx() - 1;
        this.setSigId(new Long(this.cardService.readSigId(idx)));
        RSAKeyData[] keyData = this.cardService.readKeyData(idx);
        if (keyData[0].getStatus() == 16 && keyData[0].getKeyType() == 83) {
            HBCIUtils.log("found valid instSigKey ", 4);
            this.setInstSigKey(new HBCIKey(this.getCountry(), this.getBLZ(), this.getBankId(), Integer.toString(keyData[0].getKeyNum()), Integer.toString(keyData[0].getKeyVersion()), keyData[0].getPublicKey()));
        }
        if (keyData[1].getStatus() == 16 && keyData[1].getKeyType() == 86) {
            HBCIUtils.log("found valid instEncKey ", 4);
            this.setInstEncKey(new HBCIKey(this.getCountry(), this.getBLZ(), this.getBankId(), Integer.toString(keyData[1].getKeyNum()), Integer.toString(keyData[1].getKeyVersion()), keyData[1].getPublicKey()));
        }
        if (keyData[2].getStatus() == 16 && keyData[2].getKeyType() == 83) {
            HBCIUtils.log("found valid myPublicSigKey ", 4);
            this.setMyPublicSigKey(new HBCIKey(this.getCountry(), this.getBLZ(), this.getUserId(), Integer.toString(keyData[2].getKeyNum()), Integer.toString(keyData[2].getKeyVersion()), keyData[2].getPublicKey()));
        }
        if (keyData[3].getStatus() == 16 && keyData[3].getKeyType() == 86) {
            HBCIUtils.log("found valid myPublicEncKey ", 4);
            this.setMyPublicEncKey(new HBCIKey(this.getCountry(), this.getBLZ(), this.getUserId(), Integer.toString(keyData[3].getKeyNum()), Integer.toString(keyData[3].getKeyVersion()), keyData[3].getPublicKey()));
        }
    }

    protected void ctSaveSigId() {
        int idx = this.getEntryIdx() - 1;
        this.cardService.writeSigId(idx, this.getSigId().intValue());
    }

    protected byte[] ctSign(byte[] data) {
        int idx = this.getEntryIdx() - 1;
        return this.cardService.sign(idx, data);
    }

    protected boolean ctVerify(byte[] data, byte[] sig) {
        int idx = this.getEntryIdx() - 1;
        return this.cardService.verify(idx, data, sig);
    }

    protected byte[] ctEncipher(byte[] data) {
        int idx = this.getEntryIdx() - 1;
        return this.cardService.encipher(idx, data);
    }

    protected byte[] ctDecipher(byte[] data) {
        int idx = this.getEntryIdx() - 1;
        return this.cardService.decipher(idx, data);
    }

    protected void closeCT() {
        try {
            if (this.cardService != null) {
                this.cardService.close();
            }
        }
        finally {
            this.cardService = null;
        }
    }
}

