/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.passport;

import java.io.File;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.HBCIUtilsInternal;
import org.kapott.hbci.manager.LogFilter;
import org.kapott.hbci.passport.AbstractRDHSWFileBasedPassport;
import org.kapott.hbci.tools.IOUtils;

public class HBCIPassportSIZRDHFile
extends AbstractRDHSWFileBasedPassport {
    private String passphrase;

    private native void readData(String var1);

    private native void saveData(String var1);

    public HBCIPassportSIZRDHFile(Object init, int dummy) {
        super(init);
    }

    public HBCIPassportSIZRDHFile(Object initObject) {
        this(initObject, 0);
        this.setParamHeader("client.passport.SIZRDHFile");
        String filename = HBCIUtils.getParam(this.getParamHeader() + ".filename");
        if (filename == null) {
            throw new NullPointerException(this.getParamHeader() + ".filename must not be null");
        }
        boolean init = HBCIUtils.getParam(this.getParamHeader() + ".init", "1").equals("1");
        String libname = HBCIUtils.getParam(this.getParamHeader() + ".libname");
        if (libname == null) {
            throw new NullPointerException(this.getParamHeader() + ".libname must not be null");
        }
        System.load(libname);
        HBCIUtils.log("loading passport data from file " + filename, 4);
        this.setFilename(filename);
        if (init) {
            HBCIUtils.log("loading data from file " + filename, 4);
            this.setFilterType("None");
            this.setPort(new Integer(3000));
            if (!new File(filename).canRead()) {
                HBCIUtils.log("have to create new passport file", 2);
                this.askForMissingData(false, true, true, false, false, true, false);
                this.saveChanges();
            }
            try {
                if (this.passphrase == null) {
                    StringBuffer retData = new StringBuffer();
                    HBCIUtilsInternal.getCallback().callback(this, 21, HBCIUtilsInternal.getLocMsg("CALLB_NEED_PASS"), 1, retData);
                    LogFilter.getInstance().addSecretData(retData.toString(), "X", 1);
                    this.setPassphrase(retData.toString());
                }
                this.setCountry("DE");
                this.setPort(new Integer(3000));
                this.readData(this.getFilename());
                if (this.askForMissingData(false, true, true, false, false, true, true)) {
                    this.saveChanges();
                }
            }
            catch (Exception e) {
                throw new HBCI_Exception("*** error while reading passport file", e);
            }
        }
    }

    private void setPassphrase(String st) {
        this.passphrase = st;
    }

    public String getPassphrase() {
        return this.passphrase;
    }

    @Override
    public void resetPassphrase() {
        this.passphrase = null;
    }

    @Override
    public void saveChanges() {
        try {
            File passportfile = new File(this.getFilename());
            File directory = passportfile.getAbsoluteFile().getParentFile();
            String prefix = passportfile.getName() + "_";
            File tempfile = File.createTempFile(prefix, "", directory);
            this.saveData(tempfile.getAbsolutePath());
            IOUtils.safeReplace(passportfile, tempfile);
        }
        catch (Exception e) {
            throw new HBCI_Exception("*** saving of passport file failed", e);
        }
    }

    public int askForEntryIdx(String possibilities) {
        StringBuffer sb = new StringBuffer(possibilities);
        HBCIUtilsInternal.getCallback().callback(this, 23, "*** select one of the following entries", 2, sb);
        return Integer.parseInt(sb.toString());
    }

    @Override
    public String getProfileVersion() {
        return "1";
    }
}

