/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.passport;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.interfaces.RSAPublicKey;
import java.util.Date;
import org.kapott.cryptalgs.SignatureParamSpec;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.HBCIKey;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.HBCIPassport;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.passport.InitLetterPassport;

public class INILetter {
    public static final int TYPE_INST = 1;
    public static final int TYPE_USER = 2;
    private HBCIPassportInternal passport;
    private HBCIKey hbcikey;

    public INILetter(HBCIPassport passport, int type) {
        this.passport = (HBCIPassportInternal)passport;
        if (type == 1) {
            this.hbcikey = passport.getInstSigKey();
            if (this.hbcikey == null) {
                this.hbcikey = passport.getInstEncKey();
            }
        } else {
            this.hbcikey = passport.getMyPublicSigKey();
        }
    }

    public static byte[] formatKeyData(BigInteger x, int minsize) {
        byte[] xArray = x.toByteArray();
        int realbits = x.bitLength();
        int realbytes = realbits >> 3;
        if ((realbits & 7) != 0) {
            ++realbytes;
        }
        int finalsize = Math.max(minsize, realbytes);
        byte[] retArray = new byte[finalsize];
        System.arraycopy(xArray, xArray.length - realbytes, retArray, finalsize - realbytes, realbytes);
        return retArray;
    }

    private BigInteger getModulus() {
        return ((RSAPublicKey)this.hbcikey.key).getModulus();
    }

    private BigInteger getExponent() {
        return ((RSAPublicKey)this.hbcikey.key).getPublicExponent();
    }

    public byte[] getKeyModulusDisplay() {
        int minsize = this.passport.getProfileVersion().equals("1") ? 96 : 0;
        return INILetter.formatKeyData(this.getModulus(), minsize);
    }

    public byte[] getKeyExponentDisplay() {
        int minsize = this.passport.getProfileVersion().equals("1") ? 96 : this.getKeyModulusDisplay().length;
        return INILetter.formatKeyData(this.getExponent(), minsize);
    }

    public byte[] getKeyHashDisplay() {
        try {
            byte[] modulus = INILetter.formatKeyData(this.getModulus(), 128);
            int modSize = modulus.length;
            byte[] exponent = INILetter.formatKeyData(this.getExponent(), Math.max(128, modSize));
            int expSize = exponent.length;
            byte[] retArray = new byte[modSize + expSize];
            System.arraycopy(exponent, 0, retArray, 0, expSize);
            System.arraycopy(modulus, 0, retArray, expSize, modSize);
            SignatureParamSpec hashSpec = ((InitLetterPassport)((Object)this.passport)).getSignatureParamSpec();
            String provider = hashSpec.getProvider();
            MessageDigest dig = provider != null ? MessageDigest.getInstance(hashSpec.getHashAlg(), provider) : MessageDigest.getInstance(hashSpec.getHashAlg());
            return dig.digest(retArray);
        }
        catch (Exception e) {
            throw new HBCI_Exception("*** error while calculating hash value", e);
        }
    }

    public String toString() {
        StringWriter ret = new StringWriter();
        PrintWriter out = new PrintWriter(ret);
        Date date = new Date();
        out.println();
        out.println("INI-Brief HBCI");
        out.println();
        out.println();
        out.println("Datum:                       " + HBCIUtils.date2StringLocal(date));
        out.println();
        out.println("Uhrzeit:                     " + HBCIUtils.time2StringLocal(date));
        out.println();
        out.println("Empf\u00e4nger BLZ:               " + this.passport.getBLZ());
        out.println();
        out.println("Benutzerkennung:             " + this.passport.getUserId());
        out.println();
        out.println("Schl\u00fcsselnummer:             " + this.hbcikey.num);
        out.println();
        out.println("Schl\u00fcsselversion:            " + this.hbcikey.version);
        out.println();
        out.println("HBCI-Version:                " + this.passport.getHBCIVersion());
        out.println();
        out.println("Sicherheitsprofil:           " + this.passport.getProfileMethod() + " " + this.passport.getProfileVersion());
        out.println();
        out.println();
        out.println("\u00d6ffentlicher Schl\u00fcssel f\u00fcr die elektronische Signatur");
        out.println();
        out.println("  Exponent");
        out.println();
        String st = HBCIUtils.data2hex(this.getKeyExponentDisplay());
        int line = 0;
        while (line * 16 * 3 < st.length()) {
            out.println("    " + st.substring(line * 48, Math.min((line + 1) * 16 * 3, st.length())));
            ++line;
        }
        out.println();
        out.println("  Modulus");
        out.println();
        st = HBCIUtils.data2hex(this.getKeyModulusDisplay());
        line = 0;
        while (line * 16 * 3 < st.length()) {
            out.println("    " + st.substring(line * 48, Math.min((line + 1) * 16 * 3, st.length())));
            ++line;
        }
        out.println();
        out.println("  Hashwert");
        out.println();
        st = HBCIUtils.data2hex(this.getKeyHashDisplay());
        line = 0;
        while (line * 10 * 3 < st.length()) {
            out.println("    " + st.substring(line * 30, Math.min((line + 1) * 10 * 3, st.length())));
            ++line;
        }
        out.println();
        out.println("Ich best\u00e4tige hiermit den obigen \u00f6ffentlichen Schl\u00fcssel");
        out.println("f\u00fcr meine elektronische Signatur");
        out.println();
        out.println();
        out.println();
        out.println();
        out.println();
        out.println();
        out.println();
        out.println("Ort/Datum                                       Unterschrift");
        out.close();
        return ret.toString();
    }
}

