/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.passport.rdhXfile;

import java.io.ByteArrayOutputStream;
import java.util.Random;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.rdhXfile.TLV;

public class FileHeader
extends TLV {
    private int profileversion;
    private int version;
    private byte[] salt;
    private long nof_iterations;

    public FileHeader() {
        super(20054);
    }

    public FileHeader(TLV tlv) {
        super(tlv);
        int offset;
        byte[] data = this.getData();
        if (this.getLength() == 26) {
            this.profileversion = 2;
            offset = 0;
        } else {
            this.profileversion = data[1] << 8 | data[0] & 0xFF;
            offset = 2;
        }
        this.version = data[offset + 1] << 8 | data[offset + 0] & 0xFF;
        this.nof_iterations = ((long)data[offset + 25] & 0xFFL) << 24 | ((long)data[offset + 24] & 0xFFL) << 16 | ((long)data[offset + 23] & 0xFFL) << 8 | ((long)data[offset + 22] & 0xFFL) << 0;
        this.salt = new byte[20];
        System.arraycopy(data, offset + 2, this.salt, 0, 20);
        HBCIUtils.log("file is a RDH-" + this.profileversion + "-file in version " + this.version, 4);
    }

    public int getProfileVersion() {
        return this.profileversion;
    }

    public void setProfileVersion(int pversion) {
        this.profileversion = pversion;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public void setSalt(byte[] salt) {
        this.salt = salt;
    }

    public void setRandomSalt() {
        byte[] s = new byte[20];
        Random r = new Random();
        r.nextBytes(s);
        this.setSalt(s);
    }

    public long getNofIterations() {
        return this.nof_iterations;
    }

    public void setNofIterations(int nof_iterations) {
        this.nof_iterations = nof_iterations;
    }

    @Override
    public void updateData() {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            if (this.getProfileVersion() == 10) {
                os.write(this.int2ba(this.getProfileVersion()));
            }
            os.write(this.int2ba(this.getVersion()));
            os.write(this.getSalt());
            os.write(this.long2ba(this.getNofIterations()));
            this.setData(os.toByteArray());
        }
        catch (Exception e) {
            throw new HBCI_Exception(e);
        }
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("diskhead: profileversion=" + this.profileversion);
        ret.append("; version=" + this.version);
        ret.append("; nof_iterations=" + this.nof_iterations);
        ret.append("; salt=");
        for (int i = 0; i < this.salt.length; ++i) {
            int x = this.salt[i] & 0xFF;
            if (x < 0) {
                x += 256;
            }
            ret.append(Integer.toString(x, 16) + " ");
        }
        return ret.toString();
    }
}

