/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.passport.storage.format;

import java.security.GeneralSecurityException;
import javax.crypto.Cipher;
import org.kapott.hbci.exceptions.InvalidUserDataException;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.HBCIUtilsInternal;
import org.kapott.hbci.manager.LogFilter;
import org.kapott.hbci.passport.HBCIPassport;
import org.kapott.hbci.passport.storage.format.PassportFormat;
import org.kapott.hbci.tools.CryptUtils;

public abstract class AbstractFormat
implements PassportFormat {
    private static final String CACHE_KEY = "__cached_passphrase__";

    @Override
    public boolean supported() {
        try {
            this.getCipher();
            return true;
        }
        catch (Exception e) {
            HBCIUtils.log("no support for passport format " + this.getClass().getSimpleName() + ": " + e.getMessage(), 3);
            return false;
        }
    }

    protected Cipher getCipher() throws GeneralSecurityException {
        String provider = CryptUtils.getSecurityProvider();
        String alg = this.getCipherAlg();
        return provider != null ? Cipher.getInstance(alg, provider) : Cipher.getInstance(alg);
    }

    protected abstract String getCipherAlg();

    int getRetries() {
        return Integer.parseInt(HBCIUtils.getParam("client.retries.passphrase", "3"));
    }

    protected char[] getPassword(HBCIPassport passport, boolean forSaving) throws GeneralSecurityException {
        char[] pw = (char[])passport.getClientData(CACHE_KEY);
        if (pw != null && pw.length > 0) {
            return pw;
        }
        StringBuffer passphrase = new StringBuffer();
        HBCIUtilsInternal.getCallback().callback(passport, forSaving ? 22 : 21, forSaving ? HBCIUtilsInternal.getLocMsg("CALLB_NEED_PASS_NEW") : HBCIUtilsInternal.getLocMsg("CALLB_NEED_PASS"), 1, passphrase);
        if (passphrase.length() == 0) {
            throw new InvalidUserDataException(HBCIUtilsInternal.getLocMsg("EXCMSG_PASSZERO"));
        }
        String s = passphrase.toString();
        LogFilter.getInstance().addSecretData(s, "X", 1);
        pw = s.toCharArray();
        passport.setClientData(CACHE_KEY, pw);
        return pw;
    }
}

