/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.protocol.factory;

import java.util.Hashtable;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.MsgGen;
import org.kapott.hbci.protocol.MSG;
import org.kapott.hbci.tools.ObjectFactory;

public class MSGFactory
extends ObjectFactory {
    private static MSGFactory instance;

    public static synchronized MSGFactory getInstance() {
        if (instance == null) {
            instance = new MSGFactory();
        }
        return instance;
    }

    private MSGFactory() {
        super(Integer.parseInt(HBCIUtils.getParam("kernel.objpool.MSG", "8")));
    }

    public MSG createMSG(String type, MsgGen gen, Hashtable<String, String> clientValues) {
        MSG ret = (MSG)this.getFreeObject();
        if (ret == null) {
            ret = new MSG(type, gen, clientValues);
            this.addToUsedPool(ret);
        } else {
            try {
                ret.init(type, gen, clientValues);
                this.addToUsedPool(ret);
            }
            catch (Exception e) {
                this.addToFreePool(ret);
                throw (RuntimeException)e;
            }
        }
        return ret;
    }

    public MSG createMSG(String type, String res, int fullResLen, MsgGen gen) {
        return this.createMSG(type, res, fullResLen, gen, true);
    }

    public MSG createMSG(String type, String res, int fullResLen, MsgGen gen, boolean checkSeq) {
        return this.createMSG(type, res, fullResLen, gen, checkSeq, true);
    }

    public MSG createMSG(String type, String res, int fullResLen, MsgGen gen, boolean checkSeq, boolean checkValids) {
        MSG ret = (MSG)this.getFreeObject();
        if (ret == null) {
            ret = new MSG(type, res, fullResLen, gen, checkSeq, checkValids);
            this.addToUsedPool(ret);
        } else {
            try {
                ret.init(type, res, fullResLen, gen, checkSeq, checkValids);
                this.addToUsedPool(ret);
            }
            catch (Exception e) {
                this.addToFreePool(ret);
                throw (RuntimeException)e;
            }
        }
        return ret;
    }

    @Override
    public void unuseObject(Object o) {
        if (o != null) {
            ((MSG)o).destroy();
            super.unuseObject(o);
        }
    }
}

