/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.security.factory;

import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.IHandlerData;
import org.kapott.hbci.protocol.MSG;
import org.kapott.hbci.security.Crypt;
import org.kapott.hbci.tools.ObjectFactory;

public class CryptFactory
extends ObjectFactory {
    private static CryptFactory instance;

    public static synchronized CryptFactory getInstance() {
        if (instance == null) {
            HBCIUtils.log("creating new crypt factory", 4);
            instance = new CryptFactory();
        }
        return instance;
    }

    private CryptFactory() {
        super(Integer.parseInt(HBCIUtils.getParam("kernel.objpool.Crypt", "8")));
    }

    public Crypt createCrypt(IHandlerData handlerdata, MSG msg) {
        HBCIUtils.log("checking if crypt available in pool", 4);
        Crypt ret = (Crypt)this.getFreeObject();
        if (ret == null) {
            HBCIUtils.log("no, creating new crypt", 4);
            ret = new Crypt(handlerdata, msg);
            HBCIUtils.log("adding to used pool", 4);
            this.addToUsedPool(ret);
        } else {
            try {
                HBCIUtils.log("yes, initializing with handlerdata + message", 4);
                ret.init(handlerdata, msg);
                HBCIUtils.log("adding to used pool", 4);
                this.addToUsedPool(ret);
            }
            catch (RuntimeException e) {
                this.addToFreePool(ret);
                throw e;
            }
        }
        HBCIUtils.log("crypt acquired", 4);
        return ret;
    }

    @Override
    public void unuseObject(Object o) {
        if (o != null) {
            ((Crypt)o).destroy();
            super.unuseObject(o);
        }
    }
}

