/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.security.factory;

import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.IHandlerData;
import org.kapott.hbci.passport.HBCIPassportList;
import org.kapott.hbci.protocol.MSG;
import org.kapott.hbci.security.Sig;
import org.kapott.hbci.tools.ObjectFactory;

public class SigFactory
extends ObjectFactory {
    private static SigFactory instance;

    public static SigFactory getInstance() {
        if (instance == null) {
            instance = new SigFactory();
        }
        return instance;
    }

    private SigFactory() {
        super(Integer.parseInt(HBCIUtils.getParam("kernel.objpool.Sig", "8")));
    }

    public Sig createSig(IHandlerData handlerdata, MSG msg, HBCIPassportList passports) {
        Sig ret = (Sig)this.getFreeObject();
        if (ret == null) {
            ret = new Sig(handlerdata, msg, passports);
            this.addToUsedPool(ret);
        } else {
            try {
                ret.init(handlerdata, msg, passports);
                this.addToUsedPool(ret);
            }
            catch (RuntimeException e) {
                this.addToFreePool(ret);
                throw e;
            }
        }
        return ret;
    }

    @Override
    public void unuseObject(Object o) {
        if (o != null) {
            ((Sig)o).destroy();
            super.unuseObject(o);
        }
    }
}

