/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.smartcardio;

import java.io.IOException;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.smartcardio.SmartCardService;

public abstract class HBCICardService
extends SmartCardService {
    public final void verifyHardPIN(int pwdId) {
        try {
            byte[] response = this.getCard().transmitControlCommand(this.getFeatures().get((Object)SmartCardService.Feature.FEATURE_VERIFY_PIN_DIRECT), this.createPINVerificationDataStructure(pwdId));
            ResponseAPDU apdu = new ResponseAPDU(response);
            int sw = apdu.getSW();
            if (sw == 25536) {
                throw new HBCI_Exception("PIN falsch. Noch 1 Versuch");
            }
            if (sw == 25537) {
                throw new HBCI_Exception("PIN falsch. Noch 2 Versuche");
            }
            if (sw == 25538) {
                throw new HBCI_Exception("PIN falsch. Noch 3 Versuche");
            }
            if (sw == 25600) {
                throw new HBCI_Exception("PIN-Eingabe aufgrund Timeout abgebrochen");
            }
            if (sw == 25601) {
                throw new HBCI_Exception("PIN-Eingabe vom User abgebrochen");
            }
            if (sw == 27011) {
                throw new HBCI_Exception("Chipkarte ist gesperrt oder besitzt ein unbekanntes Format");
            }
            this.check(apdu, new byte[]{-112});
        }
        catch (HBCI_Exception he) {
            throw he;
        }
        catch (Exception e) {
            throw new HBCI_Exception(e);
        }
    }

    public void verifySoftPIN(int pwdId, byte[] softPin) {
        byte[] body = new byte[]{37, -1, -1, -1, -1, -1, -1, -1};
        for (int i = 0; i < softPin.length; ++i) {
            int n = 1 + (i >> 1);
            body[n] = (byte)(body[n] & (byte)(15 << 4 * (i & 1) & 0xFF));
            int n2 = 1 + (i >> 1);
            body[n2] = (byte)(body[n2] | (byte)(softPin[i] - 48 << 4 - 4 * (i & 1) & 0xFF));
        }
        CommandAPDU command = new CommandAPDU(0, 32, 0, (int)((byte)(0x80 | pwdId)), body);
        this.send(command);
    }

    public abstract String getCID();

    public String getCardId() {
        String cids = this.getCID();
        byte[] cid = cids.getBytes();
        StringBuffer cardId = new StringBuffer();
        for (int i = 0; i < cid.length; ++i) {
            cardId.append((char)((cid[i] >> 4 & 0xF) + 48));
            cardId.append((char)((cid[i] & 0xF) + 48));
        }
        return cardId.toString();
    }

    protected abstract byte[] createPINVerificationDataStructure(int var1) throws IOException;
}

