/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.smartcardio;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.smartcardio.SmartCardService;

public class RSAKeyData {
    private final int index;
    private final Type type;
    private final int status;
    private final int keyType;
    private final int keyNum;
    private final int keyVersion;
    private final PublicKey publicKey;

    public RSAKeyData(int index, Type type, byte[] keyLogData, byte[] publicKeyData) {
        int offset = type.pos * 8;
        if (keyLogData.length < offset + 8) {
            throw new HBCI_Exception("keyLogData too short");
        }
        this.index = index;
        this.type = type;
        this.status = keyLogData[offset];
        this.keyType = keyLogData[offset + 1];
        this.keyNum = Integer.valueOf(new String(keyLogData, offset + 2, 3, SmartCardService.CHARSET).trim());
        this.keyVersion = Integer.valueOf(new String(keyLogData, offset + 5, 3, SmartCardService.CHARSET).trim());
        if (publicKeyData == null || this.status != 16) {
            this.publicKey = null;
        } else {
            if (publicKeyData.length < 121) {
                throw new HBCI_Exception("publicKeyData too short");
            }
            byte algoByte = publicKeyData[6];
            if ((algoByte & 1) == 0) {
                throw new HBCI_Exception("invalid public key type");
            }
            int modLen = publicKeyData[14];
            byte[] modulus = new byte[modLen];
            byte[] publicExponent = new byte[3];
            if ((algoByte & 8) == 0) {
                System.arraycopy(publicKeyData, 20, modulus, 0, modLen);
                System.arraycopy(publicKeyData, 20 + modLen, publicExponent, 0, 3);
            } else {
                int n;
                for (n = 0; n < modLen; ++n) {
                    modulus[n] = publicKeyData[20 + modLen - 1 - n];
                }
                for (n = 0; n < 3; ++n) {
                    publicExponent[n] = publicKeyData[20 + modLen + 3 - 1 - n];
                }
            }
            RSAPublicKeySpec keySpec = new RSAPublicKeySpec(new BigInteger(modulus), new BigInteger(publicExponent));
            try {
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                this.publicKey = keyFactory.generatePublic(keySpec);
            }
            catch (NoSuchAlgorithmException e) {
                throw new HBCI_Exception("no support for RSA available", e);
            }
            catch (InvalidKeySpecException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public int getIndex() {
        return this.index;
    }

    public Type getType() {
        return this.type;
    }

    public int getStatus() {
        return this.status;
    }

    public int getKeyType() {
        return this.keyType;
    }

    public int getKeyNum() {
        return this.keyNum;
    }

    public int getKeyVersion() {
        return this.keyVersion;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public String toString() {
        return "index=" + this.index + " type=" + (Object)((Object)this.type) + " keyType=0x" + Integer.toHexString(this.keyType) + " status=0x" + Integer.toHexString(this.status) + " keyNum=" + this.keyNum + " keyVersion=" + this.keyVersion + " publicKey=" + this.publicKey;
    }

    public static enum Type {
        ENCIPHER(0),
        SIGN(1),
        DECIPHER(2),
        VERIFY(3);

        private final int pos;

        private Type(int pos) {
            this.pos = pos;
        }
    }
}

