/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.smartcardio;

import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CardTerminals;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import javax.smartcardio.TerminalFactory;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.HBCIUtils;

public abstract class SmartCardService {
    static final Charset CHARSET = Charset.forName("ISO-8859-1");
    private static final Map<String, String> statusCodes = new HashMap<String, String>();
    static final int HBCI_DDV_EF_ID = 25;
    static final int HBCI_DDV_EF_BNK = 26;
    static final int HBCI_DDV_EF_MAC = 27;
    static final int HBCI_DDV_EF_SEQ = 28;
    static final int SECCOS_SELECT_RET_NOTHING = 12;
    static final int SECCOS_CLA_EXT = 176;
    static final int SECCOS_CLA_SM_PROPR = 4;
    static final int SECCOS_CLA_SM1 = 8;
    static final int SECCOS_CLA_STD = 0;
    static final int SECCOS_INS_GET_CHALLENGE = 132;
    static final int SECCOS_INS_GET_KEYINFO = 238;
    static final int SECCOS_INS_INT_AUTH = 136;
    static final int SECCOS_INS_PUT_DATA = 218;
    static final int SECCOS_INS_READ_BINARY = 176;
    static final int SECCOS_INS_READ_RECORD = 178;
    static final int SECCOS_INS_SELECT_FILE = 164;
    static final int SECCOS_INS_VERIFY = 32;
    static final int SECCOS_INS_UPDATE_RECORD = 220;
    static final int SECCOS_INS_WRITE_RECORD = 210;
    static final int SECCOS_KEY_TYPE_DF = 128;
    static final int SECCOS_PWD_TYPE_DF = 128;
    static final byte SECCOS_SM_CRT_CC = -76;
    static final byte SECCOS_SM_REF_INIT_DATA = -121;
    static final byte SECCOS_SM_RESP_DESCR = -70;
    static final byte SECCOS_SM_VALUE_LE = -106;
    private static final int IOCTL_GET_FEATURE_REQUEST;
    private Map<Feature, Integer> features = new HashMap<Feature, Integer>();
    private Card smartCard = null;

    public static <T extends SmartCardService> T createInstance(Class<? extends SmartCardService> type, String name) {
        if (type == null) {
            throw new HBCI_Exception("Kein Karten-Typ angegeben");
        }
        try {
            HBCIUtils.log("Starte Smartcard-Service (Typ " + type.getSimpleName() + ")", 3);
            TerminalFactory terminalFactory = TerminalFactory.getDefault();
            CardTerminals terminals = terminalFactory.terminals();
            if (terminals == null) {
                throw new HBCI_Exception("Kein Kartenleser gefunden");
            }
            List<CardTerminal> list = terminals.list();
            if (list == null || list.size() == 0) {
                throw new HBCI_Exception("Kein Kartenleser gefunden");
            }
            HBCIUtils.log("Gefundene Kartenleseger\u00e4te:", 3);
            for (CardTerminal t : list) {
                HBCIUtils.log("  " + t.getName(), 3);
            }
            CardTerminal terminal = null;
            if (name != null) {
                HBCIUtils.log("terminal name given, trying to open terminal: " + name, 4);
                terminal = terminals.getTerminal(name);
                if (terminal == null) {
                    throw new HBCI_Exception("Kartenleser \"" + name + "\" nicht gefunden");
                }
            } else {
                HBCIUtils.log("open first available card terminal", 4);
                terminal = list.get(0);
            }
            HBCIUtils.log("using card terminal " + terminal.getName(), 4);
            if (!terminal.waitForCardPresent(60000L)) {
                throw new HBCI_Exception("Keine Chipkarte in Kartenleser " + terminal.getName() + " gefunden");
            }
            Card smartCard = terminal.connect("*");
            if (smartCard == null) {
                throw new HBCI_Exception("Keine Karte angegeben");
            }
            String proto = smartCard.getProtocol();
            HBCIUtils.log("Kartetyp: " + proto, 3);
            if (proto == null || proto.indexOf("=") == -1) {
                throw new HBCI_Exception("Unbekannter Kartentyp");
            }
            if (Modifier.isAbstract(type.getModifiers())) {
                String id = proto.substring(proto.indexOf("=") + 1);
                String serviceName = type.getName() + id;
                HBCIUtils.log(" trying to load: " + serviceName, 4);
                type = Class.forName(serviceName);
            } else {
                HBCIUtils.log(" trying to load: " + type.getName(), 4);
            }
            SmartCardService cardService = type.newInstance();
            HBCIUtils.log(" using: " + cardService.getClass().getName(), 4);
            cardService.init(smartCard);
            return (T)cardService;
        }
        catch (HBCI_Exception he) {
            throw he;
        }
        catch (Exception e) {
            throw new HBCI_Exception(e);
        }
    }

    private static int SCARD_CTL_CODE(int code) {
        if (System.getProperty("os.name").toLowerCase().indexOf("windows") != -1) {
            return 0x310000 | code << 2;
        }
        return 0x42000000 + code;
    }

    public void close() {
        this.features.clear();
        if (this.smartCard == null) {
            return;
        }
        try {
            this.smartCard.disconnect(false);
        }
        catch (Exception e2) {
            throw new HBCI_Exception(e2);
        }
    }

    protected void init(Card card) {
        this.smartCard = card;
        try {
            HBCIUtils.log("querying features", 4);
            byte[] response = this.smartCard.transmitControlCommand(IOCTL_GET_FEATURE_REQUEST, new byte[0]);
            for (int i = 0; i < response.length; i += 6) {
                Integer ioctl = new Integer((0xFF & response[i + 2]) << 24) | (0xFF & response[i + 3]) << 16 | (0xFF & response[i + 4]) << 8 | 0xFF & response[i + 5];
                Feature feature = Feature.find(response[i]);
                if (feature == null) {
                    HBCIUtils.log("  unknown feature: " + Integer.toHexString(ioctl), 4);
                    continue;
                }
                HBCIUtils.log("  " + feature.name() + ": " + Integer.toHexString(ioctl), 4);
                this.features.put(feature, ioctl);
            }
        }
        catch (Exception e) {
            HBCIUtils.log("unable to query features, continuing without having a feature set, error: " + e.getMessage(), 2);
            HBCIUtils.log(e, 4);
        }
    }

    protected final Map<Feature, Integer> getFeatures() {
        return Collections.unmodifiableMap(this.features);
    }

    protected final Card getCard() {
        return this.smartCard;
    }

    protected final void writeRecordBySFI(int sfi, int idx, byte[] data) {
        CommandAPDU command = new CommandAPDU(0, 210, (int)((byte)(idx + 1)), (int)((byte)(sfi << 3 | 4)), data);
        this.send(command);
    }

    protected final void updateRecordBySFI(int sfi, int idx, byte[] data) {
        CommandAPDU command = new CommandAPDU(0, 220, idx + 1, sfi << 3 | 4, data);
        this.send(command);
    }

    protected final byte[] readRecordBySFI(int sfi, int idx) {
        CommandAPDU command = new CommandAPDU(0, 178, idx + 1, sfi << 3 | 4, 256);
        return this.receive(command);
    }

    protected byte[] readBinary(int offset, int length) {
        CommandAPDU command = new CommandAPDU(0, 176, offset >> 8 & 0x7F, offset & 0xFF, length == 0 ? 256 : length);
        return this.receive(command);
    }

    protected final void selectFile(int id) {
        CommandAPDU command = new CommandAPDU(0, 164, 0, 12, new byte[]{(byte)(id >> 8 & 0xFF), (byte)(id & 0xFF)});
        this.send(command);
    }

    protected final void selectSubFile(int id) {
        CommandAPDU command = new CommandAPDU(0, 164, 2, 12, new byte[]{(byte)(id >> 8 & 0xFF), (byte)(id & 0xFF)});
        this.send(command);
    }

    protected final byte[] getKeyInfo(int idx) {
        CommandAPDU command = new CommandAPDU(176, 238, 128, idx + 1, 256);
        return this.receive(command);
    }

    protected final void putData(int tag, byte[] data) {
        CommandAPDU command = new CommandAPDU(0, 218, (int)((byte)(tag >> 8 & 0xFF)), (int)((byte)(tag & 0xFF)), data);
        this.send(command);
    }

    protected final byte[] getChallenge() {
        CommandAPDU command = new CommandAPDU(0, 132, 0, 0, 8);
        return this.receive(command);
    }

    protected final byte[] internalAuthenticate(int keynum, byte[] challenge) {
        CommandAPDU command = new CommandAPDU(0, 136, 0, 0x80 | keynum, challenge, 8);
        return this.receive(command);
    }

    protected final void send(CommandAPDU command) {
        this.receive(command, new byte[]{-112, 97});
    }

    protected final byte[] receive(CommandAPDU command) {
        return this.receive(command, new byte[]{-112});
    }

    protected byte[] receive(CommandAPDU command, byte[] returncodes) {
        try {
            String caller = "";
            try {
                StackTraceElement[] stack = Thread.currentThread().getStackTrace();
                caller = stack[3].getMethodName();
            }
            catch (Exception stack) {
                // empty catch block
            }
            CardChannel channel = this.smartCard.getBasicChannel();
            ResponseAPDU response = channel.transmit(command);
            HBCIUtils.log(caller + " command : " + this.toHex(command.getBytes()), 4);
            HBCIUtils.log(caller + " response: " + this.toHex(response.getBytes()), 4);
            this.check(response, returncodes);
            return response.getData();
        }
        catch (HBCI_Exception e1) {
            throw e1;
        }
        catch (Exception e2) {
            throw new HBCI_Exception(e2);
        }
    }

    protected final void check(ResponseAPDU response, byte[] returncodes) {
        byte sw1 = (byte)response.getSW1();
        for (byte b : returncodes) {
            if (sw1 != b) continue;
            return;
        }
        String code = Integer.toHexString(response.getSW()).toUpperCase();
        String msg = statusCodes.get(code);
        if (msg != null) {
            throw new HBCI_Exception("Fehler " + code + ": " + msg);
        }
        throw new HBCI_Exception("Fehler " + code + " bei Kartenleser-Zugriff");
    }

    protected final String toHex(byte[] bytes) {
        return this.toHex(bytes, " ");
    }

    protected final String toHex(byte[] bytes, String sep) {
        StringBuffer sb = new StringBuffer();
        for (byte b : bytes) {
            String s = Integer.toHexString(b & 0xFF).toUpperCase();
            if (s.length() == 1) {
                sb.append("0");
            }
            sb.append(s);
            if (sep == null) continue;
            sb.append(sep);
        }
        return sb.toString();
    }

    public byte[] toBytes(String hex) {
        byte[] result = new byte[hex.length() / 2];
        for (int i = 0; i < result.length; ++i) {
            int index = i * 2;
            result[i] = (byte)Integer.parseInt(hex.substring(index, index + 2), 16);
        }
        return result;
    }

    protected final byte[] expand(String st, int len) {
        StringBuffer st_new = new StringBuffer(st);
        for (int i = st.length(); i < len; ++i) {
            st_new.append(" ");
        }
        return st_new.toString().getBytes(CHARSET);
    }

    static {
        statusCodes.put("6281", "Die zur\u00fcckgegebenen Daten k\u00f6nnen fehlerhaft sein");
        statusCodes.put("6282", "Da das Dateiende vorher erreicht wurde, konnten nur weniger als Le Bytes gelesen werden");
        statusCodes.put("6283", "Die ausgew\u00e4hlte Datei ist gesperrt");
        statusCodes.put("6284", "Die File Control Information (FCI) ist nicht ISO 7816-4 konform");
        statusCodes.put("6381", "File filled up by the last write");
        statusCodes.put("6581", "Speicherfehler");
        statusCodes.put("6700", "L\u00e4nge (Lc oder Le) falsch");
        statusCodes.put("6800", "Funktionen im Class Byte werden nicht unterst\u00fctzt");
        statusCodes.put("6881", "Logische Kan\u00e4le werden nicht unterst\u00fctzt");
        statusCodes.put("6882", "Secure Messaging wird nicht unterst\u00fctzt");
        statusCodes.put("6900", "Kommando nicht erlaubt");
        statusCodes.put("6981", "Kommando inkompatibel zur Dateistruktur");
        statusCodes.put("6982", "Sicherheitszustand nicht erf\u00fcllt");
        statusCodes.put("6983", "Authentisierungsmethode ist gesperrt");
        statusCodes.put("6984", "Referenzierte Daten sind gesperrt");
        statusCodes.put("6985", "Nutzungsbedingungen sind nicht erf\u00fcllt");
        statusCodes.put("6986", "Kommando nicht erlaubt (kein EF selektiert)");
        statusCodes.put("6987", "Erwartete Secure Messaging Objekte nicht gefunden");
        statusCodes.put("6988", "Secure Messaging Datenobjekte sind inkorrekt");
        statusCodes.put("6A00", "Falsche Parameter P1/P2");
        statusCodes.put("6A80", "Falsche Daten");
        statusCodes.put("6A81", "Funktion wird nicht unterst\u00fctzt");
        statusCodes.put("6A82", "Datei wurde nicht gefunden");
        statusCodes.put("6A83", "Record der Datei nicht gefunden");
        statusCodes.put("6A84", "Nicht gen\u00fcgend Speicherplatz in der Datei");
        statusCodes.put("6A85", "Lc nicht konsistent mit der TLV Struktur");
        statusCodes.put("6A86", "Inkorrekte Parameter P1/P2");
        statusCodes.put("6A87", "Lc inkonsistent mit P1/P2");
        statusCodes.put("6A88", "Referenzierte Daten nicht gefunden");
        statusCodes.put("6B00", "Parameter P1/P2 falsch");
        statusCodes.put("6D00", "Das Kommando (INS) wird nicht unterst\u00fctzt");
        statusCodes.put("6E00", "Die Kommandoklasse (CLA) wird nicht unterst\u00fctzt");
        statusCodes.put("6F00", "Kommando wurde mit unbekanntem Fehler abgebrochen");
        IOCTL_GET_FEATURE_REQUEST = SmartCardService.SCARD_CTL_CODE(3400);
    }

    protected static enum Feature {
        FEATURE_VERIFY_PIN_START(1),
        FEATURE_VERIFY_PIN_FINISH(2),
        FEATURE_MODIFY_PIN_START(3),
        FEATURE_MODIFY_PIN_FINISH(4),
        FEATURE_GET_KEY_PRESSED(5),
        FEATURE_VERIFY_PIN_DIRECT(6),
        FEATURE_MODIFY_PIN_DIRECT(7),
        FEATURE_MCT_READER_DIRECT(8),
        FEATURE_MCT_UNIVERSAL(9),
        FEATURE_IFD_PIN_PROPERTIES(10),
        FEATURE_ABORT(11),
        FEATURE_SET_SPE_MESSAGE(12),
        FEATURE_VERIFY_PIN_DIRECT_APP_ID(13),
        FEATURE_MODIFY_PIN_DIRECT_APP_ID(14),
        FEATURE_WRITE_DISPLAY(15),
        FEATURE_GET_KEY(16),
        FEATURE_IFD_DISPLAY_PROPERTIES(17),
        FEATURE_GET_TLV_PROPERTIES(18),
        FEATURE_CCID_ESC_COMMAND(19),
        FEATURE_EXECUTE_PACE(32);

        private byte number;

        private Feature(byte number) {
            this.number = number;
        }

        private static Feature find(byte b) {
            for (Feature f : Feature.values()) {
                if (b != f.number) continue;
                return f;
            }
            return null;
        }
    }
}

