/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.status;

import java.util.ArrayList;
import java.util.Arrays;
import org.kapott.hbci.manager.HBCIUtilsInternal;
import org.kapott.hbci.status.HBCIMsgStatus;

public final class HBCIDialogStatus {
    public HBCIMsgStatus[] msgStatus = null;
    public HBCIMsgStatus initStatus = null;
    public HBCIMsgStatus endStatus = null;

    public void setInitStatus(HBCIMsgStatus status) {
        this.initStatus = status;
    }

    public void setMsgStatus(HBCIMsgStatus[] status) {
        this.msgStatus = status;
    }

    public void setEndStatus(HBCIMsgStatus status) {
        this.endStatus = status;
    }

    public boolean isOK() {
        boolean ret;
        boolean bl = ret = this.initStatus != null && this.initStatus.isOK();
        if (this.msgStatus != null) {
            for (int i = 0; i < this.msgStatus.length; ++i) {
                ret &= this.msgStatus[i].isOK();
            }
        }
        return ret &= this.endStatus != null && this.endStatus.isOK();
    }

    public boolean hasExceptions() {
        boolean ret = false;
        if (this.initStatus != null) {
            ret |= this.initStatus.hasExceptions();
        }
        if (this.msgStatus != null) {
            for (int i = 0; i < this.msgStatus.length; ++i) {
                ret |= this.msgStatus[i].hasExceptions();
            }
        }
        if (this.endStatus != null) {
            ret |= this.endStatus.hasExceptions();
        }
        return ret;
    }

    public Exception[] getExceptions() {
        ArrayList<Exception> ret = new ArrayList<Exception>();
        if (this.initStatus != null) {
            ret.addAll(Arrays.asList(this.initStatus.getExceptions()));
        }
        if (this.msgStatus != null) {
            for (int i = 0; i < this.msgStatus.length; ++i) {
                ret.addAll(Arrays.asList(this.msgStatus[i].getExceptions()));
            }
        }
        if (this.endStatus != null) {
            ret.addAll(Arrays.asList(this.endStatus.getExceptions()));
        }
        return ret.toArray(new Exception[ret.size()]);
    }

    public String getErrorString() {
        String s;
        StringBuffer ret = new StringBuffer();
        if (this.initStatus != null && (s = this.initStatus.getErrorString()).length() != 0) {
            ret.append(s);
            ret.append(System.getProperty("line.separator"));
        }
        if (this.msgStatus != null) {
            for (int i = 0; i < this.msgStatus.length; ++i) {
                String s2 = this.msgStatus[i].getErrorString();
                if (s2.length() == 0) continue;
                ret.append(s2);
                ret.append(System.getProperty("line.separator"));
            }
        }
        if (this.endStatus != null && (s = this.endStatus.getErrorString()).length() != 0) {
            ret.append(s);
            ret.append(System.getProperty("line.separator"));
        }
        return ret.toString().trim();
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append(HBCIUtilsInternal.getLocMsg("STAT_INIT")).append(":").append(System.getProperty("line.separator"));
        if (this.initStatus != null) {
            ret.append(this.initStatus.toString());
        } else {
            ret.append("(not status information available)");
        }
        ret.append(System.getProperty("line.separator"));
        if (this.msgStatus != null) {
            for (int i = 0; i < this.msgStatus.length; ++i) {
                ret.append(HBCIUtilsInternal.getLocMsg("STAT_MSG")).append(" #").append(i + 1).append(":").append(System.getProperty("line.separator"));
                ret.append(this.msgStatus[i].toString());
                ret.append(System.getProperty("line.separator"));
            }
        }
        ret.append(HBCIUtilsInternal.getLocMsg("STAT_END")).append(":").append(System.getProperty("line.separator"));
        if (this.endStatus != null) {
            ret.append(this.endStatus.toString());
        } else {
            ret.append("(not status information available)");
        }
        ret.append(System.getProperty("line.separator"));
        return ret.toString().trim();
    }
}

