/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.status;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.status.HBCIDialogStatus;

public class HBCIExecStatus {
    private Map<String, HBCIDialogStatus> statusData = new Hashtable<String, HBCIDialogStatus>();
    private Map<String, ArrayList<Exception>> exceptions = new Hashtable<String, ArrayList<Exception>>();

    public List<String> getCustomerIds() {
        Set<String> eset;
        HashSet<String> ret = new HashSet<String>();
        Set<String> sset = this.statusData.keySet();
        if (sset != null) {
            ret.addAll(sset);
        }
        if ((eset = this.exceptions.keySet()) != null) {
            ret.addAll(eset);
        }
        return new ArrayList<String>(ret);
    }

    public void addDialogStatus(String customerid, HBCIDialogStatus status) {
        if (status != null) {
            this.statusData.put(customerid, status);
        } else {
            this.statusData.remove(customerid);
        }
    }

    public void addException(String customerid, Exception e) {
        ArrayList<Exception> exc = this.exceptions.get(customerid);
        if (exc == null) {
            exc = new ArrayList();
            this.exceptions.put(customerid, exc);
        }
        exc.add(e);
        HBCIUtils.log(e);
    }

    public List<HBCIDialogStatus> getDialogStatusList() {
        Collection<HBCIDialogStatus> values = this.statusData.values();
        return values != null ? new ArrayList<HBCIDialogStatus>(values) : new ArrayList();
    }

    public HBCIDialogStatus getDialogStatus(String customerid) {
        return this.statusData.get(customerid);
    }

    public List<Exception> getExceptions(String customerid) {
        return this.exceptions.get(customerid);
    }

    public String getErrorString() {
        StringBuffer ret = new StringBuffer();
        String linesep = System.getProperty("line.separator");
        int nofCustomerIds = this.getCustomerIds().size();
        for (String customerid : this.getCustomerIds()) {
            String errMsg;
            HBCIDialogStatus status;
            boolean customeridWritten = false;
            List<Exception> exc = this.getExceptions(customerid);
            if (exc != null && exc.size() != 0) {
                if (nofCustomerIds > 1) {
                    ret.append("Dialog for '").append(customerid).append("':").append(linesep);
                    customeridWritten = true;
                }
                Iterator<Exception> j = exc.iterator();
                while (j.hasNext()) {
                    ret.append(HBCIUtils.exception2StringShort(j.next()));
                    ret.append(linesep);
                }
            }
            if ((status = this.getDialogStatus(customerid)) == null || (errMsg = status.getErrorString()).length() == 0) continue;
            if (nofCustomerIds > 1 && !customeridWritten) {
                ret.append("Dialog for '").append(customerid).append("':").append(linesep);
                customeridWritten = true;
            }
            ret.append(errMsg + linesep);
        }
        return ret.toString().trim();
    }

    public String toString(String customerId) {
        HBCIDialogStatus status;
        StringBuffer ret = new StringBuffer();
        String linesep = System.getProperty("line.separator");
        List<Exception> exc = this.getExceptions(customerId);
        if (exc != null) {
            Iterator<Exception> j = exc.iterator();
            while (j.hasNext()) {
                ret.append(HBCIUtils.exception2StringShort(j.next()));
                ret.append(linesep);
            }
        }
        if ((status = this.getDialogStatus(customerId)) != null) {
            ret.append(status.toString() + linesep);
        }
        return ret.toString().trim();
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        String linesep = System.getProperty("line.separator");
        for (String customerid : this.getCustomerIds()) {
            ret.append("Dialog for '");
            ret.append(customerid);
            ret.append("':");
            ret.append(linesep);
            ret.append(this.toString(customerid));
            ret.append(linesep);
        }
        return ret.toString().trim();
    }

    public boolean isOK(String customerId) {
        boolean ok = true;
        List<Exception> exc = this.getExceptions(customerId);
        HBCIDialogStatus status = this.getDialogStatus(customerId);
        ok &= exc == null;
        return ok &= status != null && status.isOK();
    }

    public boolean isOK() {
        boolean ok = true;
        List<String> customerIds = this.getCustomerIds();
        for (String customerId : customerIds) {
            ok &= this.isOK(customerId);
        }
        return ok;
    }
}

