/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.swift;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Swift {
    private static final Pattern PATTERN_NL_TAG = Pattern.compile("\\r\\n(-|-\\r\\n)?:\\d{2}[A-Z]?:");

    public static String getOneBlock(StringBuffer stream) {
        String ret = null;
        int endpos = stream.indexOf("\r\n:20:", 1);
        if (endpos == -1) {
            endpos = stream.length();
        }
        if (endpos > 0) {
            ret = stream.substring(0, endpos);
        }
        return ret;
    }

    public static String getTagValue(String st, String tag, int counter) {
        int startpos;
        String ret = null;
        int endpos = 0;
        do {
            ret = null;
            startpos = st.indexOf("\r\n:" + tag + ":", endpos);
            int skipLength = 3;
            if (startpos == -1) {
                startpos = st.indexOf("\r\n-:" + tag + ":", endpos);
                skipLength = 4;
            }
            if (startpos == -1) continue;
            Matcher matcher = PATTERN_NL_TAG.matcher(st);
            if (matcher.find(startpos += skipLength + tag.length() + 1)) {
                endpos = matcher.start();
                ret = st.substring(startpos, endpos);
                continue;
            }
            ret = st.substring(startpos);
            ret = ret.replaceAll("[\\r\\n-]{0,10}", "");
        } while (counter-- != 0 && startpos != -1);
        return ret;
    }

    public static String packMulti(String st) {
        return st.replaceAll("\r\n", "");
    }

    public static String getMultiTagValue(String st, String tag) {
        String ret = null;
        int pos = st.indexOf("?" + tag);
        if (pos != -1) {
            int searchpos = pos + 3;
            int endpos = -1;
            while (true) {
                if ((endpos = st.indexOf("?", searchpos)) != -1 && endpos + 2 < st.length()) {
                    if (st.charAt(endpos + 1) >= '0' && st.charAt(endpos + 1) <= '9' && st.charAt(endpos + 2) >= '0' && st.charAt(endpos + 2) <= '9') {
                        break;
                    }
                } else {
                    endpos = -1;
                    break;
                }
                searchpos = endpos + 1;
            }
            if (endpos == -1) {
                endpos = st.length();
            }
            ret = st.substring(pos + 3, endpos);
        }
        return ret;
    }

    public static String decodeUmlauts(String st) {
        String ret = st.replace('[', '\u00c4');
        ret = ret.replace('\\', '\u00d6');
        ret = ret.replace(']', '\u00dc');
        ret = ret.replace('~', '\u00df');
        return ret;
    }
}

