/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.tools;

import org.kapott.hbci.callback.HBCICallbackConsole;
import org.kapott.hbci.manager.BankInfo;
import org.kapott.hbci.manager.HBCIUtils;

public class CheckAccountCRC {
    public static void main(String[] args) {
        if (args.length < 1 || args.length > 2) {
            System.out.println("usage:");
            System.out.println("  CheckAccountCRC <blz> <accnumber>");
            System.out.println("  CheckAccountCRC <iban>");
            System.exit(1);
        }
        HBCIUtils.init(null, new HBCICallbackConsole());
        if (args.length == 2) {
            String alg;
            String blz = args[0];
            String number = args[1];
            BankInfo info = HBCIUtils.getBankInfo(blz);
            String kiname = info != null ? info.getName() : null;
            String string = alg = info != null ? info.getChecksumMethod() : null;
            if (kiname.length() != 0) {
                System.out.println("institute name: " + (kiname != null ? kiname : ""));
                System.out.println("algorithmus: " + (alg != null ? alg : ""));
                System.out.println("blz: " + blz);
                System.out.println("account number: " + number);
                System.out.println(HBCIUtils.checkAccountCRC(blz, number) ? "OK" : "not OK");
            } else {
                System.out.println("no information about " + blz + " in database");
            }
        } else {
            String iban = args[0];
            System.out.println("IBAN: " + iban);
            System.out.println(HBCIUtils.checkIBANCRC(iban) ? "OK" : "not OK");
        }
    }
}

