/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.tools;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import org.kapott.hbci.callback.HBCICallbackConsole;
import org.kapott.hbci.manager.HBCIInstitute;
import org.kapott.hbci.manager.HBCIKernelFactory;
import org.kapott.hbci.manager.HBCIKernelImpl;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.AbstractHBCIPassport;
import org.kapott.hbci.passport.HBCIPassport;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.passport.INILetter;

public class CollectHashCodes {
    public static void main(String[] args) throws Exception {
        HBCIUtils.init(null, new MyCallback());
        Properties blzs = new Properties();
        FileInputStream fin = new FileInputStream("src/blz.properties");
        blzs.load(fin);
        ((InputStream)fin).close();
        Enumeration<?> e = blzs.propertyNames();
        while (e.hasMoreElements()) {
            String blz = (String)e.nextElement();
            String host = HBCIUtils.getHBCIHostForBLZ(blz);
            if (host == null || host.length() == 0) continue;
            CollectHashCodes.addHashValue(blzs, blz);
        }
    }

    private static void addHashValue(Properties blzs, String blz) {
        System.out.println();
        System.out.println(blz + ": " + HBCIUtils.getNameForBLZ(blz));
        HBCIUtils.setParam("log.loglevel.default", "0");
        HBCIUtils.setParam("client.passport.RDHNew.filename", "passports/" + blz + ".passport");
        HBCIUtils.setParam("client.passport.RDHNew.init", "1");
        Properties data = new Properties();
        data.setProperty("blz", blz);
        data.setProperty("host", HBCIUtils.getHBCIHostForBLZ(blz));
        HBCIPassportInternal passport = (HBCIPassportInternal)AbstractHBCIPassport.getInstance("RDHNew", data);
        HBCIKernelImpl kernel = (HBCIKernelImpl)HBCIKernelFactory.getKernel(null, "210");
        HBCIInstitute inst = new HBCIInstitute(kernel, passport, true);
        try {
            inst.fetchBPD();
        }
        catch (Exception e) {
            System.out.println("  " + blz + ": fetching BPD failed");
        }
        if (passport.isSupported()) {
            try {
                inst.fetchKeys();
                System.out.println("  " + blz + ": found hashvalue " + data.getProperty("hash"));
            }
            catch (Exception e) {
                System.out.println("  " + blz + ": fetching keys failed");
                System.out.println(HBCIUtils.exception2StringShort(e));
            }
        } else {
            System.out.println("  " + blz + ": RDH not supported");
        }
    }

    private static class MyCallback
    extends HBCICallbackConsole {
        private MyCallback() {
        }

        @Override
        public void callback(HBCIPassport passport, int reason, String msg, int datatype, StringBuffer retData) {
            Properties data = (Properties)passport.getClientData("init");
            switch (reason) {
                case 8: {
                    retData.setLength(0);
                    retData.append(data.getProperty("blz"));
                    break;
                }
                case 7: {
                    retData.setLength(0);
                    retData.append("DE");
                    break;
                }
                case 9: {
                    retData.setLength(0);
                    retData.append(data.getProperty("host"));
                    break;
                }
                case 10: {
                    retData.setLength(0);
                    retData.append("3000");
                    break;
                }
                case 11: 
                case 18: 
                case 21: 
                case 22: {
                    retData.setLength(0);
                    retData.append("dummy");
                    break;
                }
                case 12: {
                    INILetter iniletter = new INILetter(passport, 1);
                    data.setProperty("hash", HBCIUtils.data2hex(iniletter.getKeyHashDisplay()));
                    break;
                }
            }
        }

        @Override
        public synchronized void status(HBCIPassport passport, int statusTag, Object[] o) {
        }
    }
}

